/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.testing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.modeldriven.brl.PortableObject;
import org.drools.guvnor.client.modeldriven.testing.ExecutionTrace;
import org.drools.guvnor.client.modeldriven.testing.Expectation;
import org.drools.guvnor.client.modeldriven.testing.FactData;
import org.drools.guvnor.client.modeldriven.testing.Fixture;
import org.drools.guvnor.client.modeldriven.testing.RetractFact;
import org.drools.guvnor.client.modeldriven.testing.VerifyFact;
import org.drools.guvnor.client.modeldriven.testing.VerifyField;
import org.drools.guvnor.client.modeldriven.testing.VerifyRuleFired;

public class Scenario
implements PortableObject {
    public int maxRuleFirings = 100000;
    public List<FactData> globals = new ArrayList<FactData>();
    public List<Fixture> fixtures = new ArrayList<Fixture>();
    public Date lastRunResult;
    public List<String> rules = new ArrayList<String>();
    public boolean inclusive = false;

    public boolean wasSuccessful() {
        for (Fixture f : this.fixtures) {
            if (!(f instanceof Expectation) || ((Expectation)f).wasSuccessful()) continue;
            return false;
        }
        return true;
    }

    public void insertBetween(Fixture fix, Fixture toAdd) {
        int start;
        boolean inserted = false;
        for (int j = start = fix == null ? 0 : this.fixtures.indexOf(fix) + 1; j < this.fixtures.size(); ++j) {
            Fixture f = this.fixtures.get(j);
            if (!(f instanceof ExecutionTrace)) continue;
            this.fixtures.add(j, toAdd);
            return;
        }
        if (!inserted) {
            this.fixtures.add(toAdd);
        }
    }

    public void removeFixture(Fixture f) {
        this.fixtures.remove(f);
        this.globals.remove(f);
    }

    public void removeExecutionTrace(ExecutionTrace et) {
        Fixture f;
        boolean remove = false;
        Iterator<Fixture> iterator = this.fixtures.iterator();
        while (iterator.hasNext()) {
            f = iterator.next();
            if (f.equals(et)) {
                remove = true;
                continue;
            }
            if (remove && (f instanceof ExecutionTrace || f instanceof FactData)) break;
            if (!remove) continue;
            iterator.remove();
            this.globals.remove(f);
        }
        Collections.reverse(this.fixtures);
        remove = false;
        iterator = this.fixtures.iterator();
        while (iterator.hasNext()) {
            f = iterator.next();
            if (f.equals(et)) {
                remove = true;
            } else if (remove && (f instanceof ExecutionTrace || f instanceof VerifyFact)) break;
            if (!remove) continue;
            iterator.remove();
            this.globals.remove(f);
        }
        Collections.reverse(this.fixtures);
    }

    public Map getVariableTypes() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Fixture f : this.fixtures) {
            if (!(f instanceof FactData)) continue;
            FactData fd = (FactData)f;
            m.put(fd.name, fd.type);
        }
        for (FactData fd : this.globals) {
            m.put(fd.name, fd.type);
        }
        return m;
    }

    public List getFactNamesInScope(ExecutionTrace ex, boolean includeGlobals) {
        if (ex == null) {
            return new ArrayList();
        }
        ArrayList<String> l = new ArrayList<String>();
        int p = this.fixtures.indexOf(ex);
        for (int i = 0; i < p; ++i) {
            Fixture fixture = this.fixtures.get(i);
            if (fixture instanceof FactData) {
                FactData fd = (FactData)fixture;
                l.add(fd.name);
                continue;
            }
            if (!(fixture instanceof RetractFact)) continue;
            RetractFact rf = (RetractFact)fixture;
            l.remove(rf.name);
        }
        if (includeGlobals) {
            for (FactData factData : this.globals) {
                l.add(factData.name);
            }
        }
        return l;
    }

    public boolean isFactNameExisting(String factName) {
        for (FactData fd : this.globals) {
            if (!fd.name.equals(factName)) continue;
            return true;
        }
        for (Fixture f : this.fixtures) {
            if (!(f instanceof FactData)) continue;
            FactData fd = (FactData)f;
            if (!fd.name.equals(factName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFactNameUsed(FactData fd) {
        int start = this.fixtures.indexOf(fd);
        for (int i = start + 1; i < this.fixtures.size(); ++i) {
            Fixture f = this.fixtures.get(i);
            if (!(f instanceof RetractFact ? ((RetractFact)f).name.equals(fd.name) : (f instanceof VerifyFact ? ((VerifyFact)f).name.equals(fd.name) : f instanceof FactData && ((FactData)f).name.equals(fd.name)))) continue;
            return true;
        }
        return false;
    }

    public int[] countFailuresTotal() {
        int total = 0;
        int failures = 0;
        for (Fixture f : this.fixtures) {
            if (f instanceof VerifyRuleFired) {
                ++total;
                VerifyRuleFired vr = (VerifyRuleFired)f;
                if (vr.successResult == null || vr.successResult.booleanValue()) continue;
                ++failures;
                continue;
            }
            if (!(f instanceof VerifyFact)) continue;
            VerifyFact vf = (VerifyFact)f;
            for (VerifyField vfl : vf.fieldValues) {
                if (vfl.successResult != null && !vfl.successResult.booleanValue()) {
                    ++failures;
                }
                ++total;
            }
        }
        return new int[]{failures, total};
    }

    public String printFailureReport() {
        int total = 0;
        int failures = 0;
        StringBuffer buf = new StringBuffer();
        buf.append("------- Unmet expectations: -------\n");
        for (Fixture f : this.fixtures) {
            if (f instanceof VerifyRuleFired) {
                ++total;
                VerifyRuleFired vr = (VerifyRuleFired)f;
                if (vr.successResult == null || vr.successResult.booleanValue()) continue;
                ++failures;
                buf.append(vr.explanation);
                buf.append('\n');
                continue;
            }
            if (!(f instanceof VerifyFact)) continue;
            VerifyFact vf = (VerifyFact)f;
            for (VerifyField vfl : vf.fieldValues) {
                if (vfl.successResult != null && !vfl.successResult.booleanValue()) {
                    ++failures;
                    buf.append(vfl.explanation);
                    buf.append('\n');
                }
                ++total;
            }
        }
        buf.append("\n------- Summary: ------\n");
        buf.append(failures + " failures out of " + total + " expectations.");
        return buf.toString();
    }
}

