/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.drools.lang.dsl.AbstractDSLMappingEntry;
import org.drools.lang.dsl.DSLMappingEntry;

public class AntlrDSLMappingEntry
extends AbstractDSLMappingEntry
implements DSLMappingEntry {
    private boolean headMatchGroupAdded = false;
    private boolean tailMatchGroupAdded = false;

    public AntlrDSLMappingEntry() {
        this(DSLMappingEntry.ANY, DSLMappingEntry.EMPTY_METADATA, null, null, null);
    }

    public AntlrDSLMappingEntry(DSLMappingEntry.Section section, DSLMappingEntry.MetaData metadata, String key, String value, String sentence) {
        this.section = section;
        this.metadata = metadata;
        this.setMappingKey(key);
        this.setMappingValue(value);
        this.sentence = sentence;
    }

    public void setMappingKey(String key) {
        if (key != null) {
            key = key.trim();
        }
        this.key = key;
        if (key != null) {
            int substr = 0;
            StringBuffer buf = new StringBuffer();
            if (!key.startsWith("^")) {
                buf.append("(\\W|^)").append(key);
                this.redistributeVariables();
                this.headMatchGroupAdded = true;
            }
            if (buf.toString().endsWith("(.*?)")) {
                buf.append("$");
            } else {
                buf.append("(\\W|$)");
                this.tailMatchGroupAdded = true;
            }
            String pat = buf.toString();
            if (key.substring(substr).trim().startsWith("-") && !key.substring(substr).trim().startsWith("-\\s*")) {
                pat = pat.substring(0, pat.indexOf(45) + 1) + "\\s*" + pat.substring(pat.indexOf(45) + 1).trim();
            }
            this.keyPattern = Pattern.compile(pat, 40);
        } else {
            this.keyPattern = null;
        }
    }

    private void redistributeVariables() {
        for (Map.Entry entry : this.variables.entrySet()) {
            Integer i = (Integer)entry.getValue();
            this.variables.put(entry.getKey(), new Integer(i + 1));
        }
    }

    public void setMappingValue(String value) {
        if (value != null) {
            StringBuffer valuePatternBuffer = new StringBuffer();
            StringBuffer valueBuffer = new StringBuffer();
            if (this.headMatchGroupAdded) {
                valuePatternBuffer.append("$1");
                valueBuffer.append("$1");
            }
            valuePatternBuffer.append(value);
            valueBuffer.append(value);
            if (this.tailMatchGroupAdded) {
                int maxGroupIndex = 0;
                if (!this.variables.isEmpty()) {
                    Integer tailMatchGroupIndex = (Integer)Collections.max(this.variables.values());
                    maxGroupIndex = tailMatchGroupIndex;
                } else if (this.headMatchGroupAdded) {
                    ++maxGroupIndex;
                }
                valuePatternBuffer.append("$" + ++maxGroupIndex);
                valueBuffer.append("$" + maxGroupIndex);
            }
            this.valuePattern = valuePatternBuffer.toString();
            this.value = valueBuffer.toString();
        }
    }
}

