/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Iterator;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.util.StringUtils;

public class JavaRuleClassBuilder
implements RuleClassBuilder {
    public String buildRule(RuleBuildContext context) {
        if (context.getMethods().isEmpty()) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("package " + context.getPkg().getName() + ";" + lineSeparator);
        Iterator<Object> it = context.getPkg().getImports().keySet().iterator();
        while (it.hasNext()) {
            buffer.append("import " + it.next() + ";");
        }
        it = context.getPkg().getStaticImports().iterator();
        while (it.hasNext()) {
            buffer.append("import static " + it.next() + ";");
        }
        buffer.append(lineSeparator);
        RuleDescr ruleDescr = context.getRuleDescr();
        buffer.append("public class " + StringUtils.ucFirst((String)ruleDescr.getClassName()) + " {" + lineSeparator);
        buffer.append("    private static final long serialVersionUID = 400L;" + lineSeparator);
        int size = context.getMethods().size() - 1;
        for (int i = 0; i < size; ++i) {
            buffer.append(context.getMethods().get(i) + lineSeparator);
        }
        String[] lines = buffer.toString().split(lineSeparator, -1);
        ruleDescr.setConsequenceOffset(lines.length);
        buffer.append(context.getMethods().get(context.getMethods().size() - 1) + lineSeparator);
        buffer.append("}");
        return buffer.toString();
    }
}

