/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class LiteralRestrictionHandler
extends BaseAbstractHandler
implements Handler {
    LiteralRestrictionHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(FieldConstraintDescr.class);
            this.validParents.add(RestrictionConnectiveDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(LiteralRestrictionDescr.class);
            this.validPeers.add(ReturnValueRestrictionDescr.class);
            this.validPeers.add(VariableRestrictionDescr.class);
            this.validPeers.add(RestrictionConnectiveDescr.class);
            this.validPeers.add(QualifiedIdentifierRestrictionDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        String evaluator = attrs.getValue("evaluator");
        if (evaluator == null || evaluator.trim().equals("")) {
            throw new SAXParseException("<literal-restriction> requires an 'evaluator' attribute", this.xmlPackageReader.getLocator());
        }
        String text = attrs.getValue("value");
        if (text == null || text.trim().equals("")) {
            throw new SAXParseException("<literal-restriction>  requires an 'value' attribute", this.xmlPackageReader.getLocator());
        }
        LiteralRestrictionDescr literalDescr = new LiteralRestrictionDescr(evaluator, text);
        return literalDescr;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        LiteralRestrictionDescr literalDescr = (LiteralRestrictionDescr)this.xmlPackageReader.getCurrent();
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator it = parents.listIterator(parents.size());
        it.previous();
        Object parent = it.previous();
        if (parent instanceof FieldConstraintDescr) {
            FieldConstraintDescr fieldConstriantDescr = (FieldConstraintDescr)parent;
            fieldConstriantDescr.addRestriction(literalDescr);
        } else if (parent instanceof RestrictionConnectiveDescr) {
            RestrictionConnectiveDescr restrictionDescr = (RestrictionConnectiveDescr)parent;
            restrictionDescr.addRestriction(literalDescr);
        }
        return null;
    }

    public Class generateNodeFor() {
        return LiteralRestrictionDescr.class;
    }
}

