/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;

public class MVELExprAnalyzer {
    public MVELAnalysisResult analyzeExpression(RuleBuildContext context, String expr, Set[] availableIdentifiers, Map localTypes) throws RecognitionException {
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(false);
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        Map imports = dialect.getClassImportResolverFactory().getImportedClasses();
        imports.putAll(dialect.getStaticMethodImportResolverFactory().getImportedMethods());
        parserContext.setImports(imports);
        parserContext.setInterceptors(dialect.getInterceptors());
        compiler.compile(parserContext);
        MVELAnalysisResult result = this.analyze(compiler.getParserContextState().getInputs().keySet(), availableIdentifiers);
        result.setMvelVariables(compiler.getParserContextState().getVariables());
        return result;
    }

    private MVELAnalysisResult analyze(Set identifiers, Set[] availableIdentifiers) throws RecognitionException {
        int i;
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(new ArrayList(identifiers));
        HashSet notBound = new HashSet(identifiers);
        List[] used = new List[availableIdentifiers.length];
        int length = used.length;
        for (i = 0; i < length; ++i) {
            used[i] = new ArrayList();
        }
        length = availableIdentifiers.length;
        for (i = 0; i < length; ++i) {
            Set set = availableIdentifiers[i];
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String eachDecl = (String)it.next();
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
                notBound.remove(eachDecl);
            }
        }
        result.setBoundIdentifiers(used);
        result.setNotBoundedIdentifiers(new ArrayList(notBound));
        return result;
    }
}

