/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.TypeResolver;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.DroolsMVELKnowledgeHelper;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.Dialect;
import org.drools.compiler.ImportError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.RuleError;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAccumulateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialectConfiguration;
import org.drools.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.rule.builder.dialect.mvel.MVELExprAnalyzer;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.rule.builder.dialect.mvel.MVELRuleClassBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.util.StringUtils;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.ParserContext;
import org.mvel.ast.WithNode;
import org.mvel.integration.Interceptor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.StaticMethodImportResolverFactory;
import org.mvel.optimizers.OptimizerFactory;

public class MVELDialect
implements Dialect {
    public static final String ID = "MVELDialect";
    private static final String EXPRESSION_DIALECT_NAME = "MVEL";
    private final MVELRuleClassBuilder rule = new MVELRuleClassBuilder();
    private final PatternBuilder pattern = new PatternBuilder();
    private final QueryBuilder query = new QueryBuilder();
    private final MVELAccumulateBuilder accumulate = new MVELAccumulateBuilder();
    private final SalienceBuilder salience = new MVELSalienceBuilder();
    private final MVELEvalBuilder eval = new MVELEvalBuilder();
    private final MVELPredicateBuilder predicate = new MVELPredicateBuilder();
    private final MVELReturnValueBuilder returnValue = new MVELReturnValueBuilder();
    private final MVELConsequenceBuilder consequence = new MVELConsequenceBuilder();
    private final MVELFromBuilder from = new MVELFromBuilder();
    private final JavaFunctionBuilder function = new JavaFunctionBuilder();
    private final CollectBuilder collect = new CollectBuilder();
    private final ForallBuilder forall = new ForallBuilder();
    private Map interceptors;
    private List results;
    private MemoryResourceReader src;
    private Package pkg;
    private MVELDialectConfiguration configuration;
    private TypeResolver typeResolver;
    private ClassFieldExtractorCache classFieldExtractorCache;
    private MVELExprAnalyzer analyzer;
    private StaticMethodImportResolverFactory staticImportFactory;
    private ClassImportResolverFactory importFactory;
    private boolean strictMode;
    private Map builders;

    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        throw new UnsupportedOperationException("MVEL does not support functions");
    }

    public void init(PackageBuilder builder) {
        AbstractParser.setLanguageLevel((int)4);
        this.pkg = builder.getPackage();
        this.configuration = (MVELDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration("mvel");
        this.typeResolver = builder.getTypeResolver();
        this.classFieldExtractorCache = builder.getClassFieldExtractorCache();
        this.strictMode = this.configuration.isStrict();
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        this.analyzer = new MVELExprAnalyzer();
        if (this.pkg != null) {
            this.init(this.pkg);
        }
        this.results = new ArrayList();
        this.initBuilder();
        this.interceptors = new HashMap(1);
        this.interceptors.put("Modify", new ModifyInterceptor());
        this.importFactory = new ClassImportResolverFactory();
        this.staticImportFactory = new StaticMethodImportResolverFactory();
        this.importFactory.setNextFactory((VariableResolverFactory)this.staticImportFactory);
    }

    public void initBuilder() {
        this.builders = new HashMap();
        GroupElementBuilder gebuilder = new GroupElementBuilder();
        this.builders.put(AndDescr.class, gebuilder);
        this.builders.put(OrDescr.class, gebuilder);
        this.builders.put(NotDescr.class, gebuilder);
        this.builders.put(ExistsDescr.class, gebuilder);
        this.builders.put(PatternDescr.class, this.getPatternBuilder());
        this.builders.put(FromDescr.class, this.getFromBuilder());
        this.builders.put(QueryDescr.class, this.getQueryBuilder());
        this.builders.put(AccumulateDescr.class, this.getAccumulateBuilder());
        this.builders.put(EvalDescr.class, this.getEvalBuilder());
        this.builders.put(CollectDescr.class, this.collect);
        this.builders.put(ForallDescr.class, this.forall);
        this.builders.put(FunctionDescr.class, this.function);
    }

    public void init(Package pkg) {
        this.pkg = pkg;
        this.results = new ArrayList();
        this.src = new MemoryResourceReader();
    }

    public void init(RuleDescr ruleDescr) {
        String pkgName = this.pkg == null ? "" : this.pkg.getName();
        String ruleClassName = JavaDialect.getUniqueLegalName(pkgName, ruleDescr.getName(), "mvel", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
        ruleDescr.setDialect(this);
    }

    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    public void addRule(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        String name = this.pkg.getName() + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getPackageCompilationData().getLineMappings().put(name, mapping);
    }

    public void addImport(String importEntry) {
        if (importEntry.endsWith("*")) {
            return;
        }
        try {
            Class cls = this.typeResolver.resolveType(importEntry);
            this.importFactory.addClass(cls);
        }
        catch (ClassNotFoundException e) {
            this.results.add(new ImportError(importEntry));
        }
    }

    public void addStaticImport(String staticImportEntry) {
        if (staticImportEntry.endsWith("*")) {
            return;
        }
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(0, index + 1);
        try {
            Class<?> cls = this.configuration.getPackageBuilderConfiguration().getClassLoader().loadClass(className);
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].equals("methodName")) continue;
                this.staticImportFactory.createVariable(methodName, (Object)methods[i]);
                break;
            }
        }
        catch (ClassNotFoundException e) {
            this.results.add(new ImportError(staticImportEntry));
        }
    }

    public StaticMethodImportResolverFactory getStaticMethodImportResolverFactory() {
        return this.staticImportFactory;
    }

    public ClassImportResolverFactory getClassImportResolverFactory() {
        return this.importFactory;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void compileAll() {
    }

    public Dialect.AnalysisResult analyzeExpression(RuleBuildContext context, BaseDescr descr, Object content) {
        return this.analyzeExpression(context, descr, content, null);
    }

    public Dialect.AnalysisResult analyzeExpression(RuleBuildContext context, BaseDescr descr, Object content, Map localTypes) {
        MVELAnalysisResult result = null;
        try {
            result = this.analyzer.analyzeExpression(context, (String)content, new Set[]{context.getDeclarationResolver().getDeclarations().keySet(), context.getPkg().getGlobals().keySet()}, localTypes);
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), descr, null, "Unable to determine the used declarations"));
        }
        return result;
    }

    public Dialect.AnalysisResult analyzeBlock(RuleBuildContext context, BaseDescr descr, String text) {
        return this.analyzeBlock(context, descr, null, text, null);
    }

    public Dialect.AnalysisResult analyzeBlock(RuleBuildContext context, BaseDescr descr, Map interceptors, String text, Map localTypes) {
        MVELAnalysisResult result = null;
        try {
            result = this.analyzer.analyzeExpression(context, text, new Set[]{context.getDeclarationResolver().getDeclarations().keySet(), context.getPkg().getGlobals().keySet()}, localTypes);
        }
        catch (Exception e) {
            context.getErrors().add(new RuleError(context.getRule(), descr, null, "Unable to determine the used declarations"));
        }
        return result;
    }

    public Serializable compile(String text, Dialect.AnalysisResult analysis, Map interceptors, Map outerDeclarations, RuleBuildContext context) {
        Map.Entry entry;
        Iterator it;
        Map imports = this.getClassImportResolverFactory().getImportedClasses();
        imports.putAll(this.getStaticMethodImportResolverFactory().getImportedMethods());
        ParserContext parserContext = new ParserContext(imports, null, context.getPkg().getName() + "." + context.getRuleDescr().getClassName());
        parserContext.setStrictTypeEnforcement(this.strictMode);
        if (interceptors != null) {
            parserContext.setInterceptors(interceptors);
        }
        List[] list = analysis.getBoundIdentifiers();
        DeclarationScopeResolver resolver = context.getDeclarationResolver();
        Iterator it2 = list[0].iterator();
        while (it2.hasNext()) {
            String identifier = (String)it2.next();
            Class cls = resolver.getDeclaration(identifier).getExtractor().getExtractToClass();
            parserContext.addInput(identifier, cls);
        }
        Map globalTypes = context.getPkg().getGlobals();
        Iterator it3 = list[1].iterator();
        while (it3.hasNext()) {
            String identifier = (String)it3.next();
            parserContext.addInput(identifier, (Class)globalTypes.get(identifier));
        }
        Map mvelVars = ((MVELAnalysisResult)analysis).getMvelVariables();
        if (mvelVars != null) {
            it = mvelVars.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                parserContext.addInput((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        if (outerDeclarations != null) {
            it = outerDeclarations.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                parserContext.addInput((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
            }
        }
        parserContext.addInput("drools", KnowledgeHelper.class);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        compiler.setDebugSymbols(true);
        CompiledExpression expr = compiler.compile(parserContext);
        return expr;
    }

    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)this.builders.get(clazz);
    }

    public Map getBuilders() {
        return this.builders;
    }

    public ClassFieldExtractorCache getClassFieldExtractorCache() {
        return this.classFieldExtractorCache;
    }

    public PatternBuilder getPatternBuilder() {
        return this.pattern;
    }

    public QueryBuilder getQueryBuilder() {
        return this.query;
    }

    public AccumulateBuilder getAccumulateBuilder() {
        return this.accumulate;
    }

    public ConsequenceBuilder getConsequenceBuilder() {
        return this.consequence;
    }

    public RuleConditionBuilder getEvalBuilder() {
        return this.eval;
    }

    public FromBuilder getFromBuilder() {
        return this.from;
    }

    public PredicateBuilder getPredicateBuilder() {
        return this.predicate;
    }

    public PredicateBuilder getExpressionPredicateBuilder() {
        return this.predicate;
    }

    public SalienceBuilder getSalienceBuilder() {
        return this.salience;
    }

    public List getResults() {
        return this.results;
    }

    public ReturnValueBuilder getReturnValueBuilder() {
        return this.returnValue;
    }

    public RuleClassBuilder getRuleClassBuilder() {
        return this.rule;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public Map getInterceptors() {
        return this.interceptors;
    }

    public String getId() {
        return ID;
    }

    public static class ModifyInterceptor
    implements Interceptor,
    Serializable {
        private static final long serialVersionUID = 400L;

        public int doBefore(ASTNode node, VariableResolverFactory factory) {
            Object object = ((WithNode)node).getNestedStatement().getValue(null, factory);
            DroolsMVELKnowledgeHelper resolver = (DroolsMVELKnowledgeHelper)factory.getVariableResolver("drools");
            KnowledgeHelper helper = (KnowledgeHelper)resolver.getValue();
            helper.modifyRetract(object);
            return 0;
        }

        public int doAfter(Object value, ASTNode node, VariableResolverFactory factory) {
            DroolsMVELKnowledgeHelper resolver = (DroolsMVELKnowledgeHelper)factory.getVariableResolver("drools");
            KnowledgeHelper helper = (KnowledgeHelper)resolver.getValue();
            helper.modifyInsert(value);
            return 0;
        }
    }

    public static class AssertInterceptor
    implements Interceptor,
    Serializable {
        private static final long serialVersionUID = 400L;

        public int doBefore(ASTNode node, VariableResolverFactory factory) {
            return 0;
        }

        public int doAfter(Object value, ASTNode node, VariableResolverFactory factory) {
            ((DroolsMVELFactory)factory).getWorkingMemory().insert(value);
            return 0;
        }
    }
}

