/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.Expander;
import org.drools.lang.ExpanderException;
import org.drools.lang.Location;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DefaultExpanderResolver;

public class DrlParser {
    private final List results = new ArrayList();
    private Location location = null;

    public PackageDescr parse(String text) throws DroolsParserException {
        DRLParser parser = this.getParser(text);
        this.compile(parser);
        this.location = parser.getLocation();
        return parser.getPackageDescr();
    }

    public PackageDescr parse(Reader reader) throws DroolsParserException {
        DRLParser parser = this.getParser(reader);
        this.compile(parser);
        this.location = parser.getLocation();
        return parser.getPackageDescr();
    }

    public PackageDescr parse(Reader drl, Reader dsl) throws DroolsParserException, IOException {
        StringBuffer text = this.getDRLText(drl);
        return this.parse(text.toString(), dsl);
    }

    public PackageDescr parse(String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver;
        try {
            resolver = new DefaultExpanderResolver(dsl);
        }
        catch (IOException e) {
            throw new DroolsParserException("Error parsing the DSL.", e);
        }
        Expander expander = resolver.get("*", null);
        String expanded = expander.expand(source);
        if (expander.hasErrors()) {
            this.results.addAll(expander.getErrors());
        }
        return this.parse(expanded);
    }

    public String getExpandedDRL(String source, Reader dsl) throws DroolsParserException {
        DefaultExpanderResolver resolver;
        try {
            resolver = new DefaultExpanderResolver(dsl);
        }
        catch (IOException e) {
            throw new DroolsParserException("Error parsing the DSL.", e);
        }
        Expander expander = resolver.get("*", null);
        String expanded = expander.expand(source);
        if (expander.hasErrors()) {
            String err = "";
            Iterator iter = expander.getErrors().iterator();
            while (iter.hasNext()) {
                ExpanderException ex = (ExpanderException)iter.next();
                err = err + "\n Line:[" + ex.getLine() + "] " + ex.getMessage();
            }
            throw new DroolsParserException(err);
        }
        return expanded;
    }

    private StringBuffer getDRLText(Reader reader) throws IOException {
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public List getErrors() {
        return this.results;
    }

    private void compile(DRLParser parser) throws DroolsParserException {
        try {
            parser.compilation_unit();
            this.makeErrorList(parser);
        }
        catch (RecognitionException e) {
            throw new DroolsParserException(e);
        }
        catch (Exception e) {
            throw new DroolsParserException("Unknown error while parsing. This is a bug. Please contact the Development team.", e);
        }
    }

    private void makeErrorList(DRLParser parser) {
        Iterator iter = parser.getErrors().iterator();
        while (iter.hasNext()) {
            RecognitionException recogErr = (RecognitionException)((Object)iter.next());
            ParserError err = new ParserError(parser.createErrorMessage(recogErr), recogErr.line, recogErr.charPositionInLine);
            this.results.add(err);
        }
    }

    private DRLParser getParser(String text) {
        return new DRLParser((TokenStream)new CommonTokenStream((TokenSource)new DRLLexer((CharStream)new ANTLRStringStream(text))));
    }

    private DRLParser getParser(Reader reader) {
        try {
            return new DRLParser((TokenStream)new CommonTokenStream((TokenSource)new DRLLexer((CharStream)new ANTLRReaderStream(reader))));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    public Location getLocation() {
        return this.location;
    }
}

