/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilder;

public class DialectRegistry {
    private Map map = new HashMap();

    public void addDialectConfiguration(String name, DialectConfiguration dialect) {
        this.map.put(name, dialect);
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return (DialectConfiguration)this.map.get(name);
    }

    public void initAll(PackageBuilder builder) {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            DialectConfiguration dialect = (DialectConfiguration)it.next();
            dialect.getDialect().init(builder);
        }
    }

    public void compileAll() {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            DialectConfiguration dialect = (DialectConfiguration)it.next();
            dialect.getDialect().compileAll();
        }
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public List addResults(List list) {
        if (list == null) {
            list = new ArrayList();
        }
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            DialectConfiguration dialect = (DialectConfiguration)it.next();
            List results = dialect.getDialect().getResults();
            if (results == null) continue;
            list.addAll(results);
        }
        return list;
    }

    public void addImport(String importEntry) {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            DialectConfiguration dialect = (DialectConfiguration)it.next();
            dialect.getDialect().addImport(importEntry);
        }
    }

    public void addStaticImport(String staticImportEntry) {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            DialectConfiguration dialect = (DialectConfiguration)it.next();
            dialect.getDialect().addStaticImport(staticImportEntry);
        }
    }
}

