/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.commands.IdentifiableResult;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.drools.util.StringUtils;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;

@XmlRootElement(name="insert-object-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class InsertObjectCommand
implements ExecutableCommand<FactHandle>,
IdentifiableResult {
    private static final long serialVersionUID = 510L;
    @XmlElement
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Object object;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(name="return-object")
    private boolean returnObject = true;
    @XmlAttribute(name="entry-point")
    private String entryPoint = "DEFAULT";
    @XmlAttribute(name="disconnected")
    private boolean disconnected = false;

    public InsertObjectCommand() {
    }

    public InsertObjectCommand(Object object) {
        this.object = object;
    }

    public InsertObjectCommand(Object object, boolean disconnected) {
        this.object = object;
        this.disconnected = disconnected;
    }

    public InsertObjectCommand(Object object, String outIdentifier) {
        this.object = object;
        this.outIdentifier = outIdentifier;
    }

    public FactHandle execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        FactHandle factHandle = StringUtils.isEmpty((CharSequence)this.entryPoint) ? ksession.insert(this.object) : ksession.getEntryPoint(this.entryPoint).insert(this.object);
        if (this.outIdentifier != null) {
            if (this.returnObject) {
                ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, this.object);
            }
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).getFactHandles().put(this.outIdentifier, factHandle);
        }
        if (this.disconnected) {
            DefaultFactHandle disconnectedHandle = ((DefaultFactHandle)factHandle).clone();
            disconnectedHandle.disconnect();
            return disconnectedHandle;
        }
        return factHandle;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(boolean returnObject) {
        this.returnObject = returnObject;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        if (entryPoint == null) {
            entryPoint = "DEFAULT";
        }
        this.entryPoint = entryPoint;
    }

    public String toString() {
        return "session.entryPoints(" + (this.entryPoint == null ? "DEFAULT" : this.entryPoint) + ").insert(" + this.object + ");";
    }
}

