/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.process;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.commands.runtime.process.StartProcessCommand;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.CorrelationKeyCommand;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.jaxb.CorrelationKeyXmlAdapter;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class StartProcessFromNodeIdsCommand
extends StartProcessCommand
implements CorrelationKeyCommand {
    private static final long serialVersionUID = -6839934578407787510L;
    @XmlElementWrapper(name="node-id-list")
    @XmlElement(name="node-id")
    private List<String> nodeIds;
    @XmlElement(name="correlation-key")
    @XmlJavaTypeAdapter(value=CorrelationKeyXmlAdapter.class)
    private CorrelationKey correlationKey;

    public StartProcessFromNodeIdsCommand() {
    }

    public StartProcessFromNodeIdsCommand(String processId, String outIdentifier) {
        super(processId);
        this.setOutIdentifier(outIdentifier);
    }

    public StartProcessFromNodeIdsCommand(String processId, Map<String, Object> parameters) {
        super(processId);
        this.setParameters(parameters);
    }

    public StartProcessFromNodeIdsCommand(String processId, Map<String, Object> parameters, String outIdentifier) {
        this(processId, outIdentifier);
        this.setParameters(parameters);
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public void setCorrelationKey(CorrelationKey key) {
        this.correlationKey = key;
    }

    public CorrelationKey getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public ProcessInstance execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        if (this.getData() != null) {
            for (Object o : this.getData()) {
                ksession.insert(o);
            }
        }
        String[] ids = this.nodeIds != null ? (String[])this.nodeIds.stream().toArray(String[]::new) : new String[]{};
        ProcessInstance processInstance = null;
        processInstance = this.correlationKey == null ? ksession.startProcessFromNodeIds(this.getProcessId(), this.getParameters(), ids) : ((CorrelationAwareProcessRuntime)ksession).startProcessFromNodeIds(this.getProcessId(), this.correlationKey, this.getParameters(), ids);
        if (this.getOutIdentifier() != null) {
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.getOutIdentifier(), (Object)processInstance.getId());
        }
        return processInstance;
    }
}

