/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import org.drools.model.Constraint;
import org.drools.model.DSL;
import org.drools.model.DataSourceDefinition;
import org.drools.model.Index;
import org.drools.model.Pattern;
import org.drools.model.SingleConstraint;
import org.drools.model.Type;
import org.drools.model.Variable;
import org.drools.model.constraints.AbstractConstraint;
import org.drools.model.constraints.AbstractSingleConstraint;
import org.drools.model.constraints.SingleConstraint1;
import org.drools.model.constraints.SingleConstraint2;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.impl.DataSourceDefinitionImpl;
import org.drools.model.index.AlphaIndexImpl;
import org.drools.model.index.BetaIndexImpl;
import org.drools.model.patterns.PatternImpl;

public class PatternBuilder {
    private Variable[] joinVars;
    private DataSourceDefinition dataSourceDefinition = DataSourceDefinitionImpl.DEFAULT;

    public PatternBuilder from(DataSourceDefinition dataSourceDefinition) {
        this.dataSourceDefinition = dataSourceDefinition;
        return this;
    }

    public <T> BoundPatternBuilder<T> filter(Type<T> type) {
        return this.filter(DSL.declarationOf(type));
    }

    public <T> BoundPatternBuilder<T> filter(Variable<T> var) {
        return new BoundPatternBuilder(var, this.dataSourceDefinition);
    }

    public static class ConstrainedPatternBuilder<T>
    implements ValidBuilder<T> {
        private final Variable<T> variable;
        private Constraint constraint;
        private DataSourceDefinition dataSourceDefinition;
        private AbstractSingleConstraint lastConstraint;

        private ConstrainedPatternBuilder(Variable<T> variable, AbstractSingleConstraint constraint, DataSourceDefinition dataSourceDefinition) {
            this.variable = variable;
            this.constraint = constraint;
            this.lastConstraint = constraint;
            this.dataSourceDefinition = dataSourceDefinition;
        }

        public ConstrainedPatternBuilder<T> from(DataSourceDefinition dataSourceDefinition) {
            this.dataSourceDefinition = dataSourceDefinition;
            return this;
        }

        public ConstrainedPatternBuilder<T> and(Predicate1<T> predicate) {
            return this.and(new SingleConstraint1<T>(this.variable, predicate));
        }

        public ConstrainedPatternBuilder<T> and(String exprId, Predicate1<T> predicate) {
            return this.and(new SingleConstraint1<T>(exprId, this.variable, predicate));
        }

        public ConstrainedPatternBuilder<T> and(Constraint constraint) {
            this.constraint = ((AbstractConstraint)this.constraint).and(constraint);
            return this;
        }

        public ConstrainedPatternBuilder<T> or(Predicate1<T> predicate) {
            return this.or(new SingleConstraint1<T>(this.variable, predicate));
        }

        public ConstrainedPatternBuilder<T> or(String exprId, Predicate1<T> predicate) {
            return this.or(new SingleConstraint1<T>(exprId, this.variable, predicate));
        }

        public ConstrainedPatternBuilder<T> or(Constraint constraint) {
            this.constraint = ((AbstractConstraint)this.constraint).or(constraint);
            return this;
        }

        public <A, B> ConstrainedPatternBuilder<T> and(Variable<A> var1, Variable<B> var2, Predicate2<A, B> predicate) {
            this.lastConstraint = new SingleConstraint2<A, B>(var1, var2, predicate);
            return this.and(this.lastConstraint);
        }

        public <A> ConstrainedPatternBuilder<T> and(Variable<A> var1, Predicate2<T, A> predicate) {
            this.lastConstraint = new SingleConstraint2<T, A>(this.variable, var1, predicate);
            return this.and(this.lastConstraint);
        }

        public <A, B> ConstrainedPatternBuilder<T> and(String exprId, Variable<A> var1, Variable<B> var2, Predicate2<A, B> predicate) {
            this.lastConstraint = new SingleConstraint2<A, B>(exprId, var1, var2, predicate);
            return this.and(this.lastConstraint);
        }

        public <A> ConstrainedPatternBuilder<T> and(String exprId, Variable<A> var1, Predicate2<T, A> predicate) {
            this.lastConstraint = new SingleConstraint2<T, A>(exprId, this.variable, var1, predicate);
            return this.and(this.lastConstraint);
        }

        public ConstrainedPatternBuilder<T> and(AbstractConstraint constraint) {
            this.constraint = ((AbstractConstraint)this.constraint).and(constraint);
            return this;
        }

        public <A, B> ConstrainedPatternBuilder<T> or(Variable<A> var1, Variable<B> var2, Predicate2<A, B> predicate) {
            this.lastConstraint = new SingleConstraint2<A, B>(var1, var2, predicate);
            return this.or(this.lastConstraint);
        }

        public <A> ConstrainedPatternBuilder<T> or(Variable<A> var1, Predicate2<T, A> predicate) {
            this.lastConstraint = new SingleConstraint2<T, A>(this.variable, var1, predicate);
            return this.or(this.lastConstraint);
        }

        public <A, B> ConstrainedPatternBuilder<T> or(String exprId, Variable<A> var1, Variable<B> var2, Predicate2<A, B> predicate) {
            this.lastConstraint = new SingleConstraint2<A, B>(exprId, var1, var2, predicate);
            return this.or(this.lastConstraint);
        }

        public <A> ConstrainedPatternBuilder<T> or(String exprId, Variable<A> var1, Predicate2<T, A> predicate) {
            this.lastConstraint = new SingleConstraint2<T, A>(exprId, this.variable, var1, predicate);
            return this.or(this.lastConstraint);
        }

        public ConstrainedPatternBuilder<T> or(AbstractConstraint constraint) {
            this.constraint = ((AbstractConstraint)this.constraint).or(constraint);
            return this;
        }

        public <U> ConstrainedPatternBuilder<T> indexedBy(Class<?> indexedClass, Index.ConstraintType constraintType, int indexId, Function1<T, U> leftOperandExtractor, U rightValue) {
            this.lastConstraint.setIndex(new AlphaIndexImpl<T, U>(indexedClass, constraintType, indexId, leftOperandExtractor, rightValue));
            return this;
        }

        public <U, V> ConstrainedPatternBuilder<T> indexedBy(Class<?> indexedClass, Index.ConstraintType constraintType, int indexId, Function1<T, V> leftOperandExtractor, Function1<U, V> rightOperandExtractor) {
            this.lastConstraint.setIndex(new BetaIndexImpl<T, U, V>(indexedClass, constraintType, indexId, leftOperandExtractor, rightOperandExtractor));
            return this;
        }

        @Override
        public Pattern<T> get() {
            return new PatternImpl<T>(this.variable, this.constraint);
        }
    }

    public static class BoundPatternBuilder<T>
    implements ValidBuilder<T> {
        private final Variable<T> variable;
        private DataSourceDefinition dataSourceDefinition;

        private BoundPatternBuilder(Variable<T> variable, DataSourceDefinition dataSourceDefinition) {
            this.variable = variable;
            this.dataSourceDefinition = dataSourceDefinition;
        }

        public BoundPatternBuilder<T> from(DataSourceDefinition dataSourceDefinition) {
            this.dataSourceDefinition = dataSourceDefinition;
            return this;
        }

        public ConstrainedPatternBuilder<T> with(SingleConstraint constraint) {
            return new ConstrainedPatternBuilder(this.variable, (AbstractSingleConstraint)constraint, this.dataSourceDefinition);
        }

        public ConstrainedPatternBuilder<T> with(Predicate1<T> predicate) {
            return this.with(new SingleConstraint1<T>(this.variable, predicate));
        }

        public <A, B> ConstrainedPatternBuilder<T> with(Variable<A> var1, Variable<B> var2, Predicate2<A, B> predicate) {
            return this.with(new SingleConstraint2<A, B>(var1, var2, predicate));
        }

        public <A> ConstrainedPatternBuilder<T> with(Variable<A> var2, Predicate2<T, A> predicate) {
            return this.with(new SingleConstraint2<T, A>(this.variable, var2, predicate));
        }

        public ConstrainedPatternBuilder<T> with(String exprId, Predicate1<T> predicate) {
            return this.with(new SingleConstraint1<T>(exprId, this.variable, predicate));
        }

        public <A, B> ConstrainedPatternBuilder<T> with(String exprId, Variable<A> var1, Variable<B> var2, Predicate2<A, B> predicate) {
            return this.with(new SingleConstraint2<A, B>(exprId, var1, var2, predicate));
        }

        public <A> ConstrainedPatternBuilder<T> with(String exprId, Variable<A> var2, Predicate2<T, A> predicate) {
            return this.with(new SingleConstraint2<T, A>(exprId, this.variable, var2, predicate));
        }

        @Override
        public Pattern<T> get() {
            return new PatternImpl<T>(this.variable, SingleConstraint.EMPTY);
        }
    }

    public static interface ValidBuilder<T> {
        public Pattern<T> get();
    }
}

