/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.model.Consequence;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Function1;
import org.drools.model.impl.RuleImpl;
import org.drools.model.impl.ViewBuilder;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.view.ViewItemBuilder;

public class RuleBuilder {
    public static final String DEFAULT_PACKAGE = "defaultpkg";
    private final String pkg;
    private final String name;
    private String unit;
    private final Map<Rule.Attribute, Object> attributes = new IdentityHashMap<Rule.Attribute, Object>();
    private Map<String, Object> metaAttributes = new HashMap<String, Object>();

    public RuleBuilder(String name) {
        this(DEFAULT_PACKAGE, name);
    }

    public RuleBuilder(String pkg, String name) {
        this.pkg = pkg;
        this.name = name;
    }

    public RuleBuilder unit(String unit) {
        this.unit = unit;
        return this;
    }

    public RuleBuilder unit(Class<?> unitClass) {
        this.unit = unitClass.getName();
        return this;
    }

    public static String getCanonicalSimpleName(Class<?> c) {
        Class<?> enclosingClass = c.getEnclosingClass();
        return enclosingClass != null ? RuleBuilder.getCanonicalSimpleName(enclosingClass) + "." + c.getSimpleName() : c.getSimpleName();
    }

    public <T> RuleBuilder attribute(Rule.Attribute<T> attribute, T value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public <T> RuleBuilder metadata(String key, Object value) {
        this.metaAttributes.put(key, value);
        return this;
    }

    public RuleBuilderWithLHS view(ViewItemBuilder ... viewItemBuilders) {
        return new RuleBuilderWithLHS(ViewBuilder.viewItems2Patterns(viewItemBuilders));
    }

    public Rule build(RuleItemBuilder ... viewItemBuilders) {
        return new RuleImpl(this.pkg, this.name, this.unit, ViewBuilder.viewItems2Patterns(viewItemBuilders), this.attributes, this.metaAttributes);
    }

    public class RuleBuilderWithLHS {
        private final CompositePatterns view;

        public RuleBuilderWithLHS(CompositePatterns view) {
            this.view = view;
        }

        public Rule then(Function1<ConsequenceBuilder, ConsequenceBuilder.ValidBuilder> builder) {
            return this.then(builder.apply(new ConsequenceBuilder()));
        }

        public Rule then(ConsequenceBuilder.ValidBuilder builder) {
            Consequence consequence = (Consequence)builder.get();
            this.view.ensureVariablesDeclarationInView("default", consequence);
            return new RuleImpl(RuleBuilder.this.pkg, RuleBuilder.this.name, RuleBuilder.this.unit, this.view, consequence, RuleBuilder.this.attributes, RuleBuilder.this.metaAttributes);
        }
    }
}

