/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.util.bitmask.OpenBitSet;

public class SeparatorSet
implements Comparable<SeparatorSet> {
    private int id1;
    private OpenBitSet clique1;
    private int id2;
    private OpenBitSet clique2;
    private OpenBitSet intersection;
    private int mass;
    private int cost;

    public SeparatorSet(OpenBitSet clique1, int id1, OpenBitSet clique2, int id2, Graph<BayesVariable> graph) {
        this.id1 = id1;
        this.clique1 = clique1;
        this.clique2 = clique2;
        this.id2 = id2;
        this.intersection = clique1.clone();
        this.intersection.and(clique2);
        this.mass = (int)this.intersection.cardinality();
        this.cost = 1;
        if (this.mass > 0) {
            int i = this.intersection.nextSetBit(0);
            while (i >= 0) {
                GraphNode<BayesVariable> v = graph.getNode(i);
                this.cost *= Math.abs(v.getContent().getOutcomes().length);
                i = this.intersection.nextSetBit(i + 1);
            }
        }
    }

    public int getId1() {
        return this.id1;
    }

    public OpenBitSet getClique1() {
        return this.clique1;
    }

    public OpenBitSet getClique2() {
        return this.clique2;
    }

    public int getId2() {
        return this.id2;
    }

    public OpenBitSet getIntersection() {
        return this.intersection;
    }

    public int getMass() {
        return this.mass;
    }

    public int getCost() {
        return this.cost;
    }

    @Override
    public int compareTo(SeparatorSet o) {
        if (this == o) {
            return 0;
        }
        if (this.mass != o.mass) {
            return o.mass - this.mass;
        }
        if (this.cost != o.cost) {
            return o.cost - this.cost;
        }
        int j = o.clique1.nextSetBit(0);
        int i = this.clique1.nextSetBit(0);
        while (i >= 0) {
            if (i != j) {
                return i - j;
            }
            j = o.clique1.nextSetBit(j + 1);
            i = this.clique1.nextSetBit(i + 1);
        }
        j = o.clique2.nextSetBit(0);
        i = this.clique2.nextSetBit(0);
        while (i >= 0) {
            if (i != j) {
                return i - j;
            }
            j = o.clique2.nextSetBit(j + 1);
            i = this.clique2.nextSetBit(i + 1);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeparatorSet separatorSet = (SeparatorSet)o;
        if (this.cost != separatorSet.cost) {
            return false;
        }
        if (this.mass != separatorSet.mass) {
            return false;
        }
        if (!this.clique1.equals((Object)separatorSet.clique1)) {
            return false;
        }
        if (!this.clique2.equals((Object)separatorSet.clique2)) {
            return false;
        }
        return this.intersection.equals((Object)separatorSet.intersection);
    }

    public int hashCode() {
        int result = this.clique1.hashCode();
        result = 31 * result + this.clique2.hashCode();
        result = 31 * result + this.intersection.hashCode();
        result = 31 * result + this.mass;
        result = 31 * result + this.cost;
        return result;
    }

    public String toString() {
        return "SepSet{clique1=" + this.clique1 + ", clique2=" + this.clique2 + ", intersection=" + this.intersection + ", mass=" + this.mass + ", cost=" + this.cost + "}";
    }
}

