/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import java.util.List;
import org.drools.beliefs.bayes.BayesVariable;

public class PotentialMultiplier {
    int varPos;
    int[] parentVarPos;
    double[][] varPotential;
    int[] parentIndexMultipliers;
    int varProbabilityTableRow;
    BayesVariable[] vars;
    int[] multipliers;
    int[] path;
    double[] trgPotentials;
    int trgPotentialIndex;

    public PotentialMultiplier(double[][] varPotential, int varPos, int[] parentVarPos, int[] parentIndexMultipliers, BayesVariable[] vars, int[] multipliers, double[] trgPotentials) {
        this.varPotential = varPotential;
        this.varPos = varPos;
        this.parentVarPos = parentVarPos;
        this.parentIndexMultipliers = parentIndexMultipliers;
        this.vars = vars;
        this.multipliers = multipliers;
        this.path = new int[vars.length];
        this.trgPotentials = trgPotentials;
    }

    public static int createNumberOfStates(List<BayesVariable> vars) {
        int numberOfStates = 1;
        for (int i = 0; i < vars.size(); ++i) {
            BayesVariable var = vars.get(i);
            numberOfStates *= var.getOutcomes().length;
        }
        return numberOfStates;
    }

    public static int createNumberOfStates(BayesVariable[] vars) {
        return PotentialMultiplier.createNumberOfStates(Arrays.asList(vars));
    }

    public static int[] createIndexMultipliers(BayesVariable[] vars, int numberOfStates) {
        if (vars.length == 0) {
            return new int[0];
        }
        int[] indexMultipliers = new int[vars.length];
        indexMultipliers[0] = numberOfStates / vars[0].getOutcomes().length;
        for (int i = 1; i < vars.length; ++i) {
            indexMultipliers[i] = indexMultipliers[i - 1] / vars[i].getOutcomes().length;
        }
        return indexMultipliers;
    }

    public static int[] createSubsetVarPos(BayesVariable[] vars, BayesVariable[] subset) {
        int[] parentVarPos = new int[subset.length];
        int currentVar = 0;
        for (int i = 0; i < vars.length && currentVar < subset.length; ++i) {
            if (vars[i] != subset[currentVar]) continue;
            parentVarPos[currentVar++] = i;
        }
        return parentVarPos;
    }

    public void multiple() {
        this.varProbabilityTableRow = 0;
        this.trgPotentialIndex = 0;
        this.multiple(0, 0);
    }

    public void multiple(int currentVar, int parentKeyPos) {
        int numberOfOutcomes = this.vars[currentVar].getOutcomes().length;
        boolean isParent = false;
        int nextParentKeyPos = parentKeyPos;
        if (this.parentVarPos.length > 0 && parentKeyPos < this.parentVarPos.length && this.parentVarPos[parentKeyPos] == currentVar) {
            ++nextParentKeyPos;
            isParent = true;
        }
        for (int j = 0; j < numberOfOutcomes; ++j) {
            this.path[currentVar] = j;
            if (currentVar < this.vars.length - 1) {
                this.multiple(currentVar + 1, nextParentKeyPos);
            } else {
                int n = this.trgPotentialIndex++;
                this.trgPotentials[n] = this.trgPotentials[n] * this.varPotential[this.varProbabilityTableRow][this.path[this.varPos]];
            }
            if (!isParent) continue;
            this.varProbabilityTableRow += this.parentIndexMultipliers[parentKeyPos];
        }
        if (isParent) {
            this.varProbabilityTableRow -= this.parentIndexMultipliers[parentKeyPos] * numberOfOutcomes;
        }
    }

    public static int[] indexToKey(int index, int[] indexMultipliers) {
        int[] stateIndex = new int[indexMultipliers.length + 1];
        int offset = 0;
        for (int i = 0; i < indexMultipliers.length; ++i) {
            int multiplier = indexMultipliers[i];
            stateIndex[i] = Math.abs((index - offset) / multiplier);
            offset += multiplier * stateIndex[i];
        }
        stateIndex[indexMultipliers.length] = index - offset;
        return stateIndex;
    }

    public static int keyToIndex(int[] key, int[] indexMultipliers) {
        int index = 0;
        for (int i = 0; i < indexMultipliers.length; ++i) {
            int value = key[i];
            index += value * indexMultipliers[i];
        }
        return index += key[key.length - 1];
    }
}

