/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesBeliefSystem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedList;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.ModedAssertion;

public class NonConflictingModeSet<M extends ModedAssertion<M>>
extends LinkedList<M>
implements BeliefSet<M> {
    BayesBeliefSystem<? extends ModedAssertion> beliefSystem;
    private InternalFactHandle rootHandle;
    private int conflictCounter;

    public NonConflictingModeSet(InternalFactHandle rootHandle, BayesBeliefSystem<? extends ModedAssertion> beliefSystem) {
        this.rootHandle = rootHandle;
        this.beliefSystem = beliefSystem;
    }

    public NonConflictingModeSet() {
    }

    public BeliefSystem<? extends ModedAssertion> getBeliefSystem() {
        return this.beliefSystem;
    }

    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    public void add(M mode) {
        ModedAssertion first;
        if (!this.isEmpty() && !(first = (ModedAssertion)this.getFirst()).equals(mode)) {
            ++this.conflictCounter;
        }
        super.addLast(mode);
    }

    public void remove(M mode) {
        boolean wasFirst = this.getFirst() == mode;
        super.remove(mode);
        if (this.isEmpty()) {
            this.conflictCounter = 0;
            return;
        }
        ModedAssertion first = (ModedAssertion)this.getFirst();
        if (wasFirst) {
            this.conflictCounter = 0;
            for (ModedAssertion current = (ModedAssertion)mode.getNext(); current != null; current = (ModedAssertion)current.getNext()) {
                if (first.equals(current)) continue;
                ++this.conflictCounter;
            }
        } else if (!first.equals(mode)) {
            --this.conflictCounter;
        }
    }

    public void cancel(PropagationContext propagationContext) {
    }

    public void clear(PropagationContext propagationContext) {
    }

    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
    }

    public boolean isNegated() {
        return false;
    }

    public boolean isDecided() {
        return !this.isConflicting();
    }

    public boolean isConflicting() {
        return this.conflictCounter > 0;
    }

    public boolean isPositive() {
        return !this.isEmpty();
    }
}

