/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.drools.beliefs.bayes.BayesAbsorption;
import org.drools.beliefs.bayes.BayesLikelyhood;
import org.drools.beliefs.bayes.BayesProjection;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.BayesVariableConstructor;
import org.drools.beliefs.bayes.BayesVariableState;
import org.drools.beliefs.bayes.CliqueState;
import org.drools.beliefs.bayes.GlobalUpdateListener;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.Marginalizer;
import org.drools.beliefs.bayes.PassMessageListener;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.bayes.SeparatorState;
import org.drools.beliefs.bayes.VarName;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.core.util.BitMaskUtil;

public class BayesInstance<T> {
    private Graph<BayesVariable> graph;
    private JunctionTree tree;
    private Map<String, BayesVariable> variables;
    private Map<String, BayesVariable> fieldNames;
    private BayesLikelyhood[] likelyhoods;
    private long dirty;
    private long decided;
    private CliqueState[] cliqueStates;
    private SeparatorState[] separatorStates;
    private BayesVariableState[] varStates;
    private GlobalUpdateListener globalUpdateListener;
    private PassMessageListener passMessageListener;
    private int[] targetParameterMap;
    private Class<T> targetClass;
    private Constructor<T> targetConstructor;

    public BayesInstance(JunctionTree tree, Class<T> targetClass) {
        this(tree);
        this.targetClass = targetClass;
        this.buildParameterMapping(targetClass);
        this.buildFieldMappings(targetClass);
    }

    public BayesInstance(JunctionTree tree) {
        this.graph = tree.getGraph();
        this.tree = tree;
        this.variables = new HashMap<String, BayesVariable>();
        this.fieldNames = new HashMap<String, BayesVariable>();
        this.likelyhoods = new BayesLikelyhood[this.graph.size()];
        this.cliqueStates = new CliqueState[tree.getJunctionTreeNodes().length];
        for (JunctionTreeClique clique : tree.getJunctionTreeNodes()) {
            this.cliqueStates[clique.getId()] = clique.createState();
        }
        this.separatorStates = new SeparatorState[tree.getJunctionTreeSeparators().length];
        for (JunctionTreeSeparator sep : tree.getJunctionTreeSeparators()) {
            this.separatorStates[sep.getId()] = sep.createState();
        }
        this.varStates = new BayesVariableState[this.graph.size()];
        for (GraphNode graphNode : this.graph) {
            BayesVariable var = (BayesVariable)graphNode.getContent();
            this.variables.put(var.getName(), var);
            this.varStates[var.getId()] = var.createState();
        }
    }

    public void reset() {
        for (JunctionTreeClique clique : this.tree.getJunctionTreeNodes()) {
            clique.resetState(this.cliqueStates[clique.getId()]);
        }
        for (JunctionTreeSeparator sep : this.tree.getJunctionTreeSeparators()) {
            sep.resetState(this.separatorStates[sep.getId()]);
        }
        for (GraphNode graphNode : this.graph) {
            BayesVariable var = (BayesVariable)graphNode.getContent();
            BayesVariableState varState = this.varStates[var.getId()];
            varState.setDistribution(new double[varState.getDistribution().length]);
        }
    }

    public void setTargetClass(Class<T> targetClass) {
        this.targetClass = targetClass;
        this.buildParameterMapping(targetClass);
        this.buildFieldMappings(targetClass);
    }

    public void buildFieldMappings(Class<T> target) {
        for (Field field : target.getDeclaredFields()) {
            Annotation[] anns;
            for (Annotation ann : anns = field.getDeclaredAnnotations()) {
                if (ann.annotationType() != VarName.class) continue;
                String varName = ((VarName)ann).value();
                BayesVariable var = this.variables.get(varName);
                this.fieldNames.put(field.getName(), var);
            }
        }
    }

    public void buildParameterMapping(Class<T> target) {
        Constructor<?>[] cons = target.getConstructors();
        if (cons != null) {
            for (Constructor<?> con : cons) {
                for (Annotation ann : con.getDeclaredAnnotations()) {
                    if (ann.annotationType() != BayesVariableConstructor.class) continue;
                    Class<?>[] paramTypes = con.getParameterTypes();
                    this.targetParameterMap = new int[paramTypes.length];
                    if (paramTypes[0] != BayesInstance.class) {
                        throw new RuntimeException("First Argument must be " + BayesInstance.class.getSimpleName());
                    }
                    Annotation[][] paramAnns = con.getParameterAnnotations();
                    for (int j = 1; j < paramAnns.length; ++j) {
                        if (paramAnns[j][0].annotationType() != VarName.class) continue;
                        String varName = ((VarName)paramAnns[j][0]).value();
                        BayesVariable var = this.variables.get(varName);
                        Object[] outcomes = new Object[var.getOutcomes().length];
                        if (paramTypes[j].isAssignableFrom(Boolean.class) || paramTypes[j].isAssignableFrom(Boolean.TYPE)) {
                            for (int k = 0; k < var.getOutcomes().length; ++k) {
                                outcomes[k] = Boolean.valueOf((String)var.getOutcomes()[k]);
                            }
                        }
                        this.varStates[var.getId()].setOutcomes(outcomes);
                        this.targetParameterMap[j] = var.getId();
                    }
                    this.targetConstructor = con;
                }
            }
        }
        if (this.targetConstructor == null) {
            throw new IllegalStateException("Unable to find Constructor");
        }
    }

    public GlobalUpdateListener getGlobalUpdateListener() {
        return this.globalUpdateListener;
    }

    public void setGlobalUpdateListener(GlobalUpdateListener globalUpdateListener) {
        this.globalUpdateListener = globalUpdateListener;
    }

    public PassMessageListener getPassMessageListener() {
        return this.passMessageListener;
    }

    public void setPassMessageListener(PassMessageListener passMessageListener) {
        this.passMessageListener = passMessageListener;
    }

    public Map<String, BayesVariable> getVariables() {
        return this.variables;
    }

    public Map<String, BayesVariable> getFieldNames() {
        return this.fieldNames;
    }

    public void setDecided(String varName, boolean bool) {
    }

    public void setDecided(BayesVariable var, boolean bool) {
        this.decided = !bool ? BitMaskUtil.set((long)this.decided, (int)var.getId()) : BitMaskUtil.reset((long)this.decided, (int)var.getId());
    }

    public boolean isDecided() {
        return this.decided == 0L;
    }

    public boolean isDirty() {
        return this.dirty > 0L;
    }

    public void setLikelyhood(String varName, double[] distribution) {
        BayesVariable var = this.variables.get(varName);
        if (var == null) {
            throw new IllegalArgumentException("Variable name does not exist: " + varName);
        }
        this.setLikelyhood(var, distribution);
    }

    public void unsetLikelyhood(BayesVariable var) {
        int id = var.getId();
        this.likelyhoods[id] = null;
        this.dirty = BitMaskUtil.set((long)this.dirty, (int)id);
    }

    public void setLikelyhood(BayesVariable var, double[] distribution) {
        GraphNode<BayesVariable> node = this.graph.getNode(var.getId());
        JunctionTreeClique clique = this.tree.getJunctionTreeNodes()[var.getFamily()];
        this.setLikelyhood(new BayesLikelyhood(this.graph, clique, node, distribution));
    }

    public void setLikelyhood(BayesLikelyhood likelyhood) {
        int id = likelyhood.getVariable().getId();
        BayesLikelyhood old = this.likelyhoods[id];
        if (old == null || !old.equals(likelyhood)) {
            this.likelyhoods[likelyhood.getVariable().getId()] = likelyhood;
            this.dirty = BitMaskUtil.set((long)this.dirty, (int)id);
        }
    }

    public void globalUpdate() {
        if (!this.isDecided()) {
            throw new IllegalStateException("Cannot perform global upset, while one ore more variables are undecided");
        }
        if (this.isDirty()) {
            this.reset();
        }
        this.applyEvidence();
        this.globalUpdate(this.tree.getRoot());
        this.dirty = 0L;
    }

    public void applyEvidence() {
        for (int i = 0; i < this.likelyhoods.length; ++i) {
            BayesLikelyhood l = this.likelyhoods[i];
            if (l == null) continue;
            int family = this.likelyhoods[i].getVariable().getFamily();
            JunctionTreeClique node = this.tree.getJunctionTreeNodes()[family];
            this.likelyhoods[i].multiplyInto(this.cliqueStates[family].getPotentials());
            BayesAbsorption.normalize(this.cliqueStates[family].getPotentials());
        }
    }

    public void globalUpdate(JunctionTreeClique clique) {
        if (this.globalUpdateListener != null) {
            this.globalUpdateListener.beforeGlobalUpdate(this.cliqueStates[clique.getId()]);
        }
        this.collectEvidence(clique);
        this.distributeEvidence(clique);
        if (this.globalUpdateListener != null) {
            this.globalUpdateListener.afterGlobalUpdate(this.cliqueStates[clique.getId()]);
        }
    }

    public void recurseGlobalUpdate(JunctionTreeClique clique) {
        this.globalUpdate(clique);
        List<JunctionTreeSeparator> seps = clique.getChildren();
        for (JunctionTreeSeparator sep : seps) {
            this.recurseGlobalUpdate(sep.getChild());
        }
    }

    public void collectEvidence(JunctionTreeClique clique) {
        if (clique.getParentSeparator() != null) {
            this.collectParentEvidence(clique.getParentSeparator().getParent(), clique.getParentSeparator(), clique, clique);
        }
        this.collectChildEvidence(clique, clique);
    }

    public void collectParentEvidence(JunctionTreeClique clique, JunctionTreeSeparator sep, JunctionTreeClique child, JunctionTreeClique startClique) {
        if (clique.getParentSeparator() != null) {
            this.collectParentEvidence(clique.getParentSeparator().getParent(), clique.getParentSeparator(), clique, startClique);
        }
        List<JunctionTreeSeparator> seps = clique.getChildren();
        for (JunctionTreeSeparator childSep : seps) {
            if (childSep.getChild() == child) continue;
            this.collectChildEvidence(childSep.getChild(), startClique);
        }
        this.passMessage(clique, child.getParentSeparator(), child);
    }

    public void collectChildEvidence(JunctionTreeClique clique, JunctionTreeClique startClique) {
        List<JunctionTreeSeparator> seps = clique.getChildren();
        for (JunctionTreeSeparator sep : seps) {
            this.collectChildEvidence(sep.getChild(), startClique);
        }
        if (clique.getParentSeparator() != null && clique != startClique) {
            this.passMessage(clique, clique.getParentSeparator(), clique.getParentSeparator().getParent());
        }
    }

    public void distributeEvidence(JunctionTreeClique clique) {
        if (clique.getParentSeparator() != null) {
            this.distributeParentEvidence(clique.getParentSeparator().getParent(), clique.getParentSeparator(), clique, clique);
        }
        this.distributeChildEvidence(clique, clique);
    }

    public void distributeParentEvidence(JunctionTreeClique clique, JunctionTreeSeparator sep, JunctionTreeClique child, JunctionTreeClique startClique) {
        this.passMessage(child, child.getParentSeparator(), clique);
        if (clique.getParentSeparator() != null) {
            this.distributeParentEvidence(clique.getParentSeparator().getParent(), clique.getParentSeparator(), clique, startClique);
        }
        List<JunctionTreeSeparator> seps = clique.getChildren();
        for (JunctionTreeSeparator childSep : seps) {
            if (childSep.getChild() == child) continue;
            this.distributeChildEvidence(childSep.getChild(), startClique);
        }
    }

    public void distributeChildEvidence(JunctionTreeClique clique, JunctionTreeClique startClique) {
        if (clique.getParentSeparator() != null && clique != startClique) {
            this.passMessage(clique.getParentSeparator().getParent(), clique.getParentSeparator(), clique);
        }
        List<JunctionTreeSeparator> seps = clique.getChildren();
        for (JunctionTreeSeparator sep : seps) {
            this.distributeChildEvidence(sep.getChild(), startClique);
        }
    }

    public void passMessage(JunctionTreeClique sourceClique, JunctionTreeSeparator sep, JunctionTreeClique targetClique) {
        double[] sepPots = this.separatorStates[sep.getId()].getPotentials();
        double[] oldSepPots = Arrays.copyOf(sepPots, sepPots.length);
        BayesVariable[] sepVars = sep.getValues().toArray(new BayesVariable[sep.getValues().size()]);
        if (this.passMessageListener != null) {
            this.passMessageListener.beforeProjectAndAbsorb(sourceClique, sep, targetClique, oldSepPots);
        }
        BayesInstance.project(sepVars, this.cliqueStates[sourceClique.getId()], this.separatorStates[sep.getId()]);
        if (this.passMessageListener != null) {
            this.passMessageListener.afterProject(sourceClique, sep, targetClique, oldSepPots);
        }
        BayesInstance.absorb(sepVars, this.cliqueStates[targetClique.getId()], this.separatorStates[sep.getId()], oldSepPots);
        if (this.passMessageListener != null) {
            this.passMessageListener.afterAbsorb(sourceClique, sep, targetClique, oldSepPots);
        }
    }

    private static void project(BayesVariable[] sepVars, CliqueState clique, SeparatorState separator) {
        BayesVariable[] vars = clique.getJunctionTreeClique().getValues().toArray(new BayesVariable[clique.getJunctionTreeClique().getValues().size()]);
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos(vars, sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates(sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers(sepVars, sepVarNumberOfStates);
        BayesProjection p = new BayesProjection(vars, clique.getPotentials(), sepVarPos, sepVarMultipliers, separator.getPotentials());
        p.project();
    }

    private static void absorb(BayesVariable[] sepVars, CliqueState clique, SeparatorState separator, double[] oldSepPots) {
        BayesVariable[] vars = clique.getJunctionTreeClique().getValues().toArray(new BayesVariable[clique.getJunctionTreeClique().getValues().size()]);
        int[] sepVarPos = PotentialMultiplier.createSubsetVarPos(vars, sepVars);
        int sepVarNumberOfStates = PotentialMultiplier.createNumberOfStates(sepVars);
        int[] sepVarMultipliers = PotentialMultiplier.createIndexMultipliers(sepVars, sepVarNumberOfStates);
        BayesAbsorption p = new BayesAbsorption(sepVarPos, oldSepPots, separator.getPotentials(), sepVarMultipliers, vars, clique.getPotentials());
        p.absorb();
    }

    public BayesVariableState marginalize(String name) {
        BayesVariable var = this.variables.get(name);
        if (var == null) {
            throw new IllegalArgumentException("Variable name does not exist '" + name + "'");
        }
        BayesVariableState varState = this.varStates[var.getId()];
        this.marginalize(varState);
        return varState;
    }

    public T marginalize() {
        Object[] args = new Object[this.targetParameterMap.length];
        args[0] = this;
        for (int i = 1; i < this.targetParameterMap.length; ++i) {
            int id = this.targetParameterMap[i];
            BayesVariableState varState = this.varStates[id];
            this.marginalize(varState);
            int highestIndex = 0;
            double highestValue = 0.0;
            int maximalCounts = 1;
            int length = varState.getDistribution().length;
            for (int j = 0; j < length; ++j) {
                if (varState.getDistribution()[j] > highestValue) {
                    highestValue = varState.getDistribution()[j];
                    highestIndex = j;
                    maximalCounts = 1;
                    continue;
                }
                if (j == 0 || varState.getDistribution()[j] != highestValue) continue;
                ++maximalCounts;
            }
            if (maximalCounts > 1) {
                int picked = new Random().nextInt(maximalCounts);
                int count = 0;
                int length2 = varState.getDistribution().length;
                for (int j = 0; j < length2; ++j) {
                    if (varState.getDistribution()[j] != highestValue) continue;
                    highestIndex = j;
                    if (++count > picked) break;
                }
            }
            args[i] = varState.getOutcomes()[highestIndex];
        }
        try {
            return this.targetConstructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + this.targetClass.getSimpleName() + " " + Arrays.asList(args), e);
        }
    }

    public void marginalize(BayesVariableState varState) {
        CliqueState cliqueState = this.cliqueStates[varState.getVariable().getFamily()];
        JunctionTreeClique jtNode = cliqueState.getJunctionTreeClique();
        new Marginalizer(jtNode.getValues().toArray(new BayesVariable[jtNode.getValues().size()]), cliqueState.getPotentials(), varState.getVariable(), varState.getDistribution());
    }

    public SeparatorState[] getSeparatorStates() {
        return this.separatorStates;
    }

    public CliqueState[] getCliqueStates() {
        return this.cliqueStates;
    }

    public BayesVariableState[] getVarStates() {
        return this.varStates;
    }
}

