/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import org.drools.beliefs.bayes.BayesAbsorption;
import org.drools.beliefs.bayes.BayesVariable;

public class BayesProjection {
    int[] trgVarPos;
    int[] trgVarPosMultipliers;
    double[] trgPotentials;
    int trgPotentialIndex;
    BayesVariable[] srcVars;
    double[] srcPotentials;
    int srcPotentialIndex;
    int[] path;

    public BayesProjection(BayesVariable[] srcVars, double[] srcPotentials, int[] trgVarPos, int[] trgVarPosMultipliers, double[] trgPotentials) {
        this.srcVars = srcVars;
        this.srcPotentials = srcPotentials;
        this.trgVarPos = trgVarPos;
        this.trgVarPosMultipliers = trgVarPosMultipliers;
        Arrays.fill(trgPotentials, 0.0);
        this.trgPotentials = trgPotentials;
        this.path = new int[srcVars.length];
    }

    public void project() {
        this.srcPotentialIndex = 0;
        this.trgPotentialIndex = 0;
        this.recurse(0, 0);
        BayesAbsorption.normalize(this.trgPotentials);
    }

    public static void normalize(double[] darray, double sum) {
        int i = 0;
        while (i < darray.length) {
            int n = i++;
            darray[n] = darray[n] / sum;
        }
    }

    public void recurse(int currentVar, int targetVarPos) {
        int numberOfOutcomes = this.srcVars[currentVar].getOutcomes().length;
        boolean isTrgVar = false;
        int nextParentKeyPos = targetVarPos;
        if (this.trgVarPos.length > 0 && targetVarPos < this.trgVarPos.length && this.trgVarPos[targetVarPos] == currentVar) {
            ++nextParentKeyPos;
            isTrgVar = true;
        }
        for (int j = 0; j < numberOfOutcomes; ++j) {
            this.path[currentVar] = j;
            if (currentVar < this.srcVars.length - 1) {
                this.recurse(currentVar + 1, nextParentKeyPos);
            } else {
                int n = this.trgPotentialIndex;
                this.trgPotentials[n] = this.trgPotentials[n] + this.srcPotentials[this.srcPotentialIndex++];
            }
            if (!isTrgVar) continue;
            this.trgPotentialIndex += this.trgVarPosMultipliers[targetVarPos];
        }
        if (isTrgVar) {
            this.trgPotentialIndex -= this.trgVarPosMultipliers[targetVarPos] * numberOfOutcomes;
        }
    }
}

