/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import org.drools.beliefs.bayes.BayesVariable;

public class BayesAbsorption {
    int[] srcVarPos;
    int[] srcVarPosMultipliers;
    double[] srcPotentials;
    double[] oldSrcPotentials;
    int srcPotentialIndex;
    BayesVariable[] trgVars;
    double[] trgPotentials;
    int trgPotentialIndex;
    int[] path;

    public BayesAbsorption(int[] srcVarPos, double[] oldSrcPotentials, double[] srcPotentials, int[] srcVarPosMultipliers, BayesVariable[] trgVars, double[] trgPotentials) {
        this.srcVarPos = srcVarPos;
        this.srcVarPosMultipliers = srcVarPosMultipliers;
        this.srcPotentials = srcPotentials;
        this.oldSrcPotentials = oldSrcPotentials;
        this.trgVars = trgVars;
        this.trgPotentials = trgPotentials;
        this.path = new int[trgVars.length];
    }

    public void absorb() {
        this.srcPotentials = BayesAbsorption.dividePotentials(this.srcPotentials, this.oldSrcPotentials);
        this.trgPotentialIndex = 0;
        this.srcPotentialIndex = 0;
        this.recurse(0, 0);
        BayesAbsorption.normalize(this.trgPotentials);
    }

    public static void normalize(double[] array) {
        int i;
        double sum = 0.0;
        int length = array.length;
        for (i = 0; i < length; ++i) {
            sum += array[i];
        }
        length = array.length;
        for (i = 0; i < length; ++i) {
            array[i] = array[i] / sum;
        }
    }

    public static double[] dividePotentials(double[] potentials, double[] oldPotentials) {
        double[] absorbedPotentials = Arrays.copyOf(potentials, potentials.length);
        for (int i = 0; i < potentials.length; ++i) {
            double oldP = oldPotentials[i];
            if (oldP == 0.0) {
                absorbedPotentials[i] = 0.0;
                continue;
            }
            int n = i;
            absorbedPotentials[n] = absorbedPotentials[n] / oldP;
        }
        return absorbedPotentials;
    }

    public void recurse(int currentVar, int targetVarPos) {
        int numberOfOutcomes = this.trgVars[currentVar].getOutcomes().length;
        boolean isSepVar = false;
        int nextParentKeyPos = targetVarPos;
        if (this.srcVarPos.length > 0 && targetVarPos < this.srcVarPos.length && this.srcVarPos[targetVarPos] == currentVar) {
            ++nextParentKeyPos;
            isSepVar = true;
        }
        for (int j = 0; j < numberOfOutcomes; ++j) {
            this.path[currentVar] = j;
            if (currentVar < this.trgVars.length - 1) {
                this.recurse(currentVar + 1, nextParentKeyPos);
            } else {
                int n = this.trgPotentialIndex++;
                this.trgPotentials[n] = this.trgPotentials[n] * this.srcPotentials[this.srcPotentialIndex];
            }
            if (!isSepVar) continue;
            this.srcPotentialIndex += this.srcVarPosMultipliers[targetVarPos];
        }
        if (isSepVar) {
            this.srcPotentialIndex -= this.srcVarPosMultipliers[targetVarPos] * numberOfOutcomes;
        }
    }
}

