/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.Map;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.ancompiler.CouldNotCreateAlphaNetworkCompilerException;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.index.AlphaRangeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledNetworkSource {
    private final Logger logger = LoggerFactory.getLogger(CompiledNetworkSource.class);
    private final String source;
    private final IndexableConstraint indexableConstraint;
    private final String name;
    private final String sourceName;
    private final ObjectTypeNode objectTypeNode;
    private final Map<String, AlphaRangeIndex> rangeIndexDeclarationMap;

    public CompiledNetworkSource(String source, IndexableConstraint indexableConstraint, String name, String sourceName, ObjectTypeNode objectTypeNode, Map<String, AlphaRangeIndex> rangeIndexDeclarationMap) {
        this.source = source;
        this.indexableConstraint = indexableConstraint;
        this.name = name;
        this.sourceName = sourceName;
        this.objectTypeNode = objectTypeNode;
        this.rangeIndexDeclarationMap = rangeIndexDeclarationMap;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setCompiledNetwork(Class<?> compiledNetworkClass) {
        CompiledNetwork compiledNetwork = this.newCompiledNetworkInstance(compiledNetworkClass);
        compiledNetwork.setNetwork(this.objectTypeNode);
        this.logger.debug("Updating {} with instance of class: {}", (Object)this.objectTypeNode, (Object)compiledNetworkClass.getName());
    }

    public CompiledNetwork newCompiledNetworkInstance(Class<?> aClass) {
        try {
            return (CompiledNetwork)aClass.getDeclaredConstructor(InternalReadAccessor.class, Map.class).newInstance(this.getFieldExtractor(), this.rangeIndexDeclarationMap);
        }
        catch (Exception e) {
            throw new CouldNotCreateAlphaNetworkCompilerException(e);
        }
    }

    private InternalReadAccessor getFieldExtractor() {
        return this.indexableConstraint == null ? null : this.indexableConstraint.getFieldExtractor();
    }
}

