/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.Collection;
import java.util.Map;
import org.drools.ancompiler.NetworkHandler;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkNodeList;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.index.AlphaRangeIndex;

public class ObjectTypeNodeParser {
    private final ObjectTypeNode objectTypeNode;
    private IndexableConstraint indexableConstraint;

    public ObjectTypeNodeParser(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
    }

    public void accept(NetworkHandler handler) {
        ObjectSinkPropagator propagator = this.objectTypeNode.getObjectSinkPropagator();
        handler.startObjectTypeNode(this.objectTypeNode);
        this.indexableConstraint = this.traversePropagator(propagator, handler);
        handler.endObjectTypeNode(this.objectTypeNode);
    }

    private IndexableConstraint traversePropagator(ObjectSinkPropagator propagator, NetworkHandler handler) {
        IndexableConstraint foundIndexableConstraint = null;
        if (propagator instanceof SingleObjectSinkAdapter) {
            ObjectSink sink = propagator.getSinks()[0];
            this.traverseSink(sink, handler);
        } else if (propagator instanceof CompositeObjectSinkAdapter) {
            CompositeObjectSinkAdapter composite = (CompositeObjectSinkAdapter)propagator;
            this.traverseSinkLisk(composite.getRangeIndexableSinks(), handler);
            this.traverseSinkLisk(composite.getHashableSinks(), handler);
            this.traverseSinkLisk(composite.getOthers(), handler);
            this.traverseRangeIndexedAlphaNodes(composite.getRangeIndexMap(), handler);
            foundIndexableConstraint = this.traverseHashedAlphaNodes(composite.getHashedSinkMap(), handler);
        } else if (propagator instanceof CompositePartitionAwareObjectSinkAdapter) {
            CompositePartitionAwareObjectSinkAdapter composite = (CompositePartitionAwareObjectSinkAdapter)propagator;
            this.traverseSinkLisk(composite.getSinks(), handler);
        }
        return foundIndexableConstraint;
    }

    private void traverseSinkLisk(ObjectSinkNodeList sinks, NetworkHandler handler) {
        if (sinks != null) {
            for (ObjectSinkNode sink = sinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.traverseSink((ObjectSink)sink, handler);
            }
        }
    }

    private void traverseSinkLisk(ObjectSink[] sinks, NetworkHandler handler) {
        if (sinks != null) {
            for (ObjectSink sink : sinks) {
                this.traverseSink(sink, handler);
            }
        }
    }

    private IndexableConstraint traverseHashedAlphaNodes(ObjectHashMap hashedAlphaNodes, NetworkHandler handler) {
        IndexableConstraint hashedFieldReader = null;
        if (hashedAlphaNodes != null && hashedAlphaNodes.size() > 0) {
            AlphaNode firstAlpha = this.getFirstAlphaNode(hashedAlphaNodes);
            hashedFieldReader = this.getClassFieldReaderForHashedAlpha(firstAlpha);
            handler.startHashedAlphaNodes(hashedFieldReader);
            Iterator iter = hashedAlphaNodes.iterator();
            AlphaNode optionalNullAlphaNodeCase = null;
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
            while (entry != null) {
                CompositeObjectSinkAdapter.HashKey hashKey = (CompositeObjectSinkAdapter.HashKey)entry.getKey();
                AlphaNode alphaNode = (AlphaNode)entry.getValue();
                Object objectValue = hashKey.getObjectValue();
                if (objectValue != null) {
                    handler.startHashedAlphaNode(alphaNode, objectValue);
                    this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
                    handler.endHashedAlphaNode(alphaNode, hashKey.getObjectValue());
                } else {
                    optionalNullAlphaNodeCase = alphaNode;
                }
                entry = (ObjectHashMap.ObjectEntry)iter.next();
            }
            handler.endHashedAlphaNodes(hashedFieldReader);
            if (optionalNullAlphaNodeCase != null) {
                handler.nullCaseAlphaNodeStart(optionalNullAlphaNodeCase);
                this.traversePropagator(optionalNullAlphaNodeCase.getObjectSinkPropagator(), handler);
                handler.nullCaseAlphaNodeEnd(optionalNullAlphaNodeCase);
            }
        }
        return hashedFieldReader;
    }

    private void traverseRangeIndexedAlphaNodes(Map<CompositeObjectSinkAdapter.FieldIndex, AlphaRangeIndex> rangeIndexMap, NetworkHandler handler) {
        if (rangeIndexMap == null) {
            return;
        }
        Collection<AlphaRangeIndex> rangeIndexes = rangeIndexMap.values();
        for (AlphaRangeIndex alphaRangeIndex : rangeIndexes) {
            Collection alphaNodes = alphaRangeIndex.getAllValues();
            for (AlphaNode alphaNode : alphaNodes) {
                this.traverseSink((ObjectSink)alphaNode, handler);
            }
        }
    }

    private void traverseSink(ObjectSink sink, NetworkHandler handler) {
        if (sink.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)sink;
            handler.startNonHashedAlphaNode(alphaNode);
            this.traversePropagator(alphaNode.getObjectSinkPropagator(), handler);
            handler.endNonHashedAlphaNode(alphaNode);
        } else if (NodeTypeEnums.isBetaNode((NetworkNode)sink)) {
            BetaNode betaNode = (BetaNode)sink;
            handler.startBetaNode(betaNode);
            handler.endBetaNode(betaNode);
        } else if (sink.getType() == 120) {
            LeftInputAdapterNode leftInputAdapterNode = (LeftInputAdapterNode)sink;
            handler.startLeftInputAdapterNode(leftInputAdapterNode);
            handler.endWindowNode(leftInputAdapterNode);
        } else if (sink.getType() == 60) {
            WindowNode windowNode = (WindowNode)sink;
            handler.startWindowNode(windowNode);
            handler.endWindowNode(windowNode);
        }
    }

    private AlphaNode getFirstAlphaNode(ObjectHashMap hashedAlphaNodes) throws IllegalArgumentException {
        Iterator iter = hashedAlphaNodes.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
        if (entry == null) {
            throw new IllegalArgumentException("ObjectHashMap does not contain any hashed AlphaNodes!");
        }
        AlphaNode firstAlphaNode = (AlphaNode)entry.getValue();
        return firstAlphaNode;
    }

    private IndexableConstraint getClassFieldReaderForHashedAlpha(AlphaNode alphaNode) {
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (!(fieldConstraint instanceof IndexableConstraint)) {
            throw new IllegalArgumentException("Only support IndexableConstraint hashed AlphaNodes, not " + fieldConstraint.getClass());
        }
        return (IndexableConstraint)fieldConstraint;
    }

    public IndexableConstraint getIndexableConstraint() {
        return this.indexableConstraint;
    }
}

