/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.ancompiler.AssertHandler;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.ancompiler.CompiledNetworkSource;
import org.drools.ancompiler.DeclarationsHandler;
import org.drools.ancompiler.DelegateMethodsHandler;
import org.drools.ancompiler.HashedAlphasDeclaration;
import org.drools.ancompiler.ModifyHandler;
import org.drools.ancompiler.ObjectTypeNodeParser;
import org.drools.ancompiler.SetNodeReferenceHandler;
import org.drools.core.InitialFact;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeNodeCompiler {
    private static final String NEWLINE = "\n";
    private static final String PACKAGE_NAME = "org.drools.ancompiler";
    private static final String BINARY_PACKAGE_NAME = "org.drools.ancompiler".replace('.', '/');
    private String className;
    private String generatedClassSimpleName;
    private ObjectTypeNode objectTypeNode;
    private StringBuilder builder = new StringBuilder();
    private static final Logger logger = LoggerFactory.getLogger(ObjectTypeNodeCompiler.class);

    public ObjectTypeNodeCompiler(ObjectTypeNode objectTypeNode) {
        this.objectTypeNode = objectTypeNode;
        ClassObjectType classObjectType = (ClassObjectType)objectTypeNode.getObjectType();
        this.className = classObjectType.getClassName().replace("$", ".");
        String classObjectTypeName = classObjectType.getClassName().replace('.', '_');
        String otnHash = String.valueOf(objectTypeNode.hashCode()).replace("-", "");
        this.generatedClassSimpleName = String.format("Compiled%sNetwork%d%s", classObjectTypeName, objectTypeNode.getId(), otnHash);
    }

    public CompiledNetworkSource generateSource() {
        this.createClassDeclaration();
        ObjectTypeNodeParser parser = new ObjectTypeNodeParser(this.objectTypeNode);
        DeclarationsHandler declarations = new DeclarationsHandler(this.builder);
        parser.accept(declarations);
        Collection<HashedAlphasDeclaration> hashedAlphaDeclarations = declarations.getHashedAlphaDeclarations();
        this.createConstructor(hashedAlphaDeclarations);
        SetNodeReferenceHandler setNode = new SetNodeReferenceHandler(this.builder);
        parser.accept(setNode);
        AssertHandler assertHandler = new AssertHandler(this.builder, this.className, !hashedAlphaDeclarations.isEmpty());
        parser.accept(assertHandler);
        ModifyHandler modifyHandler = new ModifyHandler(this.builder, this.className, !hashedAlphaDeclarations.isEmpty());
        parser.accept(modifyHandler);
        DelegateMethodsHandler delegateMethodsHandler = new DelegateMethodsHandler(this.builder);
        parser.accept(delegateMethodsHandler);
        this.builder.append("}").append(NEWLINE);
        String sourceCode = this.builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Generated Compiled Alpha Network %s", sourceCode));
        }
        return new CompiledNetworkSource(sourceCode, parser.getIndexableConstraint(), this.getName(), this.getSourceName(), this.objectTypeNode);
    }

    private void createClassDeclaration() {
        this.builder.append("package ").append(PACKAGE_NAME).append(";").append(NEWLINE);
        this.builder.append("public class ").append(this.generatedClassSimpleName).append(" extends ").append(CompiledNetwork.class.getName()).append("{ ").append(NEWLINE);
        this.builder.append(String.format("private static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(%s.class);%n", this.generatedClassSimpleName));
        this.builder.append("org.drools.core.spi.InternalReadAccessor readAccessor;\n");
    }

    private void createConstructor(Collection<HashedAlphasDeclaration> hashedAlphaDeclarations) {
        this.builder.append("public ").append(this.generatedClassSimpleName).append("(org.drools.core.spi.InternalReadAccessor readAccessor) {").append(NEWLINE);
        this.builder.append("this.readAccessor = readAccessor;\n");
        for (HashedAlphasDeclaration declaration : hashedAlphaDeclarations) {
            String mapVariableName = declaration.getVariableName();
            for (Object hashedValue : declaration.getHashedValues()) {
                String nodeId;
                Object value = hashedValue;
                if (value == null) {
                    nodeId = declaration.getNodeId(hashedValue);
                    this.builder.append(mapVariableName).append(".put(null,").append(nodeId).append(");");
                    this.builder.append(NEWLINE);
                    continue;
                }
                if (value.getClass().equals(String.class)) {
                    value = "\"" + value + "\"";
                } else if (value instanceof BigDecimal) {
                    value = "new java.math.BigDecimal(\"" + value + "\")";
                } else if (value instanceof BigInteger) {
                    value = "new java.math.BigInteger(\"" + value + "\")";
                }
                nodeId = declaration.getNodeId(hashedValue);
                this.builder.append(mapVariableName).append(".put(").append(value).append(", ").append(nodeId).append(");");
                this.builder.append(NEWLINE);
            }
        }
        this.builder.append("}").append(NEWLINE);
    }

    private String getName() {
        return this.getPackageName() + "." + this.generatedClassSimpleName;
    }

    private String getBinaryName() {
        return BINARY_PACKAGE_NAME + "/" + this.generatedClassSimpleName + ".class";
    }

    private String getSourceName() {
        return BINARY_PACKAGE_NAME + "/" + this.generatedClassSimpleName + ".java";
    }

    private String getPackageName() {
        return PACKAGE_NAME;
    }

    public static List<CompiledNetworkSource> compiledNetworkSources(Rete rete) {
        return ObjectTypeNodeCompiler.objectTypeNodeCompiler(rete).stream().map(ObjectTypeNodeCompiler::generateSource).collect(Collectors.toList());
    }

    public static List<ObjectTypeNodeCompiler> objectTypeNodeCompiler(Rete rete) {
        return ObjectTypeNodeCompiler.objectTypeNodes(rete).stream().map(ObjectTypeNodeCompiler::new).collect(Collectors.toList());
    }

    public static List<ObjectTypeNode> objectTypeNodes(Rete rete) {
        return rete.getEntryPointNodes().values().stream().flatMap(ep -> ep.getObjectTypeNodes().values().stream()).filter(f -> !InitialFact.class.isAssignableFrom(f.getObjectType().getClassType())).collect(Collectors.toList());
    }

    public static Map<String, CompiledNetworkSource> compiledNetworkSourceMap(Rete rete) {
        List<CompiledNetworkSource> compiledNetworkSources = ObjectTypeNodeCompiler.compiledNetworkSources(rete);
        return compiledNetworkSources.stream().collect(Collectors.toMap(CompiledNetworkSource::getName, Function.identity()));
    }

    public static Map<ObjectTypeNode, String> otnWithClassName(Rete rete) {
        List<ObjectTypeNodeCompiler> compiledNetworkSources = ObjectTypeNodeCompiler.objectTypeNodeCompiler(rete);
        return compiledNetworkSources.stream().collect(Collectors.toMap(k -> k.objectTypeNode, ObjectTypeNodeCompiler::getName));
    }
}

