/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.drools.ancompiler.AbstractCompilerHandler;
import org.drools.ancompiler.HashedAlphasDeclaration;
import org.drools.core.base.ValueType;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.IndexableConstraint;

public class DeclarationsHandler
extends AbstractCompilerHandler {
    private static final String PRIVATE_MODIFIER = "private";
    private HashedAlphasDeclaration currentHashedAlpha;
    private final StringBuilder builder;
    private final Collection<HashedAlphasDeclaration> hashedAlphaDeclarations;

    public DeclarationsHandler(StringBuilder builder) {
        this.builder = builder;
        this.hashedAlphaDeclarations = new LinkedList<HashedAlphasDeclaration>();
    }

    private String getVariableDeclaration(AlphaNode alphaNode) {
        Class<?> variableType = this.getVariableType(alphaNode);
        String variableName = this.getVariableName(alphaNode);
        String comment = alphaNode.toString().replace("\\n", "");
        return "private " + variableType.getName() + " " + variableName + "; // " + comment;
    }

    private String getContextVariableDeclaration(AlphaNode alphaNode) {
        Class<ContextEntry> variableType = ContextEntry.class;
        String variableName = this.getContextVariableName(alphaNode);
        return "private " + variableType.getName() + " " + variableName + ";";
    }

    private String getVariableDeclaration(Sink sink) {
        Class<?> declarationType = this.getVariableType(sink);
        String variableName = this.getVariableName(sink);
        String comment = sink.toString();
        return "private " + declarationType.getName() + " " + variableName + "; // " + comment;
    }

    private String getVariableDeclaration(String varName) {
        Class<Map> declarationType = Map.class;
        Class<HashMap> createType = HashMap.class;
        return "private " + declarationType.getName() + " " + varName + " = new " + createType.getName() + "();";
    }

    public Collection<HashedAlphasDeclaration> getHashedAlphaDeclarations() {
        return Collections.unmodifiableCollection(this.hashedAlphaDeclarations);
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append(this.getVariableDeclaration(alphaNode)).append("\n");
        this.builder.append(this.getContextVariableDeclaration(alphaNode)).append("\n");
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.builder.append(this.getVariableDeclaration((Sink)betaNode)).append("\n");
    }

    @Override
    public void startWindowNode(WindowNode windowNode) {
        this.builder.append(this.getVariableDeclaration((Sink)windowNode)).append("\n");
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append(this.getVariableDeclaration((Sink)leftInputAdapterNode)).append("\n");
    }

    @Override
    public void startHashedAlphaNodes(IndexableConstraint indexableConstraint) {
        String variableName = this.getVariableName();
        this.currentHashedAlpha = new HashedAlphasDeclaration(variableName, ValueType.STRING_TYPE);
        this.hashedAlphaDeclarations.add(this.currentHashedAlpha);
        String alphaMap = this.getVariableDeclaration(variableName);
        this.builder.append(alphaMap).append("\n");
    }

    @Override
    public void startHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.currentHashedAlpha.add(hashedValue, String.valueOf(hashedAlpha.getId()));
    }
}

