/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.trans.extend;

import com.baomidou.mybatisplus.annotation.TableName;
import java.util.ArrayList;
import java.util.Set;
import org.dromara.common.spring.SpringContextUtil;
import org.dromara.core.trans.anno.AutoTrans;
import org.dromara.core.trans.vo.VO;
import org.dromara.trans.extend.MybatisPlusTransableAdapter;
import org.dromara.trans.service.AutoTransable;
import org.dromara.trans.service.impl.AutoTransService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class MybatisPlusTransableRegister
implements ApplicationListener<ApplicationReadyEvent> {
    private String packageNames;
    @Autowired
    private AutoTransService autoTransService;

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        Set entitySet = AutoTransService.scan(AutoTrans.class, (String[])this.packageNames.split(";"));
        if (entitySet != null) {
            ArrayList<String> namespaceList = new ArrayList<String>();
            for (Class entity : entitySet) {
                Object baseService;
                AutoTrans autoTransSett = entity.getAnnotation(AutoTrans.class);
                if (autoTransSett.ref() == VO.class || !autoTransSett.ref().isAnnotationPresent(TableName.class) || (baseService = SpringContextUtil.getBeanByClass((Class)entity)) instanceof AutoTransable) continue;
                namespaceList.add(autoTransSett.namespace());
                this.autoTransService.regTransable((AutoTransable)new MybatisPlusTransableAdapter(autoTransSett.ref()), autoTransSett);
            }
            new Thread(() -> {
                Thread.currentThread().setName("refresh auto trans cache");
                for (String namespace : namespaceList) {
                    this.autoTransService.refreshOneNamespace(namespace);
                }
            }).start();
        }
    }

    public String getPackageNames() {
        return this.packageNames;
    }

    public AutoTransService getAutoTransService() {
        return this.autoTransService;
    }

    public void setPackageNames(String packageNames) {
        this.packageNames = packageNames;
    }

    public void setAutoTransService(AutoTransService autoTransService) {
        this.autoTransService = autoTransService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MybatisPlusTransableRegister)) {
            return false;
        }
        MybatisPlusTransableRegister other = (MybatisPlusTransableRegister)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$packageNames = this.getPackageNames();
        String other$packageNames = other.getPackageNames();
        if (this$packageNames == null ? other$packageNames != null : !this$packageNames.equals(other$packageNames)) {
            return false;
        }
        AutoTransService this$autoTransService = this.getAutoTransService();
        AutoTransService other$autoTransService = other.getAutoTransService();
        return !(this$autoTransService == null ? other$autoTransService != null : !this$autoTransService.equals(other$autoTransService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MybatisPlusTransableRegister;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageNames = this.getPackageNames();
        result = result * 59 + ($packageNames == null ? 43 : $packageNames.hashCode());
        AutoTransService $autoTransService = this.getAutoTransService();
        result = result * 59 + ($autoTransService == null ? 43 : $autoTransService.hashCode());
        return result;
    }

    public String toString() {
        return "MybatisPlusTransableRegister(packageNames=" + this.getPackageNames() + ", autoTransService=" + this.getAutoTransService() + ")";
    }
}

