/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public final class BeanRegistrationUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanRegistrationUtil.class);

    private BeanRegistrationUtil() {
    }

    public static void register(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> propertyValues, Object ... constructorArgs) {
        BeanRegistrationUtil.register(registry, beanName, clazz, propertyValues, null, constructorArgs);
    }

    public static void register(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> propertyValues, List<String> dependsOnBeanNames, Object ... constructorArgs) {
        if (BeanRegistrationUtil.ifPresent(registry, beanName, clazz) || registry.containsBeanDefinition(beanName)) {
            log.info("DynamicTp registrar, bean [{}] already exists and will be overwritten", (Object)beanName);
            registry.removeBeanDefinition(beanName);
        }
        BeanRegistrationUtil.doRegister(registry, beanName, clazz, propertyValues, dependsOnBeanNames, constructorArgs);
    }

    public static void registerIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Object ... constructorArgs) {
        BeanRegistrationUtil.registerIfAbsent(registry, beanName, clazz, null, null, constructorArgs);
    }

    public static void registerIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> propertyValues, Object ... constructorArgs) {
        BeanRegistrationUtil.registerIfAbsent(registry, beanName, clazz, propertyValues, null, constructorArgs);
    }

    public static void registerIfAbsent(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> propertyValues, List<String> dependsOnBeanNames, Object ... constructorArgs) {
        if (!BeanRegistrationUtil.ifPresent(registry, beanName, clazz) && !registry.containsBeanDefinition(beanName)) {
            BeanRegistrationUtil.doRegister(registry, beanName, clazz, propertyValues, dependsOnBeanNames, constructorArgs);
        }
    }

    public static boolean ifPresent(BeanDefinitionRegistry registry, String beanName, Class<?> clazz) {
        Object[] beanNames = BeanRegistrationUtil.getBeanNames((ListableBeanFactory)registry, clazz);
        return ArrayUtils.contains((Object[])beanNames, (Object)beanName);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> clazz) {
        return beanFactory.getBeanNamesForType(clazz, true, false);
    }

    private static void doRegister(BeanDefinitionRegistry registry, String beanName, Class<?> clazz, Map<String, Object> propertyValues, List<String> dependsOnBeanNames, Object ... constructorArgs) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Object constructorArg : constructorArgs) {
            builder.addConstructorArgValue(constructorArg);
        }
        if (MapUtils.isNotEmpty(propertyValues)) {
            propertyValues.forEach((arg_0, arg_1) -> ((BeanDefinitionBuilder)builder).addPropertyValue(arg_0, arg_1));
        }
        if (CollectionUtils.isNotEmpty(dependsOnBeanNames)) {
            dependsOnBeanNames.forEach(arg_0 -> ((BeanDefinitionBuilder)builder).addDependsOn(arg_0));
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }
}

