/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.holder;

import java.util.Map;
import java.util.Objects;
import org.dromara.dynamictp.common.manager.ContextManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class SpringContextHolder
implements ContextManager,
ApplicationContextAware {
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public <T> T getBean(Class<T> clazz) {
        return (T)SpringContextHolder.getInstance().getBean(clazz);
    }

    public <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContextHolder.getInstance().getBean(name, clazz);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return SpringContextHolder.getInstance().getBeansOfType(clazz);
    }

    public static ApplicationContext getInstance() {
        if (Objects.isNull(context)) {
            throw new NullPointerException("ApplicationContext is null, please check if the spring container is started.");
        }
        return context;
    }

    public Environment getEnvironment() {
        return SpringContextHolder.getInstance().getEnvironment();
    }

    public String getEnvironmentProperty(String key) {
        return this.getEnvironment().getProperty(key);
    }

    public String getEnvironmentProperty(String key, Object environment) {
        if (environment instanceof Environment) {
            Environment env = (Environment)environment;
            return env.getProperty(key);
        }
        return null;
    }

    public String getEnvironmentProperty(String key, String defaultValue) {
        return this.getEnvironment().getProperty(key, defaultValue);
    }
}

