/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.springboot.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.dromara.autotable.springboot.util.AnnotationDefaultValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class AnnotatedElementUtilsPlus
extends AnnotatedElementUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotatedElementUtilsPlus.class);

    public static <ANNO extends Annotation> ANNO getDeepMergedAnnotation(AnnotatedElement element, Class<ANNO> annoClass) {
        Set allMergedAnnotations = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)element, annoClass);
        return AnnotatedElementUtilsPlus.merge(annoClass, allMergedAnnotations);
    }

    public static <ANNO extends Annotation> ANNO findDeepMergedAnnotation(AnnotatedElement element, Class<ANNO> annoClass) {
        Set allMergedAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)element, annoClass);
        return AnnotatedElementUtilsPlus.merge(annoClass, allMergedAnnotations);
    }

    public static <ANNO extends Annotation> ANNO merge(Class<ANNO> annoClass, Set<ANNO> allAnnotations) {
        if (allAnnotations == null || allAnnotations.isEmpty()) {
            return null;
        }
        try {
            Map<String, Object> annoDefaultAttributes = AnnotationDefaultValueHelper.getDefaultValues(annoClass);
            for (Map.Entry<String, Object> attribute : annoDefaultAttributes.entrySet()) {
                String annoFieldName = attribute.getKey();
                Object defaultVal = attribute.getValue();
                Object newVal = null;
                for (Annotation annotation : allAnnotations) {
                    try {
                        Object annoVal = annoClass.getMethod(annoFieldName, new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (!AnnotatedElementUtilsPlus.compareValIsDiff(annoVal, defaultVal)) continue;
                        newVal = annoVal;
                        break;
                    }
                    catch (Exception e) {
                        log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u83b7\u53d6\u6ce8\u89e3\u503c\u51fa\u9519", (Throwable)e);
                    }
                }
                if (newVal == null) continue;
                annoDefaultAttributes.put(annoFieldName, newVal);
            }
            return AnnotationDefaultValueHelper.createAnnotationInstance(annoClass, annoDefaultAttributes);
        }
        catch (Exception e) {
            log.warn("\u5408\u5e76TableField\u8fc7\u7a0b\u4e2d\uff0c\u83b7\u53d6\u9ed8\u8ba4\u503c\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private static boolean compareValIsDiff(Object val, Object defVal) {
        if (val == null) {
            return false;
        }
        if (defVal == null) {
            return true;
        }
        if (defVal.getClass().isArray()) {
            List<Object> list = Arrays.asList(val);
            List<Object> defList = Arrays.asList(defVal);
            if (!list.isEmpty() && list.size() == defList.size()) {
                return !list.containsAll(defList);
            }
            return !list.isEmpty();
        }
        return !Objects.equals(val, defVal);
    }
}

