/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import android.util.SparseArray;
import com.hoho.android.usbserial.driver.CommonUsbSerialDriver;
import java.io.IOException;
import java.lang.reflect.Method;

public class ProlificSerialDriver
extends CommonUsbSerialDriver {
    private final String TAG = ProlificSerialDriver.class.getSimpleName();
    private static final int USB_READ_TIMEOUT_MILLIS = 1000;
    private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int PROLIFIC_VENDOR_READ_REQUEST = 1;
    private static final int PROLIFIC_VENDOR_WRITE_REQUEST = 1;
    private static final int PROLIFIC_VENDOR_OUT_REQTYPE = 64;
    private static final int PROLIFIC_VENDOR_IN_REQTYPE = 192;
    private static final int PROLIFIC_CTRL_OUT_REQTYPE = 33;
    private static final int WRITE_ENDPOINT = 2;
    private static final int READ_ENDPOINT = 131;
    private static final int INTERRUPT_ENDPOINT = 129;
    private static final int FLUSH_RX_REQUEST = 8;
    private static final int FLUSH_TX_REQUEST = 9;
    private static final int SET_LINE_REQUEST = 32;
    private static final int SET_CONTROL_REQUEST = 34;
    private static final int CONTROL_DTR = 1;
    private static final int CONTROL_RTS = 2;
    private static final int STATUS_FLAG_CD = 1;
    private static final int STATUS_FLAG_DSR = 2;
    private static final int STATUS_FLAG_RI = 8;
    private static final int STATUS_FLAG_CTS = 128;
    private static final int STATUS_BUFFER_SIZE = 10;
    private static final int STATUS_BYTE_IDX = 8;
    private static final int DEVICE_TYPE_HX = 0;
    private static final int DEVICE_TYPE_0 = 1;
    private static final int DEVICE_TYPE_1 = 2;
    private int mDeviceType = 0;
    private UsbEndpoint mReadEndpoint;
    private UsbEndpoint mWriteEndpoint;
    private UsbEndpoint mInterruptEndpoint;
    private int mControlLinesValue = 0;
    private int mBaudRate = -1;
    private int mDataBits = -1;
    private int mStopBits = -1;
    private int mParity = -1;
    private int mStatus = 0;
    private volatile Thread mReadStatusThread = null;
    private final Object mReadStatusThreadLock = new Object();
    boolean mStopReadStatusThread = false;
    private IOException mReadStatusException = null;

    public ProlificSerialDriver(UsbDevice device, UsbDeviceConnection connection) {
        super(device, connection);
    }

    public static SparseArray<int[]> getSupportedDevices() {
        SparseArray supportedDevices = new SparseArray(1);
        supportedDevices.put(1659, (Object)new int[]{8963});
        return supportedDevices;
    }

    private final byte[] inControlTransfer(int requestType, int request, int value, int index, int length) throws IOException {
        byte[] buffer = new byte[length];
        int result = this.mConnection.controlTransfer(requestType, request, value, index, buffer, length, 1000);
        if (result != length) {
            throw new IOException(String.format("ControlTransfer with value 0x%x failed: %d", value, result));
        }
        return buffer;
    }

    private final void outControlTransfer(int requestType, int request, int value, int index, byte[] data) throws IOException {
        int length = data == null ? 0 : data.length;
        int result = this.mConnection.controlTransfer(requestType, request, value, index, data, length, 5000);
        if (result != length) {
            throw new IOException(String.format("ControlTransfer with value 0x%x failed: %d", value, result));
        }
    }

    private final byte[] vendorIn(int value, int index, int length) throws IOException {
        return this.inControlTransfer(192, 1, value, index, length);
    }

    private final void vendorOut(int value, int index, byte[] data) throws IOException {
        this.outControlTransfer(64, 1, value, index, data);
    }

    private void resetDevice() throws IOException {
        this.purgeHwBuffers(true, true);
    }

    private final void ctrlOut(int request, int value, int index, byte[] data) throws IOException {
        this.outControlTransfer(33, request, value, index, data);
    }

    private void doBlackMagic() throws IOException {
        this.vendorIn(33924, 0, 1);
        this.vendorOut(1028, 0, null);
        this.vendorIn(33924, 0, 1);
        this.vendorIn(33667, 0, 1);
        this.vendorIn(33924, 0, 1);
        this.vendorOut(1028, 1, null);
        this.vendorIn(33924, 0, 1);
        this.vendorIn(33667, 0, 1);
        this.vendorOut(0, 1, null);
        this.vendorOut(1, 0, null);
        this.vendorOut(2, this.mDeviceType == 0 ? 68 : 36, null);
    }

    private void setControlLines(int newControlLinesValue) throws IOException {
        this.ctrlOut(34, newControlLinesValue, 0, null);
        this.mControlLinesValue = newControlLinesValue;
    }

    private final void readStatusThreadFunction() {
        try {
            while (!this.mStopReadStatusThread) {
                byte[] buffer = new byte[10];
                int readBytesCount = this.mConnection.bulkTransfer(this.mInterruptEndpoint, buffer, 10, 500);
                if (readBytesCount <= 0) continue;
                if (readBytesCount == 10) {
                    this.mStatus = buffer[8] & 0xFF;
                    continue;
                }
                throw new IOException(String.format("Invalid CTS / DSR / CD / RI status buffer received, expected %d bytes, but received %d", 10, readBytesCount));
            }
        }
        catch (IOException e) {
            this.mReadStatusException = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getStatus() throws IOException {
        if (this.mReadStatusThread == null && this.mReadStatusException == null) {
            Object object = this.mReadStatusThreadLock;
            synchronized (object) {
                if (this.mReadStatusThread == null) {
                    byte[] buffer = new byte[10];
                    int readBytes = this.mConnection.bulkTransfer(this.mInterruptEndpoint, buffer, 10, 100);
                    if (readBytes != 10) {
                        Log.w((String)this.TAG, (String)"Could not read initial CTS / DSR / CD / RI status");
                    } else {
                        this.mStatus = buffer[8] & 0xFF;
                    }
                    this.mReadStatusThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ProlificSerialDriver.this.readStatusThreadFunction();
                        }
                    });
                    this.mReadStatusThread.setDaemon(true);
                    this.mReadStatusThread.start();
                }
            }
        }
        IOException readStatusException = this.mReadStatusException;
        if (this.mReadStatusException != null) {
            this.mReadStatusException = null;
            throw readStatusException;
        }
        return this.mStatus;
    }

    private final boolean testStatusFlag(int flag) throws IOException {
        return (this.getStatus() & flag) == flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        boolean opened = false;
        try {
            for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                UsbInterface usbIface = this.mDevice.getInterface(i);
                if (this.mConnection.claimInterface(usbIface, true)) {
                    Log.d((String)this.TAG, (String)("claimInterface " + i + " SUCCESS"));
                    continue;
                }
                Log.d((String)this.TAG, (String)("claimInterface " + i + " FAIL"));
            }
            UsbInterface dataIface = this.mDevice.getInterface(this.mDevice.getInterfaceCount() - 1);
            block12: for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                UsbEndpoint ep = dataIface.getEndpoint(i);
                switch (ep.getAddress()) {
                    case 131: {
                        this.mReadEndpoint = ep;
                        continue block12;
                    }
                    case 2: {
                        this.mWriteEndpoint = ep;
                        continue block12;
                    }
                    case 129: {
                        this.mInterruptEndpoint = ep;
                    }
                }
            }
            if (this.mDevice.getDeviceClass() == 2) {
                this.mDeviceType = 1;
            } else {
                try {
                    Method getRawDescriptorsMethod = this.mConnection.getClass().getMethod("getRawDescriptors", new Class[0]);
                    byte[] rawDescriptors = (byte[])getRawDescriptorsMethod.invoke((Object)this.mConnection, new Object[0]);
                    byte maxPacketSize0 = rawDescriptors[7];
                    if (maxPacketSize0 == 64) {
                        this.mDeviceType = 0;
                    } else if (this.mDevice.getDeviceClass() == 0 || this.mDevice.getDeviceClass() == 255) {
                        this.mDeviceType = 2;
                    } else {
                        Log.w((String)this.TAG, (String)"Could not detect PL2303 subtype, Assuming that it is a HX device");
                        this.mDeviceType = 0;
                    }
                }
                catch (NoSuchMethodException e) {
                    Log.w((String)this.TAG, (String)"Method UsbDeviceConnection.getRawDescriptors, required for PL2303 subtype detection, not available! Assuming that it is a HX device");
                    this.mDeviceType = 0;
                }
                catch (Exception e) {
                    Log.e((String)this.TAG, (String)"An unexpected exception occured while trying to detect PL2303 subtype", (Throwable)e);
                }
            }
            this.setControlLines(this.mControlLinesValue);
            this.resetDevice();
            this.doBlackMagic();
            opened = true;
        }
        finally {
            if (!opened) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.mStopReadStatusThread = true;
            Object object = this.mReadStatusThreadLock;
            synchronized (object) {
                if (this.mReadStatusThread != null) {
                    try {
                        this.mReadStatusThread.join();
                    }
                    catch (Exception e) {
                        Log.w((String)this.TAG, (String)"An error occured while waiting for status read thread", (Throwable)e);
                    }
                }
            }
            this.resetDevice();
        }
        finally {
            this.mConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int timeoutMillis) throws IOException {
        int numBytesRead;
        Object object = this.mReadBufferLock;
        synchronized (object) {
            int readAmt = Math.min(dest.length, this.mReadBuffer.length);
            numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeoutMillis);
            if (numBytesRead < 0) {
                return 0;
            }
            System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
        }
        return numBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] src, int timeoutMillis) throws IOException {
        int offset;
        int amtWritten;
        for (offset = 0; offset < src.length; offset += amtWritten) {
            int writeLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                    writeBuffer = this.mWriteBuffer;
                }
                amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
            }
            if (amtWritten > 0) continue;
            throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
        }
        return offset;
    }

    @Override
    public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
        if (this.mBaudRate == baudRate && this.mDataBits == dataBits && this.mStopBits == stopBits && this.mParity == parity) {
            return;
        }
        byte[] lineRequestData = new byte[7];
        lineRequestData[0] = (byte)(baudRate & 0xFF);
        lineRequestData[1] = (byte)(baudRate >> 8 & 0xFF);
        lineRequestData[2] = (byte)(baudRate >> 16 & 0xFF);
        lineRequestData[3] = (byte)(baudRate >> 24 & 0xFF);
        switch (stopBits) {
            case 1: {
                lineRequestData[4] = 0;
                break;
            }
            case 3: {
                lineRequestData[4] = 1;
                break;
            }
            case 2: {
                lineRequestData[4] = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stopBits value: " + stopBits);
            }
        }
        switch (parity) {
            case 0: {
                lineRequestData[5] = 0;
                break;
            }
            case 1: {
                lineRequestData[5] = 1;
                break;
            }
            case 3: {
                lineRequestData[5] = 3;
                break;
            }
            case 4: {
                lineRequestData[5] = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown parity value: " + parity);
            }
        }
        lineRequestData[6] = (byte)dataBits;
        this.ctrlOut(32, 0, 0, lineRequestData);
        this.resetDevice();
        this.mBaudRate = baudRate;
        this.mDataBits = dataBits;
        this.mStopBits = stopBits;
        this.mParity = parity;
    }

    @Override
    public boolean getCD() throws IOException {
        return this.testStatusFlag(1);
    }

    @Override
    public boolean getCTS() throws IOException {
        return this.testStatusFlag(128);
    }

    @Override
    public boolean getDSR() throws IOException {
        return this.testStatusFlag(2);
    }

    @Override
    public boolean getDTR() throws IOException {
        return (this.mControlLinesValue & 1) == 1;
    }

    @Override
    public void setDTR(boolean value) throws IOException {
        int newControlLinesValue = value ? this.mControlLinesValue | 1 : this.mControlLinesValue & 0xFFFFFFFE;
        this.setControlLines(newControlLinesValue);
    }

    @Override
    public boolean getRI() throws IOException {
        return this.testStatusFlag(8);
    }

    @Override
    public boolean getRTS() throws IOException {
        return (this.mControlLinesValue & 2) == 2;
    }

    @Override
    public void setRTS(boolean value) throws IOException {
        int newControlLinesValue = value ? this.mControlLinesValue | 2 : this.mControlLinesValue & 0xFFFFFFFD;
        this.setControlLines(newControlLinesValue);
    }

    public boolean purgeHwBuffers(boolean purgeReadBuffers, boolean purgeWriteBuffers) throws IOException {
        if (purgeReadBuffers) {
            this.vendorOut(8, 0, null);
        }
        if (purgeWriteBuffers) {
            this.vendorOut(9, 0, null);
        }
        return purgeReadBuffers || purgeWriteBuffers;
    }
}

