/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.io.IOException;

abstract class CommonUsbSerialDriver
implements UsbSerialDriver {
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;
    protected final UsbDevice mDevice;
    protected final UsbDeviceConnection mConnection;
    protected final Object mReadBufferLock = new Object();
    protected final Object mWriteBufferLock = new Object();
    protected byte[] mReadBuffer;
    protected byte[] mWriteBuffer;

    public CommonUsbSerialDriver(UsbDevice device, UsbDeviceConnection connection) {
        this.mDevice = device;
        this.mConnection = connection;
        this.mReadBuffer = new byte[16384];
        this.mWriteBuffer = new byte[16384];
    }

    public final UsbDevice getDevice() {
        return this.mDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadBufferSize(int bufferSize) {
        Object object = this.mReadBufferLock;
        synchronized (object) {
            if (bufferSize == this.mReadBuffer.length) {
                return;
            }
            this.mReadBuffer = new byte[bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteBufferSize(int bufferSize) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            if (bufferSize == this.mWriteBuffer.length) {
                return;
            }
            this.mWriteBuffer = new byte[bufferSize];
        }
    }

    @Override
    public abstract void open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int read(byte[] var1, int var2) throws IOException;

    @Override
    public abstract int write(byte[] var1, int var2) throws IOException;

    @Override
    public abstract void setParameters(int var1, int var2, int var3, int var4) throws IOException;

    @Override
    public abstract boolean getCD() throws IOException;

    @Override
    public abstract boolean getCTS() throws IOException;

    @Override
    public abstract boolean getDSR() throws IOException;

    @Override
    public abstract boolean getDTR() throws IOException;

    @Override
    public abstract void setDTR(boolean var1) throws IOException;

    @Override
    public abstract boolean getRI() throws IOException;

    @Override
    public abstract boolean getRTS() throws IOException;

    @Override
    public abstract void setRTS(boolean var1) throws IOException;
}

