/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javapns.notification.PushNotificationManager;
import javapns.notification.ResponsePacket;

class ResponsePacketReader {
    private static final int TIMEOUT = 5000;

    private ResponsePacketReader() {
    }

    public static int processResponses(PushNotificationManager notificationManager) {
        List<ResponsePacket> responses = ResponsePacketReader.readResponses(notificationManager.getActiveSocket());
        ResponsePacketReader.handleResponses(responses, notificationManager);
        return responses.size();
    }

    private static List<ResponsePacket> readResponses(Socket socket) {
        ArrayList<ResponsePacket> responses = new ArrayList<ResponsePacket>();
        int previousTimeout = 0;
        try {
            ResponsePacket packet;
            try {
                previousTimeout = socket.getSoTimeout();
                socket.setSoTimeout(5000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream input = socket.getInputStream();
            while ((packet = ResponsePacketReader.readResponsePacketData(input)) != null) {
                responses.add(packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.setSoTimeout(previousTimeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return responses;
    }

    private static void handleResponses(List<ResponsePacket> responses, PushNotificationManager notificationManager) {
        for (ResponsePacket response : responses) {
            response.linkToPushedNotification(notificationManager);
        }
    }

    private static ResponsePacket readResponsePacketData(InputStream input) throws IOException {
        int command = input.read();
        if (command < 0) {
            return null;
        }
        int status = input.read();
        if (status < 0) {
            return null;
        }
        int identifierByte1 = input.read();
        if (identifierByte1 < 0) {
            return null;
        }
        int identifierByte2 = input.read();
        if (identifierByte2 < 0) {
            return null;
        }
        int identifierByte3 = input.read();
        if (identifierByte3 < 0) {
            return null;
        }
        int identifierByte4 = input.read();
        if (identifierByte4 < 0) {
            return null;
        }
        int identifier = (identifierByte1 << 24) + (identifierByte2 << 16) + (identifierByte3 << 8) + identifierByte4;
        return new ResponsePacket(command, status, identifier);
    }
}

