/*
 * Decompiled with CFR 0.152.
 */
package javapns;

import java.util.ArrayList;
import java.util.List;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.Devices;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.feedback.AppleFeedbackServerBasicImpl;
import javapns.feedback.FeedbackServiceManager;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.NewsstandNotificationPayload;
import javapns.notification.Payload;
import javapns.notification.PayloadPerDevice;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import javapns.notification.transmission.NotificationThread;
import javapns.notification.transmission.NotificationThreads;
import javapns.notification.transmission.PushQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Push {
    private static final Logger logger = LoggerFactory.getLogger(Push.class);

    private Push() {
    }

    public static PushedNotifications alert(String message, Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(PushNotificationPayload.alert(message), keystore, password, production, devices);
    }

    public static PushedNotifications badge(int badge, Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(PushNotificationPayload.badge(badge), keystore, password, production, devices);
    }

    public static PushedNotifications sound(String sound, Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(PushNotificationPayload.sound(sound), keystore, password, production, devices);
    }

    public static PushedNotifications combined(String message, int badge, String sound, Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(PushNotificationPayload.combined(message, badge, sound), keystore, password, production, devices);
    }

    public static PushedNotifications contentAvailable(Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(NewsstandNotificationPayload.contentAvailable(), keystore, password, production, devices);
    }

    public static PushedNotifications test(Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(PushNotificationPayload.test(), keystore, password, production, devices);
    }

    public static PushedNotifications payload(Payload payload, Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        return Push.sendPayload(payload, keystore, password, production, devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PushedNotifications sendPayload(Payload payload, Object keystore, String password, boolean production, Object devices) throws CommunicationException, KeystoreException {
        PushedNotifications notifications = new PushedNotifications();
        if (payload == null) {
            return notifications;
        }
        PushNotificationManager pushManager = new PushNotificationManager();
        try {
            AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl(keystore, password, production);
            pushManager.initializeConnection(server);
            List<Device> deviceList = Devices.asDevices(devices);
            notifications.setMaxRetained(deviceList.size());
            for (Device device : deviceList) {
                try {
                    BasicDevice.validateTokenFormat(device.getToken());
                    PushedNotification notification = pushManager.sendNotification(device, payload, false);
                    notifications.add(notification);
                }
                catch (InvalidDeviceTokenFormatException e) {
                    notifications.add(new PushedNotification(device, payload, e));
                }
            }
        }
        finally {
            try {
                pushManager.stopConnection();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return notifications;
    }

    public static PushedNotifications payload(Payload payload, Object keystore, String password, boolean production, int numberOfThreads, Object devices) throws Exception {
        if (numberOfThreads <= 0) {
            return Push.sendPayload(payload, keystore, password, production, devices);
        }
        AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl(keystore, password, production);
        List<Device> deviceList = Devices.asDevices(devices);
        NotificationThreads threads = new NotificationThreads((AppleNotificationServer)server, payload, deviceList, numberOfThreads);
        threads.start();
        try {
            threads.waitForAllThreads(true);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        PushedNotifications notifications = threads.getPushedNotifications();
        threads.destroy();
        return notifications;
    }

    public static PushQueue queue(Object keystore, String password, boolean production, int numberOfThreads) throws KeystoreException {
        AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl(keystore, password, production);
        return numberOfThreads <= 1 ? new NotificationThread(server) : new NotificationThreads(server, numberOfThreads);
    }

    public static PushedNotifications payloads(Object keystore, String password, boolean production, Object payloadDevicePairs) throws CommunicationException, KeystoreException {
        return Push.sendPayloads(keystore, password, production, payloadDevicePairs);
    }

    public static PushedNotifications payloads(Object keystore, String password, boolean production, int numberOfThreads, Object payloadDevicePairs) throws Exception {
        if (numberOfThreads <= 0) {
            return Push.sendPayloads(keystore, password, production, payloadDevicePairs);
        }
        AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl(keystore, password, production);
        List<PayloadPerDevice> payloadPerDevicePairs = Devices.asPayloadsPerDevices(payloadDevicePairs);
        NotificationThreads threads = new NotificationThreads((AppleNotificationServer)server, payloadPerDevicePairs, numberOfThreads);
        threads.start();
        try {
            threads.waitForAllThreads(true);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        PushedNotifications notifications = threads.getPushedNotifications();
        threads.destroy();
        return notifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PushedNotifications sendPayloads(Object keystore, String password, boolean production, Object payloadDevicePairs) throws CommunicationException, KeystoreException {
        PushedNotifications notifications = new PushedNotifications();
        if (payloadDevicePairs == null) {
            return notifications;
        }
        PushNotificationManager pushManager = new PushNotificationManager();
        try {
            AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl(keystore, password, production);
            pushManager.initializeConnection(server);
            List<PayloadPerDevice> pairs = Devices.asPayloadsPerDevices(payloadDevicePairs);
            notifications.setMaxRetained(pairs.size());
            for (PayloadPerDevice ppd : pairs) {
                Device device = ppd.getDevice();
                Payload payload = ppd.getPayload();
                try {
                    PushedNotification notification = pushManager.sendNotification(device, payload, false);
                    notifications.add(notification);
                }
                catch (Exception e) {
                    notifications.add(new PushedNotification(device, payload, e));
                }
            }
        }
        finally {
            try {
                pushManager.stopConnection();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return notifications;
    }

    public static List<Device> feedback(Object keystore, String password, boolean production) throws CommunicationException, KeystoreException {
        FeedbackServiceManager feedbackManager = new FeedbackServiceManager();
        AppleFeedbackServerBasicImpl server = new AppleFeedbackServerBasicImpl(keystore, password, production);
        return new ArrayList<Device>(feedbackManager.getDevices(server));
    }
}

