/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.docx4j.XmlUtils;
import org.docx4j.bibliography.CTSources;
import org.docx4j.docProps.coverPageProps.CoverPageProperties;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.io.Load;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCoverPagePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.JaxbSmlPart;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.xmlPackage.Package;
import org.opendope.answers.Answers;
import org.opendope.components.Components;
import org.opendope.conditions.Conditions;
import org.opendope.questions.Questionnaire;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xlsx4j.jaxb.Context;

public class FlatOpcXmlImporter {
    private static Logger log = LoggerFactory.getLogger(FlatOpcXmlImporter.class);
    private HashMap<String, org.docx4j.xmlPackage.Part> parts;
    private ContentTypeManager ctm;
    protected HashMap<String, String> handled = new HashMap();
    private OpcPackage packageResult;

    public FlatOpcXmlImporter(InputStream is) throws JAXBException {
        JAXBContext jc = org.docx4j.jaxb.Context.jcXmlPackage;
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        Package flatOpcXml = null;
        try {
            flatOpcXml = (Package)XmlUtils.unwrap(u.unmarshal(xsr));
        }
        catch (UnmarshalException e) {
            if (e.getMessage() != null && e.getMessage().contains("http://schemas.microsoft.com/office/word/2003/wordml")) {
                throw new IllegalArgumentException("Word 2003 XML is not supported. Use a docx or Flat OPC XML instead, or look at the Word2003XmlConverter proof of concept.");
            }
            throw e;
        }
        this.init(flatOpcXml);
    }

    public FlatOpcXmlImporter(Package flatOpcXml) {
        this.init(flatOpcXml);
    }

    private void init(Package flatOpcXml) {
        this.parts = new HashMap();
        for (org.docx4j.xmlPackage.Part p : flatOpcXml.getPart()) {
            if (log.isDebugEnabled()) {
                log.debug("Adding " + p.getName());
            }
            this.parts.put(p.getName(), p);
        }
    }

    public OpcPackage get() throws Docx4JException {
        this.ctm = new ContentTypeManager();
        this.ctm.addDefaultContentType("rels", "application/vnd.openxmlformats-package.relationships+xml");
        this.ctm.addDefaultContentType("xml", "application/xml");
        RelationshipsPart tmpRp = new RelationshipsPart();
        org.docx4j.xmlPackage.Part part = this.parts.get("/_rels/.rels");
        if (part == null) {
            throw new Docx4JException("Couldn't find pkg rels /_rels/.rels");
        }
        try {
            FlatOpcXmlImporter.populateRelationshipsPart(tmpRp, part.getXmlData().getAny());
        }
        catch (JAXBException e) {
            throw new Docx4JException(e.getMessage(), (Exception)((Object)e));
        }
        Relationship r = tmpRp.getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        String target = r.getTarget();
        if (target.startsWith("/")) {
            log.debug("target " + target + " already starts with '/'.  Word Online docx? ");
        } else {
            target = "/" + target;
        }
        org.docx4j.xmlPackage.Part officeDocument = this.parts.get(target);
        if (officeDocument == null) {
            throw new Docx4JException("Couldn't find part named " + r.getTarget());
        }
        this.packageResult = this.ctm.createPackage(officeDocument.getContentType());
        log.info("Creating " + this.packageResult.getClass().getName());
        String partName = "/_rels/.rels";
        RelationshipsPart rp = this.getRelationshipsPartFromXmlPackage(this.packageResult, partName);
        this.packageResult.setRelationships(rp);
        this.addPartsFromRelationships(this.packageResult, rp);
        Load.registerCustomXmlDataStorageParts(this.packageResult);
        this.packageResult.setNew(false);
        return this.packageResult;
    }

    private RelationshipsPart getRelationshipsPartFromXmlPackage(Base p, String partName) throws Docx4JException {
        RelationshipsPart rp = null;
        try {
            org.docx4j.xmlPackage.Part part = this.parts.get(partName);
            if (part == null) {
                return null;
            }
            rp = p.getRelationshipsPart(true);
            FlatOpcXmlImporter.populateRelationshipsPart(rp, part.getXmlData().getAny());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Docx4JException("Error getting document from XmlPackage:" + partName, e);
        }
        return rp;
    }

    public static RelationshipsPart populateRelationshipsPart(RelationshipsPart rp, Element el) throws InvalidFormatException, JAXBException {
        rp.setRelationships(rp.unmarshal(el));
        return rp;
    }

    private void addPartsFromRelationships(Base source, RelationshipsPart rp) throws Docx4JException {
        OpcPackage pkg = source.getPackage();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.debug("For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget());
            try {
                this.getPart(rp, r);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
    }

    private void getPart(RelationshipsPart rp, Relationship r) throws Docx4JException, InvalidFormatException, URISyntaxException {
        RelationshipsPart rrp;
        Base source = null;
        String resolvedPartUri = null;
        if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
            log.info("Encountered external resource " + r.getTarget() + " of type " + r.getType());
            return;
        }
        source = rp.getSourceP();
        resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
        if (this.handled.get(resolvedPartUri) != null) {
            return;
        }
        String relationshipType = r.getType();
        Part part = this.getRawPart(this.ctm, resolvedPartUri, r);
        rp.loadPart(part, r);
        this.handled.put(resolvedPartUri, resolvedPartUri);
        if (source.setPartShortcut(part, relationshipType)) {
            log.debug("Convenience method established from " + source.getPartName() + " to " + part.getPartName());
        }
        if ((rrp = this.getRelationshipsPart(part)) != null) {
            this.addPartsFromRelationships(part, rrp);
        }
    }

    public RelationshipsPart getRelationshipsPart(Part part) throws Docx4JException, InvalidFormatException {
        String relPart = PartName.getRelationshipsPartName(part.getPartName().getName());
        RelationshipsPart rrp = this.getRelationshipsPartFromXmlPackage(part, relPart);
        if (rrp == null) {
            log.debug("No relationships " + relPart);
            return null;
        }
        part.setRelationships(rrp);
        return rrp;
    }

    public Part getRawPart(ContentTypeManager ctm, String resolvedPartUri, Relationship rel) throws Docx4JException {
        org.docx4j.xmlPackage.Part pkgPart = this.parts.get(resolvedPartUri);
        if (pkgPart == null) {
            log.error("Missing part: " + resolvedPartUri);
            return null;
        }
        return this.getRawPart(ctm, pkgPart, rel);
    }

    private Part getRawPart(ContentTypeManager ctm, org.docx4j.xmlPackage.Part pkgPart, Relationship rel) throws Docx4JException {
        return FlatOpcXmlImporter.getRawPart(ctm, pkgPart, rel, this.packageResult);
    }

    public static Part getRawPart(ContentTypeManager ctm, org.docx4j.xmlPackage.Part pkgPart, Relationship rel, OpcPackage targetPkg) throws Docx4JException {
        Part part;
        block35: {
            part = null;
            try {
                Element el = null;
                try {
                    String contentType = pkgPart.getContentType();
                    log.debug("contentType: " + contentType);
                    if (pkgPart.getXmlData() != null) {
                        el = pkgPart.getXmlData().getAny();
                    }
                    part = ctm.newPartForContentType(contentType, pkgPart.getName(), rel);
                    part.setContentType(new ContentType(contentType));
                    if (targetPkg != null) {
                        part.setPackage(targetPkg);
                    }
                    ctm.addOverrideContentType(new URI(pkgPart.getName()), contentType);
                    if (part instanceof ThemePart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.docx4j.jaxb.Context.jcThemePart);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof DocPropsCorePart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.docx4j.jaxb.Context.jcDocPropsCore);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof DocPropsCustomPart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.docx4j.jaxb.Context.jcDocPropsCustom);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof DocPropsExtendedPart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.docx4j.jaxb.Context.jcDocPropsExtended);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof CustomXmlDataStoragePropertiesPart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.docx4j.jaxb.Context.jcCustomXmlProperties);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part.getClass().getName().equals("org.docx4j.openpackaging.parts.digitalsignature.XmlSignaturePart")) {
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof JaxbPmlPart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.pptx4j.jaxb.Context.jcPML);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof JaxbSmlPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcSML);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof JaxbXmlPart) {
                        ((JaxbXmlPart)part).setJAXBContext(org.docx4j.jaxb.Context.jc);
                        ((JaxbXmlPart)part).unmarshal(el);
                        break block35;
                    }
                    if (part instanceof BinaryPart) {
                        log.debug("Detected BinaryPart " + part.getClass().getName());
                        ((BinaryPart)part).setBinaryData(pkgPart.getBinaryData());
                        break block35;
                    }
                    if (part instanceof CustomXmlDataStoragePart) {
                        try {
                            Unmarshaller u = org.docx4j.jaxb.Context.jc.createUnmarshaller();
                            Object o = u.unmarshal((Node)el);
                            log.debug(o.getClass().getName());
                            PartName name = part.getPartName();
                            if (o instanceof CoverPageProperties) {
                                part = new DocPropsCoverPagePart(name);
                                ((DocPropsCoverPagePart)part).setJaxbElement((CoverPageProperties)o);
                                break block35;
                            }
                            if (o instanceof Conditions) {
                                part = new ConditionsPart(name);
                                ((ConditionsPart)part).setJaxbElement((Conditions)o);
                                break block35;
                            }
                            if (o instanceof Xpaths) {
                                part = new XPathsPart(name);
                                ((XPathsPart)part).setJaxbElement((Xpaths)o);
                                break block35;
                            }
                            if (o instanceof Questionnaire) {
                                part = new QuestionsPart(name);
                                ((QuestionsPart)part).setJaxbElement((Questionnaire)o);
                                break block35;
                            }
                            if (o instanceof Answers) {
                                part = new StandardisedAnswersPart(name);
                                ((StandardisedAnswersPart)part).setJaxbElement((Answers)o);
                                break block35;
                            }
                            if (o instanceof Components) {
                                part = new ComponentsPart(name);
                                ((ComponentsPart)part).setJaxbElement((Components)o);
                                break block35;
                            }
                            if (o instanceof JAXBElement && XmlUtils.unwrap(o) instanceof CTSources) {
                                part = new BibliographyPart(name);
                                ((BibliographyPart)part).setJaxbElement((JAXBElement)o);
                                break block35;
                            }
                            log.warn("No known part after all for CustomXmlPart " + o.getClass().getName());
                            CustomXmlDataStorage data = Load.getCustomXmlDataStorageClass().factory();
                            Document doc = XmlUtils.getNewDocumentBuilder().newDocument();
                            Node copy = doc.importNode(el, true);
                            try {
                                copy.getAttributes().removeNamedItemNS("http://www.w3.org/2000/xmlns/", "xml");
                            }
                            catch (DOMException dOMException) {
                                // empty catch block
                            }
                            doc.appendChild(copy);
                            data.setDocument(doc);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        catch (UnmarshalException ue) {
                            CustomXmlDataStorage data = Load.getCustomXmlDataStorageClass().factory();
                            Document doc = XmlUtils.getNewDocumentBuilder().newDocument();
                            Node copy = doc.importNode(el, true);
                            try {
                                copy.getAttributes().removeNamedItemNS("http://www.w3.org/2000/xmlns/", "xml");
                            }
                            catch (DOMException dOMException) {
                                // empty catch block
                            }
                            doc.appendChild(copy);
                            data.setDocument(doc);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        break block35;
                    }
                    if (part instanceof XmlPart) {
                        Document doc = XmlUtils.getNewDocumentBuilder().newDocument();
                        Node copy = doc.importNode(el, true);
                        try {
                            copy.getAttributes().removeNamedItemNS("http://www.w3.org/2000/xmlns/", "xml");
                        }
                        catch (DOMException dOMException) {
                            // empty catch block
                        }
                        doc.appendChild(copy);
                        ((XmlPart)part).setDocument(doc);
                        break block35;
                    }
                    log.error("No suitable part found for: " + pkgPart.getName());
                    part = null;
                }
                catch (IllegalArgumentException e) {
                    if (el != null) {
                        log.error(e.getMessage());
                        log.error(XmlUtils.w3CDomNodeToString(el));
                    }
                    throw e;
                }
                catch (PartUnrecognisedException e) {
                    log.error("Part unrecognised: " + pkgPart.getName());
                    part = new BinaryPart(new PartName(pkgPart.getName()));
                    ((BinaryPart)part).setBinaryData(pkgPart.getBinaryData());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Docx4JException("Failed to getPart", ex);
            }
        }
        return part;
    }
}

