/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.File;
import java.io.IOException;
import org.docx4j.Docx4jProperties;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFontPart
extends BinaryPart {
    private static Logger log = LoggerFactory.getLogger(AbstractFontPart.class);
    private File f;
    private static final String DOCX4J_USER_DIR = ".docx4all";
    private static final String TEMPORARY_FONT_DIR = "temporary embedded fonts";
    private static File tmpFontDir = null;

    public abstract PhysicalFont extract(String var1, String var2, String var3, String var4);

    public static File getTmpFontDir() {
        return tmpFontDir;
    }

    public static String getTemporaryEmbeddedFontsDir() {
        if (AbstractFontPart.getTmpFontDir() == null) {
            throw new RuntimeException("No dir configured for temp fonts!  Either set system property user.home to a writable dir, or configure docx4j property 'docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart.tmpFontDir'");
        }
        try {
            return AbstractFontPart.getTmpFontDir().getCanonicalPath();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static File getUserHome() {
        File userDir;
        String s = System.getProperty("user.home");
        if (s != null && (userDir = new File(s)).exists()) {
            return userDir;
        }
        return null;
    }

    public AbstractFontPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    protected static void deleteEmbeddedFontTempFiles(String filenamePrefix) {
        int count;
        if (log.isDebugEnabled()) {
            log.debug("deleting with prefix " + filenamePrefix);
        }
        for (File f : AbstractFontPart.getTmpFontDir().listFiles()) {
            if (!f.getName().startsWith(filenamePrefix)) continue;
            f.delete();
        }
        if (log.isWarnEnabled() && (count = AbstractFontPart.getTmpFontDir().listFiles().length) > 0) {
            try {
                log.warn(count + " files remain in " + AbstractFontPart.getTmpFontDir().getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.getF() != null) {
                log.debug("Deleting  " + this.getF().getName());
                this.getF().delete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }

    public File getF() {
        return this.f;
    }

    public void setF(File f) {
        this.f = f;
    }

    static {
        String tmpFontDirPath = Docx4jProperties.getProperty("docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart.tmpFontDir");
        if (tmpFontDirPath == null) {
            File userHome = AbstractFontPart.getUserHome();
            if (userHome == null) {
                log.warn("No home dir found; consider setting property 'docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart.tmpFontDir'");
            } else {
                File docx4jUserDir = new File(userHome, DOCX4J_USER_DIR);
                docx4jUserDir.mkdir();
                tmpFontDir = new File(docx4jUserDir, TEMPORARY_FONT_DIR);
                AbstractFontPart.getTmpFontDir().mkdir();
            }
        } else {
            tmpFontDir = new File(tmpFontDirPath);
            if (!AbstractFontPart.getTmpFontDir().exists()) {
                log.info(tmpFontDirPath + " does not exist. Attempting to create..");
                AbstractFontPart.getTmpFontDir().mkdir();
            } else if (!AbstractFontPart.getTmpFontDir().isDirectory()) {
                log.info(tmpFontDirPath + " exists, but is not a directory!");
            }
        }
    }
}

