/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.DrawingML;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.dml.diagram.CTDiagramDefinition;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDataPart;
import org.docx4j.openpackaging.parts.DrawingML.JaxbDmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class DiagramLayoutPart
extends JaxbDmlPart<CTDiagramDefinition> {
    private static Logger log = LoggerFactory.getLogger(DiagramLayoutPart.class);
    static Templates xsltGenerateIds;

    public DiagramLayoutPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DiagramLayoutPart() throws InvalidFormatException {
        super(new PartName("/word/diagrams/layout1.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramLayout");
    }

    public static Templates generateLayoutTreeXSLT(CTDiagramDefinition pictureLayout) throws Exception {
        log.debug(XmlUtils.marshaltoString((Object)pictureLayout, true));
        StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/openpackaging/parts/DrawingML/DiagramLayoutMeta.xslt"));
        Templates xsltMeta = XmlUtils.getTransformerTemplate(xsltSource);
        Document source = XmlUtils.marshaltoW3CDomDocument(pictureLayout, Context.jc);
        ByteArrayOutputStream intermediate = new ByteArrayOutputStream();
        StreamResult intermediateResult = new StreamResult(intermediate);
        XmlUtils.transform(source, xsltMeta, null, (Result)intermediateResult);
        String tmpXslStr = intermediate.toString("UTF-8");
        log.debug(tmpXslStr);
        return XmlUtils.getTransformerTemplate(new StreamSource(new StringReader(tmpXslStr)));
    }

    public static String generateLayoutTree(Source myList, Templates layoutTreeCreatorXslt) throws Exception {
        log.info("Generating layout tree..");
        ByteArrayOutputStream layoutBAOS = new ByteArrayOutputStream();
        StreamResult layoutResult = new StreamResult(layoutBAOS);
        XmlUtils.transform(myList, layoutTreeCreatorXslt, null, (Result)layoutResult);
        ByteArrayOutputStream layoutBAOS2 = new ByteArrayOutputStream();
        StreamResult layoutResult2 = new StreamResult(layoutBAOS2);
        XmlUtils.transform(new StreamSource(new StringReader(layoutBAOS.toString("UTF-8"))), xsltGenerateIds, null, (Result)layoutResult2);
        return layoutBAOS2.toString("UTF-8");
    }

    public static void main(String[] args) throws Exception {
        Templates xsltLT2DD;
        Document doc = XmlUtils.getNewDocumentBuilder().parse(new File(System.getProperty("user.dir") + "/SmartArt/12hi.xml"));
        DOMSource myList = new DOMSource(doc);
        String layoutSrcFilePath = System.getProperty("user.dir") + "/sample-docs/glox/extracted/chevron1.glox";
        OpcPackage opcPackage = OpcPackage.load(new File(layoutSrcFilePath));
        JaxbXmlPart thisPart = null;
        for (Map.Entry<PartName, Part> entry : opcPackage.getParts().getParts().entrySet()) {
            if (!entry.getValue().getContentType().equals("application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml")) continue;
            thisPart = (DiagramLayoutPart)entry.getValue();
            break;
        }
        if (thisPart == null) {
            System.out.println("No SmartArt found in " + layoutSrcFilePath);
            return;
        }
        System.out.println("Generating xslt..");
        Templates xslLayoutNodeTree = DiagramLayoutPart.generateLayoutTreeXSLT((CTDiagramDefinition)thisPart.getJaxbElement());
        String tmpXslStr = DiagramLayoutPart.generateLayoutTree(myList, xslLayoutNodeTree);
        System.out.println(tmpXslStr);
        System.out.println("Creating DiagramData part..");
        try {
            xsltLT2DD = XmlUtils.getTransformerTemplate(new StreamSource(ResourceUtils.getResource("org/docx4j/openpackaging/parts/DrawingML/DiagramLayoutTree4pictureOrgChart2DiagramData.xslt")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        JAXBResult result = new JAXBResult(Context.jc);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("list", doc);
        XmlUtils.transform(new StreamSource(new StringReader(tmpXslStr)), xsltLT2DD, settings, (Result)result);
        Object ddJaxb = result.getResult();
        DiagramDataPart.setFriendlyIds(XmlUtils.unwrap(ddJaxb));
        System.out.println(XmlUtils.marshaltoString(ddJaxb, false));
    }

    static {
        try {
            xsltGenerateIds = XmlUtils.getTransformerTemplate(new StreamSource(ResourceUtils.getResource("org/docx4j/openpackaging/parts/DrawingML/GenerateIds.xslt")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

