/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.fonts.CMapSegment;
import org.docx4j.fonts.fop.fonts.EmbeddingMode;
import org.docx4j.fonts.fop.fonts.FontDescriptor;
import org.docx4j.fonts.fop.fonts.FontType;
import org.docx4j.fonts.fop.fonts.FontUtil;
import org.docx4j.fonts.fop.fonts.MutableFont;
import org.docx4j.fonts.fop.fonts.NamedCharacter;
import org.docx4j.fonts.fop.fonts.SimpleSingleByteEncoding;
import org.docx4j.fonts.fop.fonts.SingleByteFont;
import org.docx4j.fonts.fop.fonts.Typeface;

public abstract class CustomFont
extends Typeface
implements FontDescriptor,
MutableFont {
    private static final int DEFAULT_LINE_THICKNESS = 50;
    private URI fontFileURI;
    private String fontName;
    private String fullName;
    private Set<String> familyNames;
    private String fontSubName;
    private URI embedFileURI;
    private String embedResourceName;
    private final InternalResourceResolver resourceResolver;
    private EmbeddingMode embeddingMode = EmbeddingMode.AUTO;
    private int capHeight;
    private int xHeight;
    private int ascender;
    private int descender;
    private int[] fontBBox = new int[]{0, 0, 0, 0};
    private int flags = 4;
    private int weight;
    private int stemV;
    private int italicAngle;
    private int missingWidth;
    private FontType fontType = FontType.TYPE1;
    private int firstChar;
    private int lastChar = 255;
    private int underlinePosition;
    private int underlineThickness;
    private int strikeoutPosition;
    private int strikeoutThickness;
    private Map<Integer, Map<Integer, Integer>> kerning;
    private boolean useKerning = true;
    protected List<CMapSegment> cmap = new ArrayList<CMapSegment>();
    private boolean useAdvanced = true;
    private boolean simulateStyle;
    protected List<SimpleSingleByteEncoding> additionalEncodings;
    protected Map<Character, SingleByteFont.UnencodedCharacter> unencodedCharacters;

    public CustomFont(InternalResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public URI getFontURI() {
        return this.fontFileURI;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public Set<String> getFamilyNames() {
        return Collections.unmodifiableSet(this.familyNames);
    }

    public String getStrippedFontName() {
        return FontUtil.stripWhiteSpace(this.getFontName());
    }

    public String getFontSubName() {
        return this.fontSubName;
    }

    public URI getEmbedFileURI() {
        return this.embedFileURI;
    }

    public EmbeddingMode getEmbeddingMode() {
        return this.embeddingMode;
    }

    public InputStream getInputStream() throws IOException {
        return this.resourceResolver.getResource(this.embedFileURI);
    }

    public String getEmbedResourceName() {
        return this.embedResourceName;
    }

    @Override
    public int getAscender() {
        return this.ascender;
    }

    @Override
    public int getDescender() {
        return this.descender;
    }

    @Override
    public int getCapHeight() {
        return this.capHeight;
    }

    @Override
    public int getAscender(int size) {
        return size * this.ascender;
    }

    @Override
    public int getDescender(int size) {
        return size * this.descender;
    }

    @Override
    public int getCapHeight(int size) {
        return size * this.capHeight;
    }

    @Override
    public int getXHeight(int size) {
        return size * this.xHeight;
    }

    @Override
    public int[] getFontBBox() {
        return this.fontBBox;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isSymbolicFont() {
        return (this.getFlags() & 4) != 0 || "ZapfDingbatsEncoding".equals(this.getEncodingName());
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int getStemV() {
        return this.stemV;
    }

    @Override
    public int getItalicAngle() {
        return this.italicAngle;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    @Override
    public FontType getFontType() {
        return this.fontType;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public boolean isKerningEnabled() {
        return this.useKerning;
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.isKerningEnabled() && this.kerning != null && !this.kerning.isEmpty();
    }

    @Override
    public final Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        if (this.hasKerningInfo()) {
            return this.kerning;
        }
        return Collections.emptyMap();
    }

    public boolean isAdvancedEnabled() {
        return this.useAdvanced;
    }

    @Override
    public void setFontURI(URI uri) {
        this.fontFileURI = uri;
    }

    @Override
    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public void setFullName(String name) {
        this.fullName = name;
    }

    @Override
    public void setFamilyNames(Set<String> names) {
        this.familyNames = new HashSet<String>(names);
    }

    public void setFontSubFamilyName(String subFamilyName) {
        this.fontSubName = subFamilyName;
    }

    @Override
    public void setEmbedURI(URI path) {
        this.embedFileURI = path;
    }

    @Override
    public void setEmbedResourceName(String name) {
        this.embedResourceName = name;
    }

    @Override
    public void setEmbeddingMode(EmbeddingMode embeddingMode) {
        this.embeddingMode = embeddingMode;
    }

    @Override
    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
    }

    public void setXHeight(int xHeight) {
        this.xHeight = xHeight;
    }

    @Override
    public void setAscender(int ascender) {
        this.ascender = ascender;
    }

    @Override
    public void setDescender(int descender) {
        this.descender = descender;
    }

    @Override
    public void setFontBBox(int[] bbox) {
        this.fontBBox = bbox;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setWeight(int weight) {
        weight = weight / 100 * 100;
        weight = Math.max(100, weight);
        this.weight = weight = Math.min(900, weight);
    }

    @Override
    public void setStemV(int stemV) {
        this.stemV = stemV;
    }

    @Override
    public void setItalicAngle(int italicAngle) {
        this.italicAngle = italicAngle;
    }

    @Override
    public void setMissingWidth(int width) {
        this.missingWidth = width;
    }

    @Override
    public void setFontType(FontType fontType) {
        this.fontType = fontType;
    }

    @Override
    public void setFirstChar(int index) {
        this.firstChar = index;
    }

    @Override
    public void setLastChar(int index) {
        this.lastChar = index;
    }

    @Override
    public void setKerningEnabled(boolean enabled) {
        this.useKerning = enabled;
    }

    @Override
    public void setAdvancedEnabled(boolean enabled) {
        this.useAdvanced = enabled;
    }

    public void setSimulateStyle(boolean enabled) {
        this.simulateStyle = enabled;
    }

    public boolean getSimulateStyle() {
        return this.simulateStyle;
    }

    @Override
    public void putKerningEntry(Integer key, Map<Integer, Integer> value) {
        if (this.kerning == null) {
            this.kerning = new HashMap<Integer, Map<Integer, Integer>>();
        }
        this.kerning.put(key, value);
    }

    public void replaceKerningMap(Map<Integer, Map<Integer, Integer>> kerningMap) {
        this.kerning = kerningMap == null ? Collections.emptyMap() : kerningMap;
    }

    public void setCMap(CMapSegment[] cmap) {
        this.cmap.clear();
        Collections.addAll(this.cmap, cmap);
    }

    public CMapSegment[] getCMap() {
        return this.cmap.toArray(new CMapSegment[this.cmap.size()]);
    }

    @Override
    public int getUnderlinePosition(int size) {
        return this.underlinePosition == 0 ? this.getDescender(size) / 2 : size * this.underlinePosition;
    }

    public void setUnderlinePosition(int underlinePosition) {
        this.underlinePosition = underlinePosition;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return size * (this.underlineThickness == 0 ? 50 : this.underlineThickness);
    }

    public void setUnderlineThickness(int underlineThickness) {
        this.underlineThickness = underlineThickness;
    }

    @Override
    public int getStrikeoutPosition(int size) {
        return this.strikeoutPosition == 0 ? this.getXHeight(size) / 2 : size * this.strikeoutPosition;
    }

    public void setStrikeoutPosition(int strikeoutPosition) {
        this.strikeoutPosition = strikeoutPosition;
    }

    @Override
    public int getStrikeoutThickness(int size) {
        return this.strikeoutThickness == 0 ? this.getUnderlineThickness(size) : size * this.strikeoutThickness;
    }

    public void setStrikeoutThickness(int strikeoutThickness) {
        this.strikeoutThickness = strikeoutThickness;
    }

    public abstract Map<Integer, Integer> getUsedGlyphs();

    public abstract char getUnicodeFromGID(int var1);

    public boolean hasAdditionalEncodings() {
        return this.additionalEncodings != null && this.additionalEncodings.size() > 0;
    }

    public int getAdditionalEncodingCount() {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.size();
        }
        return 0;
    }

    public SimpleSingleByteEncoding getAdditionalEncoding(int index) throws IndexOutOfBoundsException {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.get(index);
        }
        throw new IndexOutOfBoundsException("No additional encodings available");
    }

    public void addUnencodedCharacter(NamedCharacter ch, int width, Rectangle bbox) {
        if (this.unencodedCharacters == null) {
            this.unencodedCharacters = new HashMap<Character, SingleByteFont.UnencodedCharacter>();
        }
        if (ch.hasSingleUnicodeValue()) {
            SingleByteFont.UnencodedCharacter uc = new SingleByteFont.UnencodedCharacter(ch, width, bbox);
            this.unencodedCharacters.put(Character.valueOf(ch.getSingleUnicodeValue()), uc);
        }
    }

    protected char mapUnencodedChar(char ch) {
        SingleByteFont.UnencodedCharacter unencoded;
        if (this.unencodedCharacters != null && (unencoded = this.unencodedCharacters.get(Character.valueOf(ch))) != null) {
            if (this.additionalEncodings == null) {
                this.additionalEncodings = new ArrayList<SimpleSingleByteEncoding>();
            }
            SimpleSingleByteEncoding encoding = null;
            int mappedStart = 0;
            int additionalsCount = this.additionalEncodings.size();
            for (int i = 0; i < additionalsCount; ++i) {
                mappedStart = (char)(mappedStart + 256);
                encoding = this.getAdditionalEncoding(i);
                char alt = encoding.mapChar(ch);
                if (alt == '\u0000') continue;
                return (char)(mappedStart + alt);
            }
            if (encoding != null && encoding.isFull()) {
                encoding = null;
            }
            if (encoding == null) {
                encoding = new SimpleSingleByteEncoding(this.getFontName() + "EncodingSupp" + (additionalsCount + 1));
                this.additionalEncodings.add(encoding);
                mappedStart = (char)(mappedStart + 256);
            }
            return (char)(mappedStart + encoding.addCharacter(unencoded.getCharacter()));
        }
        return '\u0000';
    }
}

