/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.apps.io.ResourceResolverFactory;
import org.docx4j.fonts.fop.configuration.Configuration;
import org.docx4j.fonts.fop.configuration.ConfigurationException;
import org.docx4j.fonts.fop.fonts.FontManager;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitutions;
import org.docx4j.fonts.fop.fonts.substitute.FontSubstitutionsConfigurator;
import org.docx4j.fonts.fop.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontManagerConfigurator {
    private static Logger log = LoggerFactory.getLogger(FontManagerConfigurator.class);
    private final Configuration cfg;
    private final URI baseURI;
    private final URI fallbackURI;
    private final ResourceResolver resourceResolver;

    public FontManagerConfigurator(Configuration cfg, URI baseURI, URI fallbackURI, ResourceResolver resourceResolver) {
        this.cfg = cfg;
        this.baseURI = baseURI;
        this.fallbackURI = fallbackURI;
        this.resourceResolver = resourceResolver;
    }

    public void configure(FontManager fontManager, boolean strict) throws FOPException {
        Configuration fontsCfg;
        if (this.cfg.getChild("font-base", false) != null) {
            try {
                URI fontBase = InternalResourceResolver.getBaseURI(this.cfg.getChild("font-base").getValue(null));
                fontManager.setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(this.baseURI.resolve(fontBase), this.resourceResolver));
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(log, use, true);
            }
        } else {
            fontManager.setResourceResolver(ResourceResolverFactory.createInternalResourceResolver(this.fallbackURI, this.resourceResolver));
        }
        if (this.cfg.getChild("use-cache", false) != null) {
            try {
                if (!this.cfg.getChild("use-cache").getValueAsBoolean()) {
                    fontManager.disableFontCache();
                } else if (this.cfg.getChild("cache-file", false) != null) {
                    fontManager.setCacheFile(URI.create(this.cfg.getChild("cache-file").getValue()));
                }
            }
            catch (ConfigurationException mfue) {
                LogUtil.handleException(log, mfue, true);
            }
        }
        if (this.cfg.getChild("base14-kerning", false) != null) {
            try {
                fontManager.setBase14KerningEnabled(this.cfg.getChild("base14-kerning").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, e, true);
            }
        }
        if ((fontsCfg = this.cfg.getChild("fonts", false)) != null) {
            Configuration referencedFontsCfg;
            Configuration substitutionsCfg = fontsCfg.getChild("substitutions", false);
            if (substitutionsCfg != null) {
                FontSubstitutions substitutions = new FontSubstitutions();
                new FontSubstitutionsConfigurator(substitutionsCfg).configure(substitutions);
                fontManager.setFontSubstitutions(substitutions);
            }
            if ((referencedFontsCfg = fontsCfg.getChild("referenced-fonts", false)) != null) {
                FontTriplet.Matcher matcher = FontManagerConfigurator.createFontsMatcher(referencedFontsCfg, strict);
                fontManager.setReferencedFontsMatcher(matcher);
            }
        }
    }

    public static FontTriplet.Matcher createFontsMatcher(Configuration cfg, boolean strict) throws FOPException {
        Configuration[] matches;
        ArrayList<FontFamilyRegExFontTripletMatcher> matcherList = new ArrayList<FontFamilyRegExFontTripletMatcher>();
        for (Configuration matche : matches = cfg.getChildren("match")) {
            try {
                matcherList.add(new FontFamilyRegExFontTripletMatcher(matche.getAttribute("font-family")));
            }
            catch (ConfigurationException ce) {
                LogUtil.handleException(log, ce, strict);
            }
        }
        OrFontTripletMatcher orMatcher = new OrFontTripletMatcher(matcherList.toArray(new FontTriplet.Matcher[matcherList.size()]));
        return orMatcher;
    }

    public static FontTriplet.Matcher createFontsMatcher(List<String> fontFamilies, boolean strict) throws FOPException {
        ArrayList<FontFamilyRegExFontTripletMatcher> matcherList = new ArrayList<FontFamilyRegExFontTripletMatcher>();
        for (String fontFamily : fontFamilies) {
            matcherList.add(new FontFamilyRegExFontTripletMatcher(fontFamily));
        }
        OrFontTripletMatcher orMatcher = new OrFontTripletMatcher(matcherList.toArray(new FontTriplet.Matcher[matcherList.size()]));
        return orMatcher;
    }

    private static class FontFamilyRegExFontTripletMatcher
    implements FontTriplet.Matcher {
        private final Pattern regex;

        public FontFamilyRegExFontTripletMatcher(String regex) {
            this.regex = Pattern.compile(regex);
        }

        @Override
        public boolean matches(FontTriplet triplet) {
            return this.regex.matcher(triplet.getName()).matches();
        }
    }

    private static class OrFontTripletMatcher
    implements FontTriplet.Matcher {
        private final FontTriplet.Matcher[] matchers;

        public OrFontTripletMatcher(FontTriplet.Matcher[] matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean matches(FontTriplet triplet) {
            for (FontTriplet.Matcher matcher : this.matchers) {
                if (!matcher.matches(triplet)) continue;
                return true;
            }
            return false;
        }
    }
}

