/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.services.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.docx4j.services.client.ConversionException;
import org.docx4j.services.client.ConversionRateLimitException;
import org.docx4j.services.client.Converter;
import org.docx4j.services.client.Format;
import org.docx4j.services.client.MyRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterHttp
implements Converter {
    private static Logger log = LoggerFactory.getLogger(ConverterHttp.class);
    private String URL = null;

    public ConverterHttp() {
    }

    public ConverterHttp(String endpointURL) {
        log.debug("starting, with endpointURL: " + endpointURL);
        if (endpointURL != null) {
            this.URL = endpointURL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(File f, Format fromFormat, Format toFormat, OutputStream os) throws IOException, ConversionException {
        this.checkParameters(fromFormat, toFormat);
        try (CloseableHttpClient httpclient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new MyRetryHandler()).build();){
            HttpPost httppost = this.getUrlForFormat(toFormat);
            FileEntity reqEntity = new FileEntity(f, this.map(fromFormat));
            httppost.setEntity((HttpEntity)reqEntity);
            this.execute(httpclient, httppost, os);
            log.debug("..done");
        }
    }

    private HttpPost getUrlForFormat(Format toFormat) {
        if (Format.TOC.equals((Object)toFormat)) {
            return new HttpPost(this.URL + "?format=application/json");
        }
        if (Format.DOCX.equals((Object)toFormat)) {
            return new HttpPost(this.URL + "?format=application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        }
        return new HttpPost(this.URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(InputStream instream, Format fromFormat, Format toFormat, OutputStream os) throws IOException, ConversionException {
        this.checkParameters(fromFormat, toFormat);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = this.getUrlForFormat(toFormat);
            BasicHttpEntity reqEntity = new BasicHttpEntity();
            reqEntity.setContentType(this.map(fromFormat).getMimeType());
            reqEntity.setContent(instream);
            httppost.setEntity((HttpEntity)reqEntity);
            this.execute(httpclient, httppost, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(byte[] bytesIn, Format fromFormat, Format toFormat, OutputStream os) throws IOException, ConversionException {
        this.checkParameters(fromFormat, toFormat);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = this.getUrlForFormat(toFormat);
            ByteArrayEntity reqEntity = new ByteArrayEntity(bytesIn, this.map(fromFormat));
            httppost.setEntity((HttpEntity)reqEntity);
            this.execute(httpclient, httppost, os);
        }
    }

    protected void execute(CloseableHttpClient httpclient, HttpPost httppost, OutputStream os) throws ClientProtocolException, ConversionException {
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httppost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 403) {
                throw new ConversionException("403 license expired?", (HttpResponse)response);
            }
            if (statusCode == 429) {
                throw new ConversionRateLimitException("API rate limit exceeded", (HttpResponse)response);
            }
            if (statusCode != 200) {
                throw new ConversionException(response.getStatusLine().getStatusCode() + "\n" + response);
            }
            HttpEntity resEntity = response.getEntity();
            resEntity.writeTo(os);
        }
        catch (UnknownHostException uhe) {
            throw new ConversionException("\nLooks like you have the wrong host in your endpoint URL '" + this.URL + "'\n", uhe);
        }
        catch (SocketException se) {
            String errorMessage = "";
            if (System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") > -1) {
                errorMessage = "This behaviour may be Windows client OS specific; please look in the server logs or try a Linux client";
            }
            throw new ConversionException(errorMessage, se);
        }
        catch (IOException ioe) {
            throw new ConversionException(ioe.getMessage(), ioe);
        }
        finally {
            try {
                if (response == null) {
                    log.error("\nLooks like your endpoint URL '" + this.URL + "' is wrong\n");
                } else {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private ContentType map(Format f) {
        if (Format.DOCX.equals((Object)f)) {
            return ContentType.create((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        }
        if (Format.DOC.equals((Object)f)) {
            return ContentType.create((String)"application/msword");
        }
        return null;
    }

    private void checkParameters(Format fromFormat, Format toFormat) throws ConversionException {
        if (this.URL == null) {
            throw new ConversionException("Endpoint URL not configured.");
        }
        if (!Format.DOCX.equals((Object)fromFormat) && !Format.DOC.equals((Object)fromFormat)) {
            throw new ConversionException("Conversion from format " + (Object)((Object)fromFormat) + " not supported");
        }
        if (!(Format.PDF.equals((Object)toFormat) || Format.TOC.equals((Object)toFormat) || Format.DOCX.equals((Object)toFormat))) {
            throw new ConversionException("Conversion to format " + (Object)((Object)toFormat) + " not supported");
        }
    }
}

