/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.text.DecimalFormat;
import java.util.Map;
import org.docx4j.fonts.fop.fonts.BFEntry;
import org.docx4j.fonts.fop.fonts.CIDFont;
import org.docx4j.fonts.fop.fonts.CIDFontType;
import org.docx4j.fonts.fop.fonts.CIDSubset;
import org.docx4j.fonts.fop.fonts.FontType;
import org.docx4j.fonts.fop.fonts.FontUtil;

public class MultiByteFont
extends CIDFont {
    private static int uniqueCounter = -1;
    private String ttcName = null;
    private String encoding = "Identity-H";
    private int defaultWidth = 0;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    private String namePrefix = null;
    private CIDSubset subset = new CIDSubset();
    private BFEntry[] bfentries = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiByteFont() {
        this.subset.setupFirstThreeGlyphs();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (++uniqueCounter > 99999 || uniqueCounter < 0) {
                uniqueCounter = 0;
            }
        }
        DecimalFormat counterFormat = new DecimalFormat("00000");
        String cntString = counterFormat.format(uniqueCounter);
        StringBuffer sb = new StringBuffer("E");
        int c = cntString.length();
        for (int i = 0; i < c; ++i) {
            sb.append((char)(cntString.charAt(i) + 17));
        }
        sb.append("+");
        this.namePrefix = sb.toString();
        this.setFontType(FontType.TYPE0);
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public String getRegistry() {
        return "Adobe";
    }

    @Override
    public String getOrdering() {
        return "UCS";
    }

    @Override
    public int getSupplement() {
        return 0;
    }

    @Override
    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public void setCIDType(CIDFontType cidType) {
        this.cidType = cidType;
    }

    private String getPrefixedFontName() {
        return this.namePrefix + FontUtil.stripWhiteSpace(super.getFontName());
    }

    @Override
    public String getEmbedFontName() {
        if (this.isEmbeddable()) {
            return this.getPrefixedFontName();
        }
        return super.getFontName();
    }

    @Override
    public CIDSubset getCIDSubset() {
        return this.subset;
    }

    @Override
    public String getEncodingName() {
        return this.encoding;
    }

    @Override
    public int getWidth(int i, int size) {
        if (this.isEmbeddable()) {
            int glyphIndex = this.subset.getGlyphIndexForSubsetIndex(i);
            return size * this.width[glyphIndex];
        }
        return size * this.width[i];
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    private int findGlyphIndex(char c) {
        char idx = c;
        int retIdx = 0;
        for (int i = 0; i < this.bfentries.length && retIdx == 0; ++i) {
            if (this.bfentries[i].getUnicodeStart() > idx || this.bfentries[i].getUnicodeEnd() < idx) continue;
            retIdx = this.bfentries[i].getGlyphStartIndex() + idx - this.bfentries[i].getUnicodeStart();
        }
        return retIdx;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        int glyphIndex = this.findGlyphIndex(c);
        if (glyphIndex == 0) {
            this.warnMissingGlyph(c);
            glyphIndex = this.findGlyphIndex('#');
        }
        if (this.isEmbeddable()) {
            glyphIndex = this.subset.mapSubsetChar(glyphIndex, c);
        }
        return (char)glyphIndex;
    }

    @Override
    public boolean hasChar(char c) {
        return this.findGlyphIndex(c) != 0;
    }

    public void setBFEntries(BFEntry[] entries) {
        this.bfentries = entries;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public void setTTCName(String ttcName) {
        this.ttcName = ttcName;
    }

    public void setWidthArray(int[] wds) {
        this.width = wds;
    }

    public Map getUsedGlyphs() {
        return this.subset.getSubsetGlyphs();
    }

    public char[] getCharsUsed() {
        if (!this.isEmbeddable()) {
            return null;
        }
        return this.subset.getSubsetChars();
    }
}

