/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRef {
    private static Logger log = LoggerFactory.getLogger(FieldRef.class);
    private FldChar fldCharBegin;
    protected String fldName = null;
    private ContentAccessor parent;
    private R beginRun;
    private boolean seenSeparate = false;
    private Boolean mergeFormat;
    private boolean dirty;
    private boolean lock;
    private Text customFieldData;
    private CTFFData formFieldProperties;
    private R endRun;
    private List<Object> instructions = new ArrayList<Object>();
    private R resultsSlot;

    public FieldRef(FldChar fldCharBegin) {
        this.fldCharBegin = fldCharBegin;
    }

    public String getFldName() {
        Object o = XmlUtils.unwrap(this.instructions.get(0));
        if (o instanceof Text) {
            return FormattingSwitchHelper.getFldSimpleName(((Text)o).getValue());
        }
        log.error("TODO: extract field name from " + o.getClass().getName());
        if (o instanceof FieldRef) {
            FieldRef nested = (FieldRef)o;
            log.error("Nested field " + nested.getFldName());
        } else if (log.isErrorEnabled()) {
            log.error(XmlUtils.marshaltoString(this.instructions.get(0), true, true));
        }
        return null;
    }

    public ContentAccessor getParent() {
        return this.parent;
    }

    public void setParent(ContentAccessor parent) {
        this.parent = parent;
    }

    public R getBeginRun() {
        return this.beginRun;
    }

    public void setBeginRun(R beginRun) {
        this.beginRun = beginRun;
    }

    public boolean haveSeenSeparate() {
        return this.seenSeparate;
    }

    public void setSeenSeparate(boolean seenSeparate) {
        this.seenSeparate = seenSeparate;
    }

    private void processFldBegin() {
        this.formFieldProperties = this.fldCharBegin.getFfData();
        this.customFieldData = this.fldCharBegin.getFldData();
        this.dirty = this.fldCharBegin.isDirty();
        this.lock = this.fldCharBegin.isFldLock();
    }

    public Boolean isMergeFormat() {
        if (this.mergeFormat == null) {
            this.mergeFormat = Boolean.FALSE;
            Object o = XmlUtils.unwrap(this.instructions.get(0));
            if (o instanceof Text) {
                String instr = ((Text)o).getValue();
                if (instr.contains("MERGEFORMAT")) {
                    this.mergeFormat = Boolean.TRUE;
                }
            } else if (log.isErrorEnabled()) {
                log.error("TODO: extract field name from " + o.getClass().getName());
                log.error(XmlUtils.marshaltoString(this.instructions.get(0), true, true));
            }
        }
        return this.mergeFormat;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.fldCharBegin.setDirty(Boolean.valueOf(dirty));
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
        this.fldCharBegin.setFldLock(Boolean.valueOf(lock));
    }

    public Text getCustomFieldData() {
        return this.customFieldData;
    }

    public void setCustomFieldData(Text customFieldData) {
        this.customFieldData = customFieldData;
        this.fldCharBegin.setFldData(customFieldData);
    }

    public CTFFData getFormFieldProperties() {
        return this.formFieldProperties;
    }

    public void setFormFieldProperties(CTFFData formFieldProperties) {
        this.formFieldProperties = formFieldProperties;
        this.fldCharBegin.setFfData(formFieldProperties);
    }

    public R getEndRun() {
        return this.endRun;
    }

    public void setEndRun(R endRun) {
        this.endRun = endRun;
    }

    public List<Object> getInstructions() {
        return this.instructions;
    }

    public R getResultsSlot() {
        return this.resultsSlot;
    }

    public void setResultsSlot(R resultsSlot) {
        this.resultsSlot = resultsSlot;
    }

    public void setResult(String val) {
        this.resultsSlot.getContent().clear();
        StringTokenizer st = new StringTokenizer(val, "\n\r\f");
        boolean firsttoken = true;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (firsttoken) {
                firsttoken = false;
            } else {
                this.resultsSlot.getContent().add(Context.getWmlObjectFactory().createBr());
            }
            Text text = Context.getWmlObjectFactory().createText();
            this.resultsSlot.getContent().add(text);
            if (line.startsWith(" ") || line.endsWith(" ")) {
                text.setSpace("preserve");
            }
            text.setValue(line);
        }
    }
}

