/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.com.microsoft.schemas.office.word.x2010.wordprocessingShape.CTWordprocessingShape;
import org.docx4j.dml.CTGvmlGroupShape;
import org.docx4j.dml.CTGvmlPicture;
import org.docx4j.dml.CTGvmlShape;
import org.docx4j.dml.CTHyperlink;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.dml.diagram.CTDataModel;
import org.docx4j.dml.diagram2008.CTDrawing;
import org.docx4j.dml.picture.Pic;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.mce.AlternateContent;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.EndnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.CompoundTraversalUtilVisitorCallback;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.CTTextbox;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTEndnotes;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTObject;
import org.docx4j.wml.CTTxbxContent;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.Pict;
import org.docx4j.wml.ProofErr;
import org.docx4j.wml.R;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class TraversalUtil {
    private static Logger log = LoggerFactory.getLogger(TraversalUtil.class);
    Callback cb;

    public TraversalUtil(Object parent, Callback cb) {
        this.cb = cb;
        cb.walkJAXBElements(parent);
    }

    static void visitChildrenImpl(Object o) {
    }

    private static List<Object> handleGraphicData(GraphicData graphicData) {
        CTNonVisualDrawingProps picNonVisual;
        ArrayList<Object> tmpArtificialList = new ArrayList<Object>();
        if (graphicData.getPic() != null && (picNonVisual = graphicData.getPic().getNvPicPr().getCNvPr()) != null) {
            TraversalUtil.handleCTNonVisualDrawingProps(picNonVisual, tmpArtificialList);
        }
        if (graphicData.getPic() != null && graphicData.getPic().getBlipFill() != null && graphicData.getPic().getBlipFill().getBlip() != null) {
            log.debug("found CTBlip");
            ArrayList<Object> artificialList = new ArrayList<Object>();
            if (!tmpArtificialList.isEmpty()) {
                artificialList.addAll(tmpArtificialList);
            }
            artificialList.add(graphicData.getPic().getBlipFill().getBlip());
            return artificialList;
        }
        if (graphicData.getWordprocessingShape() != null) {
            CTWordprocessingShape wsp = graphicData.getWordprocessingShape();
            if (wsp.getTxbx() == null) {
                return null;
            }
            return wsp.getTxbx().getTxbxContent().getEGBlockLevelElts();
        }
        return graphicData.getAny();
    }

    private static void handleCTNonVisualDrawingProps(CTNonVisualDrawingProps drawingProps, List<Object> artificialList) {
        CTHyperlink docPrHyperLink;
        if (drawingProps != null && (docPrHyperLink = drawingProps.getHlinkClick()) != null) {
            artificialList.add(docPrHyperLink);
        }
    }

    public static List<Object> getChildrenImpl(Object o) {
        List<Object> handledGraphicData;
        Graphic graphic;
        CTNonVisualDrawingProps drawingProps;
        ArrayList<Object> artificialList;
        if (o == null) {
            log.warn("null passed to getChildrenImpl");
            return null;
        }
        if (o instanceof JAXBElement) {
            log.debug(".. unwrapping");
            o = XmlUtils.unwrap(o);
        }
        log.debug("getting children of " + o.getClass().getName());
        if (o instanceof Text) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Document) {
            ArrayList<Object> artificialList2 = new ArrayList<Object>();
            artificialList2.add(((Document)o).getBody());
            return artificialList2;
        }
        if (o instanceof Br || o instanceof CTBookmark || o instanceof CTMarkupRange) {
            return null;
        }
        if (o instanceof R.Tab || o instanceof R.LastRenderedPageBreak) {
            return null;
        }
        if (o instanceof ContentAccessor) {
            return ((ContentAccessor)o).getContent();
        }
        if (o instanceof SdtElement) {
            if (((SdtElement)o).getSdtContent() != null) {
                return ((SdtElement)o).getSdtContent().getContent();
            }
            log.warn("SdtElement is missing content element");
            return null;
        }
        if (o instanceof Anchor) {
            Anchor anchor = (Anchor)o;
            artificialList = new ArrayList<Object>();
            drawingProps = anchor.getDocPr();
            if (drawingProps != null) {
                TraversalUtil.handleCTNonVisualDrawingProps(drawingProps, artificialList);
            }
            if (anchor.getGraphic() != null) {
                log.debug("found a:graphic");
                graphic = anchor.getGraphic();
                if (graphic.getGraphicData() != null) {
                    handledGraphicData = TraversalUtil.handleGraphicData(graphic.getGraphicData());
                    if (handledGraphicData == null) {
                        if (log.isDebugEnabled()) {
                            log.debug(XmlUtils.marshaltoString(graphic, true, true, Context.jc, "http://schemas.openxmlformats.org/drawingml/2006/main", "graphic", Graphic.class));
                        }
                    } else {
                        artificialList.addAll(handledGraphicData);
                    }
                }
            }
            if (!artificialList.isEmpty()) {
                return artificialList;
            }
        } else if (o instanceof Inline) {
            Inline inline = (Inline)o;
            artificialList = new ArrayList();
            drawingProps = inline.getDocPr();
            if (drawingProps != null) {
                TraversalUtil.handleCTNonVisualDrawingProps(drawingProps, artificialList);
            }
            if (inline.getGraphic() != null) {
                log.debug("found a:graphic");
                graphic = inline.getGraphic();
                if (graphic.getGraphicData() != null) {
                    handledGraphicData = TraversalUtil.handleGraphicData(graphic.getGraphicData());
                    if (handledGraphicData == null) {
                        if (log.isDebugEnabled()) {
                            log.debug(XmlUtils.marshaltoString(graphic, true, true, Context.jc, "http://schemas.openxmlformats.org/drawingml/2006/main", "graphic", Graphic.class));
                        }
                    } else {
                        artificialList.addAll(handledGraphicData);
                    }
                }
            }
            if (!artificialList.isEmpty()) {
                return artificialList;
            }
        } else {
            if (o instanceof Pict) {
                return ((Pict)o).getAnyAndAny();
            }
            if (o instanceof ProofErr) {
                return null;
            }
            if (o instanceof Pic) {
                Pic dmlPic = (Pic)o;
                if (dmlPic.getBlipFill() != null && dmlPic.getBlipFill().getBlip() != null) {
                    log.debug("found DML Blip");
                    ArrayList<Object> artificialList3 = new ArrayList<Object>();
                    artificialList3.add(dmlPic.getBlipFill().getBlip());
                    return artificialList3;
                }
                return null;
            }
            if (o instanceof CTGvmlPicture) {
                CTGvmlPicture dmlPic = (CTGvmlPicture)o;
                if (dmlPic.getBlipFill() != null && dmlPic.getBlipFill().getBlip() != null) {
                    log.debug("found DML Blip");
                    ArrayList<Object> artificialList4 = new ArrayList<Object>();
                    artificialList4.add(dmlPic.getBlipFill().getBlip());
                    return artificialList4;
                }
                return null;
            }
            if (o instanceof CTShape) {
                ArrayList<Object> artificialList5 = new ArrayList<Object>();
                for (JAXBElement j : ((CTShape)o).getPathOrFormulasOrHandles()) {
                    artificialList5.add(j);
                }
                return artificialList5;
            }
            if (o instanceof CTDataModel) {
                CTDataModel dataModel = (CTDataModel)o;
                ArrayList<Object> artificialList6 = new ArrayList<Object>();
                artificialList6.addAll(dataModel.getPtLst().getPt());
                artificialList6.addAll(dataModel.getCxnLst().getCxn());
                return artificialList6;
            }
            if (o instanceof CTDrawing) {
                return ((CTDrawing)o).getSpTree().getSpOrGrpSp();
            }
            if (o instanceof CTTextbox) {
                CTTextbox textBox = (CTTextbox)o;
                if (textBox.getTxbxContent() == null) {
                    return null;
                }
                return textBox.getTxbxContent().getEGBlockLevelElts();
            }
            if (o instanceof CTObject) {
                CTObject ctObject = (CTObject)o;
                ArrayList<Object> artificialList7 = new ArrayList<Object>();
                artificialList7.addAll(ctObject.getAnyAndAny());
                if (ctObject.getControl() != null) {
                    artificialList7.add(ctObject.getControl());
                }
                return artificialList7;
            }
            if (o instanceof CTGvmlGroupShape) {
                return ((CTGvmlGroupShape)o).getTxSpOrSpOrCxnSp();
            }
            if (o instanceof CTGvmlShape) {
                CTGvmlShape sp = (CTGvmlShape)o;
                if (sp != null && sp.getTxSp() != null && sp.getTxSp().getTxBody() != null) {
                    ArrayList<Object> artificialList8 = new ArrayList<Object>();
                    artificialList8.addAll(sp.getTxSp().getTxBody().getP());
                    return artificialList8;
                }
                return null;
            }
            if (o instanceof FldChar) {
                FldChar fldChar = (FldChar)o;
                ArrayList<Object> artificialList9 = new ArrayList<Object>();
                artificialList9.add(fldChar.getFldCharType());
                if (fldChar.getFfData() != null) {
                    artificialList9.add(fldChar.getFfData());
                }
                if (fldChar.getFldData() != null) {
                    artificialList9.add(fldChar.getFldData());
                }
                if (fldChar.getNumberingChange() != null) {
                    artificialList9.add(fldChar.getNumberingChange());
                }
                return artificialList9;
            }
            if (o instanceof AlternateContent) {
                AlternateContent ac = (AlternateContent)o;
                ArrayList<Object> artificialList10 = new ArrayList<Object>();
                artificialList10.addAll(ac.getChoice());
                artificialList10.add(ac.getFallback());
                return artificialList10;
            }
        }
        log.debug(o.getClass().getName() + " .. looking for method which returns list ");
        try {
            Method[] methods = o.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getReturnType().getName().equals("java.util.List")) continue;
                return (List)m.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug(".. no list member");
        return null;
    }

    public static void replaceChildren(Object o, List<Object> newChildren) {
        if (o instanceof ContentAccessor) {
            ((ContentAccessor)o).getContent().clear();
            ((ContentAccessor)o).getContent().addAll(newChildren);
        } else if (o instanceof List) {
            log.debug("replaceChildren invoked on list object");
            ((List)o).clear();
            ((List)o).addAll(newChildren);
        } else if (o instanceof SdtElement) {
            ((SdtElement)o).getSdtContent().getContent().clear();
            ((SdtElement)o).getSdtContent().getContent().addAll(newChildren);
        } else if (o instanceof CTTxbxContent) {
            ((CTTxbxContent)o).getEGBlockLevelElts().clear();
            ((CTTxbxContent)o).getEGBlockLevelElts().addAll(newChildren);
        } else {
            log.info("Don't know how to replaceChildren in " + o.getClass().getName());
            if (o instanceof Node) {
                log.warn(" IGNORED " + ((Node)o).getNodeName());
            }
        }
    }

    public static void visit(WordprocessingMLPackage wmlPackage, boolean bodyOnly, TraversalUtilVisitor visitor) {
        if (visitor != null) {
            TraversalUtil.visit(wmlPackage, bodyOnly, new SingleTraversalUtilVisitorCallback(visitor));
        }
    }

    public static void visit(Object parent, TraversalUtilVisitor visitor) {
        if (visitor != null) {
            TraversalUtil.visit(parent, new SingleTraversalUtilVisitorCallback(visitor));
        }
    }

    public static void visit(WordprocessingMLPackage wmlPackage, boolean bodyOnly, List<TraversalUtilVisitor> visitorList) {
        Object callback = null;
        if (visitorList != null && !visitorList.isEmpty()) {
            if (visitorList.size() > 1) {
                TraversalUtil.visit(wmlPackage, bodyOnly, new CompoundTraversalUtilVisitorCallback(visitorList));
            } else {
                TraversalUtil.visit(wmlPackage, bodyOnly, visitorList.get(0));
            }
        }
    }

    public static void visit(Object parent, List<TraversalUtilVisitor> visitorList) {
        Object callback = null;
        if (visitorList != null && !visitorList.isEmpty()) {
            if (visitorList.size() > 1) {
                TraversalUtil.visit(parent, new CompoundTraversalUtilVisitorCallback(visitorList));
            } else {
                TraversalUtil.visit(parent, visitorList.get(0));
            }
        }
    }

    public static void visit(Object parent, Callback callback) {
        if (parent != null && callback != null) {
            callback.walkJAXBElements(parent);
        }
    }

    public static void visit(WordprocessingMLPackage wmlPackage, boolean bodyOnly, Callback callback) {
        MainDocumentPart mainDocument = null;
        RelationshipsPart relPart = null;
        List relList = null;
        ArrayList elementList = null;
        if (wmlPackage != null && callback != null) {
            mainDocument = wmlPackage.getMainDocumentPart();
            callback.walkJAXBElements(((Document)mainDocument.getJaxbElement()).getBody());
            if (!bodyOnly) {
                relPart = mainDocument.getRelationshipsPart();
                relList = relPart.getRelationships().getRelationship();
                for (Relationship rs : relList) {
                    elementList = null;
                    if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header".equals(rs.getType())) {
                        elementList = ((Hdr)((HeaderPart)relPart.getPart(rs)).getJaxbElement()).getContent();
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer".equals(rs.getType())) {
                        elementList = ((Ftr)((FooterPart)relPart.getPart(rs)).getJaxbElement()).getContent();
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes".equals(rs.getType())) {
                        elementList = new ArrayList();
                        elementList.addAll(((CTEndnotes)((EndnotesPart)relPart.getPart(rs)).getJaxbElement()).getEndnote());
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes".equals(rs.getType())) {
                        elementList = new ArrayList();
                        elementList.addAll(((CTFootnotes)((FootnotesPart)relPart.getPart(rs)).getJaxbElement()).getFootnote());
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments".equals(rs.getType())) {
                        elementList = new ArrayList();
                        for (Comments.Comment comment : ((Comments)((CommentsPart)relPart.getPart(rs)).getJaxbElement()).getComment()) {
                            elementList.addAll(comment.getEGBlockLevelElts());
                        }
                    }
                    if (elementList == null || elementList.isEmpty()) continue;
                    log.debug("Processing target: " + rs.getTarget() + ", type: " + rs.getType());
                    callback.walkJAXBElements(elementList);
                }
            }
        }
    }

    public static abstract class CallbackImpl
    implements Callback {
        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    Object o2;
                    if (o instanceof JAXBElement) {
                        o2 = ((JAXBElement)o).getValue();
                        if (o2 instanceof Child) {
                            if (parent instanceof List) {
                                if (log.isDebugEnabled()) {
                                    if (((Child)o2).getParent() == null) {
                                        log.debug("Unknown parent for " + o2.getClass().getName());
                                    } else {
                                        log.debug("Parent of " + o2.getClass().getName() + " is currently " + ((Child)o2).getParent().getClass().getName());
                                    }
                                }
                            } else if (parent != ((Child)o2).getParent()) {
                                if (((Child)o2).getParent() == null) {
                                    if (log.isWarnEnabled()) {
                                        log.warn("Unknown parent for " + o2.getClass().getName());
                                    }
                                    ((Child)o2).setParent(parent);
                                } else if (log.isWarnEnabled()) {
                                    log.warn("Parent of " + o2.getClass().getName() + " is currently " + ((Child)o2).getParent().getClass().getName() + " not " + parent.getClass().getName());
                                }
                                if (log.isInfoEnabled()) {
                                    log.info("setting to  " + parent.getClass().getName());
                                }
                            }
                        }
                    } else {
                        o2 = o;
                        if (log.isDebugEnabled()) {
                            if (o2 instanceof Child) {
                                if (((Child)o2).getParent() == null) {
                                    log.debug("Unknown parent for " + o2.getClass().getName());
                                } else if (parent != ((Child)o2).getParent()) {
                                    log.debug("Parent of " + o2.getClass().getName() + " is currently " + ((Child)o2).getParent().getClass().getName() + " not " + parent.getClass().getName());
                                }
                            } else {
                                log.info(o2.getClass().getName() + " not an instanceof Child!");
                            }
                        }
                    }
                    this.apply(o2);
                    if (!this.shouldTraverse(o2)) continue;
                    this.walkJAXBElements(o2);
                }
            }
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public abstract List<Object> apply(Object var1);

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }
    }

    public static interface Callback {
        public void walkJAXBElements(Object var1);

        public List<Object> getChildren(Object var1);

        public List<Object> apply(Object var1);

        public boolean shouldTraverse(Object var1);
    }
}

