/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.docx4j.Docx4jProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    protected static Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    public static InputStream getResourceViaProperty(String propName, String defaultPath) throws IOException {
        String resourcePath = Docx4jProperties.getProperty(propName, defaultPath);
        log.debug(propName + " resolved to " + resourcePath);
        InputStream resourceIS = null;
        try {
            resourceIS = ResourceUtils.getResource(resourcePath);
        }
        catch (IOException ioe) {
            log.warn(resourcePath + ": " + ioe.getMessage());
        }
        if (resourceIS == null) {
            log.warn("Property " + propName + " resolved to missing resource " + resourcePath + "; using " + defaultPath);
            return ResourceUtils.getResource(defaultPath);
        }
        return resourceIS;
    }

    public static InputStream getResource(String filename) throws IOException {
        log.debug("Attempting to load: " + filename);
        ClassLoader loader = ResourceUtils.class.getClassLoader();
        URL url = loader.getResource(filename);
        if (url == null && System.getProperty("java.vendor").contains("Android") && (url = loader.getResource("assets/" + filename)) != null) {
            System.out.println("found " + filename + " in assets");
        }
        if (url == null) {
            log.debug("Trying Thread.currentThread().getContextClassLoader()");
            loader = Thread.currentThread().getContextClassLoader();
            url = loader.getResource(filename);
        }
        if (url == null) {
            log.warn("Couldn't get resource: " + filename);
            throw new IOException(filename + " not found via classloader.");
        }
        InputStream is = url.openConnection().getInputStream();
        return is;
    }
}

