/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.structure.DocumentModel;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.ProtectDocument;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.GlossaryDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.Document;
import org.docx4j.wml.Fonts;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Styles;
import org.docx4j.xmlPackage.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class WordprocessingMLPackage
extends OpcPackage {
    protected static Logger log = LoggerFactory.getLogger(WordprocessingMLPackage.class);
    protected MainDocumentPart mainDoc;
    protected GlossaryDocumentPart glossaryDoc;
    private ProtectDocument documentProtectionSettings = new ProtectDocument(this);
    private DocumentModel documentModel;
    private HeaderFooterPolicy headerFooterPolicy;
    static Templates filterTemplate;
    private Mapper fontMapper;

    public ProtectDocument getProtectionSettings() {
        return this.documentProtectionSettings;
    }

    public DocumentModel getDocumentModel() {
        if (this.documentModel == null) {
            this.documentModel = new DocumentModel(this);
        }
        return this.documentModel;
    }

    @Deprecated
    public HeaderFooterPolicy getHeaderFooterPolicy() {
        int last = this.getDocumentModel().getSections().size();
        if (last > 0) {
            return this.getDocumentModel().getSections().get(last - 1).getHeaderFooterPolicy();
        }
        log.error("Unexpected - zero sections?!");
        return null;
    }

    public WordprocessingMLPackage() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
    }

    public WordprocessingMLPackage(ContentTypeManager contentTypeManager) {
        super(contentTypeManager);
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
    }

    public static WordprocessingMLPackage load(File docxFile) throws Docx4JException {
        return (WordprocessingMLPackage)OpcPackage.load(docxFile);
    }

    public static WordprocessingMLPackage load(InputStream is) throws Docx4JException {
        return (WordprocessingMLPackage)OpcPackage.load(is);
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
            this.docPropsCorePart = (DocPropsCorePart)part;
            log.debug("Set shortcut for docPropsCorePart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties")) {
            this.docPropsExtendedPart = (DocPropsExtendedPart)part;
            log.debug("Set shortcut for docPropsExtendedPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties")) {
            this.docPropsCustomPart = (DocPropsCustomPart)part;
            log.debug("Set shortcut for docPropsCustomPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument")) {
            this.mainDoc = (MainDocumentPart)part;
            log.debug("Set shortcut for mainDoc");
            return true;
        }
        return false;
    }

    public MainDocumentPart getMainDocumentPart() {
        return this.mainDoc;
    }

    public void transform(Templates xslt, Map<String, Object> transformParameters) throws Exception {
        FlatOpcXmlCreator worker = new FlatOpcXmlCreator(this);
        Package pkg = worker.get();
        JAXBContext jc = Context.jcXmlPackage;
        Marshaller marshaller = jc.createMarshaller();
        org.w3c.dom.Document doc = XmlUtils.neww3cDomDocument();
        marshaller.marshal((Object)pkg, (Node)doc);
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        JAXBResult result = new JAXBResult(u);
        XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
        Package wmlPackageEl = (Package)XmlUtils.unwrap(result.getResult());
        FlatOpcXmlImporter xmlPackage = new FlatOpcXmlImporter(wmlPackageEl);
        ContentTypeManager ctm = new ContentTypeManager();
        WordprocessingMLPackage tmpPkg = (WordprocessingMLPackage)xmlPackage.get();
        MainDocumentPart tmpDocPart = tmpPkg.getMainDocumentPart();
        StyleDefinitionsPart tmpStylesPart = tmpPkg.getMainDocumentPart().getStyleDefinitionsPart();
        this.getMainDocumentPart().setJaxbElement(((JaxbXmlPart)tmpDocPart).getJaxbElement());
        this.getMainDocumentPart().getStyleDefinitionsPart(true).setJaxbElement((Styles)((JaxbXmlPart)tmpStylesPart).getJaxbElement());
    }

    @Deprecated
    public void filter(FilterSettings filterSettings) throws Exception {
        if (filterTemplate == null) {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/openpackaging/packages/filter.xslt"));
            filterTemplate = XmlUtils.getTransformerTemplate(xsltSource);
        }
        this.transform(filterTemplate, filterSettings.getSettings());
    }

    public void setFontMapper(Mapper fm) throws Exception {
        this.setFontMapper(fm, true);
    }

    public void setFontMapper(Mapper fm, boolean populate) throws Exception {
        log.debug("setFontMapper invoked");
        if (fm == null) {
            throw new IllegalArgumentException("Font Substituter cannot be null.");
        }
        this.fontMapper = fm;
        Fonts fonts = null;
        Set<String> fontsInUse = this.getMainDocumentPart().fontsInUse();
        FontTablePart fontTablePart = this.getMainDocumentPart().getFontTablePart();
        if (fontTablePart == null) {
            log.warn("FontTable missing; creating default part.");
            fontTablePart = new FontTablePart();
            fontTablePart.unmarshalDefaultFonts();
        }
        fontTablePart.processEmbeddings(this.fontMapper);
        fonts = (Fonts)fontTablePart.getJaxbElement();
        if (populate) {
            this.fontMapper.populateFontMappings(fontsInUse, fonts);
        }
    }

    public Mapper getFontMapper() {
        if (this.fontMapper == null) {
            this.fontMapper = new IdentityPlusMapper();
            try {
                this.setFontMapper(this.fontMapper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fontMapper;
    }

    public static WordprocessingMLPackage createPackage() throws InvalidFormatException {
        String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
        log.info("Using paper size: " + papersize);
        String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
        boolean landscape = Boolean.parseBoolean(landscapeString);
        log.info("Landscape orientation: " + landscape);
        return WordprocessingMLPackage.createPackage(PageSizePaper.valueOf(papersize), landscape);
    }

    public static WordprocessingMLPackage createPackage(PageSizePaper sz, boolean landscape) throws InvalidFormatException {
        WordprocessingMLPackage wmlPack = new WordprocessingMLPackage();
        MainDocumentPart wordDocumentPart = new MainDocumentPart();
        ObjectFactory factory = Context.getWmlObjectFactory();
        Body body = factory.createBody();
        Document wmlDocumentEl = factory.createDocument();
        wmlDocumentEl.setBody(body);
        PageDimensions page = new PageDimensions();
        page.setPgSize(sz, landscape);
        SectPr sectPr = factory.createSectPr();
        body.setSectPr(sectPr);
        sectPr.setPgSz(page.getPgSz());
        sectPr.setPgMar(page.getPgMar());
        wordDocumentPart.setJaxbElement(wmlDocumentEl);
        wmlPack.addTargetPart(wordDocumentPart);
        StyleDefinitionsPart stylesPart = new StyleDefinitionsPart();
        try {
            stylesPart.unmarshalDefaultStyles();
            wordDocumentPart.addTargetPart(stylesPart);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        DocPropsCorePart core = new DocPropsCorePart();
        org.docx4j.docProps.core.ObjectFactory coreFactory = new org.docx4j.docProps.core.ObjectFactory();
        core.setJaxbElement(coreFactory.createCoreProperties());
        wmlPack.addTargetPart(core);
        DocPropsExtendedPart app = new DocPropsExtendedPart();
        org.docx4j.docProps.extended.ObjectFactory extFactory = new org.docx4j.docProps.extended.ObjectFactory();
        app.setJaxbElement(extFactory.createProperties());
        wmlPack.addTargetPart(app);
        DocumentSettingsPart dsp = new DocumentSettingsPart();
        wmlPack.getMainDocumentPart().addTargetPart(dsp);
        dsp.setJaxbElement(new CTSettings());
        dsp.setOverrideTableStyleFontSizeAndJustification(true);
        return wmlPack;
    }

    public void attachTemplate(String templatePath) {
        this.getMainDocumentPart().attachTemplate(templatePath);
    }

    protected void finalize() throws Throwable {
        try {
            FontTablePart ftp = this.getMainDocumentPart().getFontTablePart();
            if (ftp != null) {
                ftp.deleteEmbeddedFontTempFiles();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mainDoc = null;
        this.glossaryDoc = null;
        this.documentProtectionSettings = new ProtectDocument(this);
        this.documentModel = null;
        this.headerFooterPolicy = null;
        this.fontMapper = null;
        log.info("reset complete");
    }

    public static class FilterSettings {
        Boolean removeProofErrors = Boolean.FALSE;
        Boolean removeContentControls = Boolean.FALSE;
        Boolean removeRsids = Boolean.FALSE;
        Boolean tidyForDocx4all = Boolean.FALSE;
        Boolean removeBookmarks = Boolean.FALSE;

        public void setRemoveProofErrors(boolean val) {
            this.removeProofErrors = new Boolean(val);
        }

        public void setRemoveContentControls(boolean val) {
            this.removeContentControls = new Boolean(val);
        }

        public void setRemoveRsids(boolean val) {
            this.removeRsids = new Boolean(val);
        }

        public void setTidyForDocx4all(boolean val) {
            this.tidyForDocx4all = new Boolean(val);
        }

        public void setRemoveBookmarks(boolean val) {
            this.removeBookmarks = new Boolean(val);
        }

        public Map<String, Object> getSettings() {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            settings.put("removeProofErrors", this.removeProofErrors);
            settings.put("removeContentControls", this.removeContentControls);
            settings.put("removeRsids", this.removeRsids);
            settings.put("removeBookmarks", this.removeBookmarks);
            settings.put("tidyForDocx4all", this.tidyForDocx4all);
            return settings;
        }
    }
}

