/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import java.lang.reflect.Method;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.wml.Color;
import org.docx4j.wml.RPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class FontColor
extends AbstractRunProperty {
    protected static Logger log = LoggerFactory.getLogger(FontColor.class);
    public static final String CSS_NAME = "color";
    public static final String FO_NAME = "color";

    @Override
    public String getCssName() {
        return "color";
    }

    public FontColor(Color color) {
        this.setObject(color);
    }

    public FontColor(CSSValue value) {
        short ignored = 1;
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        Color color = Context.getWmlObjectFactory().createColor();
        try {
            float fRed = cssPrimitiveValue.getRGBColorValue().getRed().getFloatValue(ignored);
            float fGreen = cssPrimitiveValue.getRGBColorValue().getGreen().getFloatValue(ignored);
            float fBlue = cssPrimitiveValue.getRGBColorValue().getBlue().getFloatValue(ignored);
            color.setVal(UnitsOfMeasurement.rgbTripleToHex(fRed, fGreen, fBlue));
        }
        catch (UnsupportedOperationException e) {
            try {
                Class<?> xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.FSColorToHexString");
                Method rgbToHexMethod = xhtmlImporterClass.getMethod("rgbToHex", CSSPrimitiveValue.class);
                color.setVal((String)rgbToHexMethod.invoke(null, cssPrimitiveValue));
            }
            catch (Exception e2) {
                log.error("docx4j-XHTMLImport jar not found. Please add this to your classpath.");
                log.error(e2.getMessage(), (Throwable)e2);
                throw e;
            }
        }
        this.setObject(color);
    }

    @Override
    public String getCssProperty() {
        if (((Color)this.getObject()).getVal() != null) {
            return FontColor.composeCss("color", "#" + ((Color)this.getObject()).getVal());
        }
        return "";
    }

    @Override
    public void setXslFO(Element foElement) {
        if (((Color)this.getObject()).getVal() != null) {
            if (((Color)this.getObject()).getVal().equals("auto")) {
                foElement.setAttribute("color", "black");
            } else {
                foElement.setAttribute("color", "#" + ((Color)this.getObject()).getVal());
            }
        }
    }

    @Override
    public void set(RPr rPr) {
        rPr.setColor((Color)this.getObject());
    }

    @Override
    public void set(CTTextCharacterProperties rPr) {
    }
}

