/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.convert.out.svginhtml;

import jakarta.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.model.images.AbstractWordXmlPicture;
import org.docx4j.openpackaging.parts.Part;
import org.pptx4j.convert.out.svginhtml.SvgConversionContext;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Pic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class PictureExporter
extends AbstractWordXmlPicture {
    protected static Logger log = LoggerFactory.getLogger(PictureExporter.class);
    Pic pic = null;
    private final int extentToPixelConversionFactor = 9525;

    public static DocumentFragment createHtmlImg(SvgConversionContext context, NodeIterator wpInline) {
        PictureExporter converter = PictureExporter.createPicture(context, wpInline);
        DocumentFragment df = PictureExporter.getHtmlDocumentFragment(converter);
        CTPoint2D offset = converter.pic.getSpPr().getXfrm().getOff();
        AbstractWordXmlPicture.Dimensions xy = converter.readDimensions(offset.getX(), offset.getY());
        Element div = df.getOwnerDocument().createElement("div");
        div.setAttribute("style", "position:absolute; left:" + xy.width + "px; top:" + xy.height + "px;");
        Node img = df.getFirstChild();
        df.removeChild(img);
        df.appendChild(div);
        div.appendChild(img);
        return df;
    }

    public static PictureExporter createPicture(SvgConversionContext context, NodeIterator anchorOrInline) {
        PictureExporter converter = new PictureExporter();
        try {
            Node n = anchorOrInline.nextNode();
            converter.pic = (Pic)XmlUtils.unmarshal(n, Context.jcPML, Pic.class);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        log.info("** image: " + converter.pic.getClass().getName());
        if (converter.pic.getBlipFill() == null || converter.pic.getBlipFill().getBlip() == null) {
            log.error("blip missing!!");
            return null;
        }
        CTBlip blip = converter.pic.getBlipFill().getBlip();
        String imgRelId = blip.getEmbed();
        if (imgRelId != null) {
            converter.handleImageRel(context.getImageHandler(), imgRelId, (Part)context.getResolvedLayout().relationships.getSourceP());
        } else if (blip.getLink() != null) {
            converter.handleImageRel(context.getImageHandler(), blip.getLink(), (Part)context.getResolvedLayout().relationships.getSourceP());
        } else {
            log.error("not linked or embedded?!");
        }
        converter.dimensions = converter.readDimensions(converter.pic.getSpPr().getXfrm().getExt());
        return converter;
    }

    private AbstractWordXmlPicture.Dimensions readDimensions(long x, long y) {
        AbstractWordXmlPicture.Dimensions dimensions = new AbstractWordXmlPicture.Dimensions();
        dimensions.width = (int)x / 9525;
        dimensions.widthUnit = "px";
        dimensions.height = (int)y / 9525;
        dimensions.heightUnit = "px";
        return dimensions;
    }

    private AbstractWordXmlPicture.Dimensions readDimensions(CTPositiveSize2D size2d) {
        if (size2d == null) {
            log.warn("wp:inline/wp:extent missing!");
            return null;
        }
        return this.readDimensions(size2d.getCx(), size2d.getCy());
    }
}

