/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.util.List;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.Parts;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class CustomXmlDataStoragePart
extends Part
implements CustomXmlPart {
    private static Logger log = LoggerFactory.getLogger(CustomXmlDataStoragePart.class);
    private CustomXmlDataStorage data;

    public CustomXmlDataStoragePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public CustomXmlDataStoragePart() throws InvalidFormatException {
        super(new PartName("/customXml/item1.xml"));
        this.init();
    }

    @Deprecated
    public CustomXmlDataStoragePart(Parts parts) throws InvalidFormatException {
        int partNum = 1;
        if (parts != null) {
            while (parts.get(new PartName("/customXml/item" + partNum + ".xml")) != null) {
                ++partNum;
            }
        }
        this.setPartName(new PartName("/customXml/item" + partNum + ".xml"));
        log.info("Using PartName /customXml/item" + partNum + ".xml");
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml");
    }

    public CustomXmlDataStorage getData() {
        return this.data;
    }

    public void setData(CustomXmlDataStorage data) {
        this.data = data;
    }

    @Override
    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof CustomXmlDataStoragePart)) {
            return false;
        }
        Document doc1 = this.data.getDocument();
        Document doc2 = ((CustomXmlDataStoragePart)other).data.getDocument();
        return doc1.isEqualNode(doc2);
    }

    @Override
    public String xpathGetString(String xpath, String prefixMappings) throws Docx4JException {
        return this.getData().xpathGetString(xpath, prefixMappings);
    }

    @Override
    public String cachedXPathGetString(String xpath, String prefixMappings) throws Docx4JException {
        return this.getData().cachedXPathGetString(xpath, prefixMappings);
    }

    @Override
    public boolean xpathGetAsBoolean(String xpath, String prefixMappings) throws Docx4JException {
        return this.getData().xpathGetAsBoolean(xpath, prefixMappings);
    }

    @Override
    public boolean cachedXPathGetBoolean(String xpath, String prefixMappings) throws Docx4JException {
        return this.getData().cachedXPathGetBoolean(xpath, prefixMappings);
    }

    @Override
    public void discardCacheXPathObject() {
        this.getData().discardCacheXPathObject();
    }

    @Override
    public List<Node> xpathGetNodes(String xpathString, String prefixMappings) throws Docx4JException {
        return this.getData().xpathGetNodes(xpathString, prefixMappings);
    }

    @Override
    public boolean setNodeValueAtXPath(String xpath, String value, String prefixMappings) throws Docx4JException {
        return this.data.setNodeValueAtXPath(xpath, value, prefixMappings);
    }

    @Override
    public String getXML() throws Docx4JException {
        return this.data.getXML();
    }

    @Override
    public void setXML(Document xmlDocument) throws Docx4JException {
        this.getData().setDocument(xmlDocument);
    }

    @Override
    public String getItemId() {
        if (this.getRelationshipsPart() == null) {
            return null;
        }
        Relationship r = this.getRelationshipsPart().getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps");
        if (r == null) {
            log.warn(".. but that doesn't point to a  customXmlProps part");
            return null;
        }
        CustomXmlDataStoragePropertiesPart customXmlProps = (CustomXmlDataStoragePropertiesPart)this.getRelationshipsPart().getPart(r);
        if (customXmlProps == null) {
            log.warn(".. but the target seems to be missing?");
            return null;
        }
        return customXmlProps.getItemId().toLowerCase();
    }

    @Override
    public void remove() {
        String itemId = this.getItemId();
        if (itemId != null) {
            log.debug("removing from CustomXmlDataStorageParts " + itemId);
            this.getPackage().getCustomXmlDataStorageParts().remove(itemId);
        }
        super.remove();
    }
}

