/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

public class FoNumberFormatUtil {
    public static final String FO_PAGENUMBER_DECIMAL = "1";
    public static final String FO_PAGENUMBER_LOWERALPHA = "a";
    public static final String FO_PAGENUMBER_UPPERALPHA = "A";
    public static final String FO_PAGENUMBER_LOWERROMAN = "i";
    public static final String FO_PAGENUMBER_UPPERROMAN = "I";

    public static String format(int pageNumber, String foFormat) {
        String ret = null;
        if (pageNumber > -1) {
            if (foFormat == null) {
                foFormat = FO_PAGENUMBER_DECIMAL;
            }
            if (pageNumber == 1) {
                ret = foFormat;
            } else if (FO_PAGENUMBER_DECIMAL.equals(foFormat)) {
                ret = Integer.toString(pageNumber);
            } else if (FO_PAGENUMBER_LOWERROMAN.equals(foFormat) || FO_PAGENUMBER_UPPERROMAN.equals(foFormat)) {
                ret = FoNumberFormatUtil.makeRoman(pageNumber);
                if (FO_PAGENUMBER_UPPERROMAN.equals(foFormat)) {
                    ret = ret.toUpperCase();
                }
            } else {
                ret = FoNumberFormatUtil.makeAlpha(pageNumber);
                if (FO_PAGENUMBER_UPPERALPHA.equals(foFormat)) {
                    ret = ret.toUpperCase();
                }
            }
        }
        return ret;
    }

    private static String makeRoman(int num) {
        int[] arabic = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] roman = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", FO_PAGENUMBER_LOWERROMAN};
        int i = 0;
        StringBuffer romanNumber = new StringBuffer();
        while (num > 0) {
            while (num >= arabic[i]) {
                num -= arabic[i];
                romanNumber.append(roman[i]);
            }
            ++i;
        }
        return romanNumber.toString();
    }

    private static String makeAlpha(int num) {
        String letters = "abcdefghijklmnopqrstuvwxyz";
        StringBuffer alphaNumber = new StringBuffer();
        int base = 26;
        int rem = 0;
        if (--num < base) {
            alphaNumber.append(letters.charAt(num));
        } else {
            while (num >= base) {
                rem = num % base;
                alphaNumber.append(letters.charAt(rem));
                num /= base;
            }
            alphaNumber.append(letters.charAt(num - 1));
        }
        return alphaNumber.reverse().toString();
    }
}

