/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.math.BigInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.LocationAwareXMLStreamException;
import org.docx4j.openpackaging.parts.StAXHandlerAbstract;
import org.docx4j.openpackaging.parts.WordprocessingML.SdtStAXHandler;
import org.docx4j.wml.CTBookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkHandlerStAX
extends StAXHandlerAbstract {
    private static Logger log = LoggerFactory.getLogger(SdtStAXHandler.class);
    public static JAXBContext context = Context.jc;
    private int highestId = 0;

    public int getHighestId() {
        return this.highestId;
    }

    @Override
    public void handle(XMLStreamReader xsr, XMLStreamWriter xmlWriter) throws LocationAwareXMLStreamException, XMLStreamException {
        boolean mustMove = true;
        while (xsr.hasNext()) {
            int eventType;
            if (mustMove) {
                xsr.next();
            }
            if ((eventType = xsr.getEventType()) == 1) {
                String localName = xsr.getLocalName();
                log.debug("START_ELEMENT " + localName);
                if (xsr.getLocalName().equals("bookmarkStart")) {
                    Object o = null;
                    try {
                        Unmarshaller unmarshaller = context.createUnmarshaller();
                        o = unmarshaller.unmarshal(xsr, CTBookmark.class);
                    }
                    catch (JAXBException e) {
                        throw new XMLStreamException(e.getMessage(), e);
                    }
                    o = XmlUtils.unwrap(o);
                    log.debug(o.getClass().getName());
                    if (o instanceof CTBookmark) {
                        CTBookmark bm = (CTBookmark)o;
                        BigInteger id = bm.getId();
                        if (id != null && id.intValue() > this.highestId) {
                            this.highestId = id.intValue();
                        }
                        try {
                            Marshaller m = context.createMarshaller();
                            m.setProperty("jaxb.fragment", (Object)true);
                            m.marshal((Object)bm, xmlWriter);
                        }
                        catch (JAXBException e) {
                            throw new XMLStreamException(e);
                        }
                        mustMove = false;
                        continue;
                    }
                    log.error("Unexpected " + o.getClass().getName());
                    continue;
                }
                this.write(xsr, xmlWriter);
                mustMove = true;
                continue;
            }
            if (eventType == 2) {
                this.write(xsr, xmlWriter);
                mustMove = true;
                continue;
            }
            this.write(xsr, xmlWriter);
            mustMove = true;
        }
    }

    @Override
    public void handleCharacters(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        sb.append(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength());
        writer.writeCharacters(sb.toString());
    }
}

