/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.model.datastorage.BindingHyperlinkResolver;
import org.docx4j.wml.P;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingHyperlinkResolverForOpenAPI3
extends BindingHyperlinkResolver {
    private static Logger log = LoggerFactory.getLogger(BindingHyperlinkResolver.class);
    private static final String COMPONENT_REF = "#/components";

    @Override
    public int getIndexOfURL(String text) {
        if (text.startsWith(COMPONENT_REF)) {
            return 0;
        }
        return super.getIndexOfURL(text);
    }

    @Override
    public P.Hyperlink generateHyperlink(String bookmarkName, String url) throws JAXBException {
        if (url.startsWith(COMPONENT_REF)) {
            String hpl = "<w:hyperlink w:anchor=\"" + bookmarkName + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" ><w:r><w:rPr><w:rStyle w:val=\"" + this.getHyperlinkStyleId() + "\" /></w:rPr><w:t>" + url + "</w:t></w:r></w:hyperlink>";
            return (P.Hyperlink)XmlUtils.unmarshalString(hpl);
        }
        return super.generateHyperlink(bookmarkName, url);
    }
}

