/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import org.docx4j.model.PropertyResolver;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleBasedOnHelper {
    private static Logger log = LoggerFactory.getLogger(StyleBasedOnHelper.class);
    private PropertyResolver propertyResolver;
    private static final String HEADING_STYLE = "Heading";

    public StyleBasedOnHelper(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public boolean isBasedOn(Style thisStyle, String baseStyleId) {
        if (thisStyle.getStyleId().equals(baseStyleId)) {
            return true;
        }
        if (thisStyle.getBasedOn() == null) {
            return false;
        }
        Style baseStyle = this.propertyResolver.getStyle(thisStyle.getBasedOn().getVal());
        if (baseStyle == null) {
            log.error(thisStyle.getStyleId() + " is based on missing " + thisStyle.getBasedOn().getVal());
            return false;
        }
        return this.isBasedOn(baseStyle, baseStyleId);
    }

    public int getBasedOnHeading(Style s) {
        int level = -1;
        if (s.getStyleId().startsWith(HEADING_STYLE)) {
            level = this.getLvlFromHeadingStyle(s.getStyleId());
        } else if (s.getName() != null && s.getName().getVal() != null && s.getName().getVal().startsWith(HEADING_STYLE.toLowerCase())) {
            level = this.getLvlFromHeadingStyle(s.getName().getVal());
        }
        if (level == -1) {
            if (s.getBasedOn() == null) {
                return -1;
            }
            return this.getBasedOnHeading(this.propertyResolver.getStyle(s.getBasedOn().getVal()));
        }
        return level;
    }

    private int getLvlFromHeadingStyle(String style) {
        int level = -1;
        try {
            level = Integer.parseInt(style.substring(HEADING_STYLE.length(), style.length()).trim());
            if (level < 1 || level > 9) {
                level = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return level;
    }
}

