/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.wml.CTSdtDocPart;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.P;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocFinder
extends TraversalUtil.CallbackImpl {
    private static Logger log = LoggerFactory.getLogger(TocFinder.class);
    SdtBlock tocSDT = null;
    SectPr sectPr = null;
    List<P> tocHeadingP = new ArrayList<P>();
    String tocInstruction = null;
    private SdtBlock currentSDT = null;
    private boolean foundToC = false;

    public SdtBlock getTocSDT() {
        return this.tocSDT;
    }

    @Override
    public List<Object> apply(Object o) {
        P p;
        if (this.currentSDT != null) {
            CTSimpleField fldSimple;
            if (o instanceof P && this.isDocPartToC(this.currentSDT) && !this.foundToC) {
                this.tocHeadingP.add((P)o);
            } else if (o instanceof JAXBElement && ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
                Text instr = (Text)XmlUtils.unwrap(o);
                if (instr.getValue().contains("TOC")) {
                    this.tocInstruction = instr.getValue();
                    this.tocSDT = this.currentSDT;
                    this.foundToC = true;
                    log.debug("found the sdt!");
                    this.removeLastHeadingP();
                }
            } else if (o instanceof JAXBElement && ((JAXBElement)o).getName().getLocalPart().equals("fldSimple")) {
                fldSimple = (CTSimpleField)XmlUtils.unwrap(o);
                if (fldSimple.getInstr().contains("TOC")) {
                    this.tocInstruction = fldSimple.getInstr();
                    this.tocSDT = this.currentSDT;
                    this.foundToC = true;
                    log.debug("found the sdt!");
                    this.removeLastHeadingP();
                }
            } else if (o instanceof CTSimpleField && (fldSimple = (CTSimpleField)o).getInstr().contains("TOC")) {
                this.tocInstruction = fldSimple.getInstr();
                this.tocSDT = this.currentSDT;
                this.foundToC = true;
                log.debug("found the sdt!");
                this.removeLastHeadingP();
            }
        }
        if (this.foundToC && o instanceof P && (p = (P)o).getPPr() != null && p.getPPr().getSectPr() != null) {
            this.sectPr = p.getPPr().getSectPr();
        }
        return null;
    }

    private void removeLastHeadingP() {
        if (this.tocHeadingP.size() > 0) {
            this.tocHeadingP.remove(this.tocHeadingP.size() - 1);
        }
    }

    private boolean isDocPartToC(SdtBlock currentSDT) {
        SdtPr sdtPr = currentSDT.getSdtPr();
        CTSdtDocPart docPart = this.getDocPartObj(sdtPr);
        return docPart != null && docPart.getDocPartGallery() != null && docPart.getDocPartGallery().getVal() != null && docPart.getDocPartGallery().getVal().equals("Table of Contents");
    }

    private CTSdtDocPart getDocPartObj(SdtPr sdtPr) {
        if (sdtPr == null) {
            return null;
        }
        for (Object o : sdtPr.getRPrOrAliasOrLock()) {
            if (!(XmlUtils.unwrap(o) instanceof CTSdtDocPart)) continue;
            return (CTSdtDocPart)XmlUtils.unwrap(o);
        }
        return null;
    }

    @Override
    public void walkJAXBElements(Object parent) {
        List<Object> children = this.getChildren(parent);
        if (children != null) {
            for (Object o : children) {
                this.apply(o);
                if (this.shouldTraverse(o)) {
                    if ((o = XmlUtils.unwrap(o)) instanceof SdtBlock) {
                        this.currentSDT = (SdtBlock)o;
                        this.walkJAXBElements(o);
                        this.currentSDT = null;
                    } else {
                        this.walkJAXBElements(o);
                    }
                }
                if (this.sectPr == null) continue;
                break;
            }
        }
    }

    @Override
    public List<Object> getChildren(Object o) {
        return TraversalUtil.getChildrenImpl(o);
    }

    @Override
    public boolean shouldTraverse(Object o) {
        if (this.foundToC && o instanceof P) {
            return false;
        }
        return this.sectPr == null;
    }
}

