/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.BindingTraverserCommonImpl;
import org.docx4j.model.datastorage.BindingTraverserState;
import org.docx4j.model.datastorage.BindingTraverserTableHelper;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.DomToXPathMap;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.datastorage.XHTMLAttrInjector;
import org.docx4j.model.datastorage.XmlNameUtil;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io3.stores.UnzippedPartStore;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.opendope.JaxbCustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.org.apache.xalan.extensions.ExpressionContext;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.w14.CTSdtCheckbox;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTSdtDate;
import org.docx4j.wml.Color;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;

public class BindingTraverserXSLT
extends BindingTraverserCommonImpl {
    private static Logger log = LoggerFactory.getLogger(BindingTraverserXSLT.class);
    public static boolean ENABLE_XPATH_CACHE = true;
    static Templates xslt;
    private DomToXPathMap domToXPathMap = null;
    private static DocumentFragment placeholderFragment;
    private static byte[] placeholderBytes;
    private static final String placeholderResourceFallback = "org/docx4j/model/datastorage/placeholder.xml";
    private static final String placeholderResource = "OpenDoPE/placeholder.xml";
    private static Boolean importXHTMLMissing;

    public void setDomToXPathMap(DomToXPathMap domToXPathMap) {
        this.domToXPathMap = domToXPathMap;
    }

    @Override
    public Object traverseToBind(JaxbXmlPart part, OpcPackage pkg, Map<String, Xpaths.Xpath> xpathsMap) throws Docx4JException {
        Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        try {
            DOMResult result = new DOMResult();
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            transformParameters.put("customXmlDataStorageParts", part.getPackage().getCustomXmlDataStorageParts());
            transformParameters.put("wmlPackage", (WordprocessingMLPackage)pkg);
            transformParameters.put("sourcePart", part);
            transformParameters.put("xPathsMap", xpathsMap);
            transformParameters.put("sequenceCounters", new HashMap());
            transformParameters.put("bookmarkIdCounter", new BookmarkCounter(this.bookmarkId));
            BindingTraverserState bindingTraverserState = new BindingTraverserState();
            transformParameters.put("bindingTraverserState", bindingTraverserState);
            if (ENABLE_XPATH_CACHE) {
                if (this.domToXPathMap == null) {
                    CustomXmlPart cxp = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart((WordprocessingMLPackage)pkg);
                    if (cxp == null) {
                        log.warn("No CustomXmlDataStoragePart found; can't cache.");
                    } else if (cxp instanceof CustomXmlDataStoragePart) {
                        CustomXmlDataStoragePart cdsp = (CustomXmlDataStoragePart)cxp;
                        long start = System.currentTimeMillis();
                        Document data = cdsp.getData().getDocument();
                        this.domToXPathMap = new DomToXPathMap(data);
                        this.domToXPathMap.map();
                        long end = System.currentTimeMillis();
                        long time = end - start;
                        log.debug("Mapped in " + time + "ms");
                    } else if (cxp instanceof JaxbCustomXmlDataStoragePart) {
                        Document data = XmlUtils.neww3cDomDocument();
                        try {
                            ((JaxbCustomXmlDataStoragePart)cxp).marshal(data);
                        }
                        catch (JAXBException e) {
                            throw new Docx4JException("Problem caching JaxbCustomXmlDataStoragePart", (Exception)((Object)e));
                        }
                        this.domToXPathMap = new DomToXPathMap(data);
                        this.domToXPathMap.map();
                        log.debug("Mapped " + this.domToXPathMap.getCountMap().size());
                    } else {
                        log.warn("TODO: cache " + cxp.getClass().getName());
                    }
                }
                Map<String, String> pathMap = null;
                if (this.domToXPathMap != null) {
                    pathMap = this.domToXPathMap.getPathMap();
                }
                bindingTraverserState.setPathMap(pathMap);
            }
            XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
            try {
                return this.unmarshal((Document)result.getNode(), Docx4jProperties.getProperty("docx4j.model.datastorage.BindingTraverserXSLT.ValidationEventContinue", false));
            }
            catch (UnmarshalException e) {
                log.error("Problem: " + XmlUtils.w3CDomNodeToString(result.getNode()));
                throw e;
            }
        }
        catch (UnmarshalException e) {
            if (!Docx4jProperties.getProperty("docx4j.model.datastorage.BindingTraverserXSLT.ValidationEventContinue", false)) {
                log.error("Configured to fail in the case of content loss; you can set property docx4j.model.datastorage.BindingTraverserXSLT.ValidationEventContinue if you wish to force output to be generated");
            }
            throw new Docx4JException("Problems applying bindings", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new Docx4JException("Problems applying bindings", e);
        }
    }

    private Object unmarshal(org.w3c.dom.Node n, boolean continu) throws JAXBException {
        Unmarshaller u = Context.jc.createUnmarshaller();
        JaxbValidationEventHandler veh = new JaxbValidationEventHandler();
        veh.setContinue(continu);
        u.setEventHandler((ValidationEventHandler)veh);
        return u.unmarshal(n);
    }

    public static void log(ExpressionContext expressionContext, String message) {
        log.info("[String] " + message);
    }

    public static void log(NodeIterator nodeIterator) {
        org.w3c.dom.Node n = nodeIterator.nextNode();
        log.info(XmlUtils.w3CDomNodeToString(n));
    }

    public static void logXml(NodeIterator nodeIterator) {
        BindingTraverserXSLT.log(nodeIterator);
    }

    protected static DocumentFragment createPlaceholder(RPr rPr) throws Exception {
        return BindingTraverserXSLT.createPlaceholder(rPr, "p");
    }

    protected static DocumentFragment createPlaceholder(RPr rPr, String sdtParent) throws Exception {
        if (placeholderFragment == null) {
            BindingTraverserXSLT.createPlaceholderFragment();
        }
        if (placeholderBytes == null) {
            BindingTraverserXSLT.createPlaceholderBytes();
        }
        if (sdtParent.equals("p")) {
            if (rPr == null) {
                return placeholderFragment;
            }
            R run = (R)XmlUtils.unmarshal(new ByteArrayInputStream(placeholderBytes));
            if (run.getRPr() == null) {
                run.setRPr(new RPr());
            }
            StyleUtil.apply(rPr, run.getRPr());
            Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
            DocumentFragment docfrag = tmpDoc.createDocumentFragment();
            XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
            return docfrag;
        }
        R run = (R)XmlUtils.unmarshal(new ByteArrayInputStream(placeholderBytes));
        run.setRPr(rPr);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        DocumentFragment docfrag = tmpDoc.createDocumentFragment();
        if (sdtParent.equals("tbl")) {
            Element wtr = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr");
            docfrag.appendChild(wtr);
            Element wtc = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            wtr.appendChild(wtc);
            Element wp = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(tmpDoc.getDocumentElement());
            return docfrag;
        }
        if (sdtParent.equals("tr")) {
            Element wtc = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            docfrag.appendChild(wtc);
            Element wp = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(tmpDoc.getDocumentElement());
            return docfrag;
        }
        if (sdtParent.equals("tc") || sdtParent.equals("body")) {
            Element wp = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            docfrag.appendChild(wp);
            wp.appendChild(tmpDoc.getDocumentElement());
            return docfrag;
        }
        return null;
    }

    private static void createPlaceholderFragment() throws Exception {
        InputStream is;
        try {
            is = ResourceUtils.getResourceViaProperty("docx4j.model.datastorage.placeholder", placeholderResource);
        }
        catch (IOException e) {
            log.info("No resource on classpath for property docx4j.model.datastorage.placeholder; falling back to using org/docx4j/model/datastorage/placeholder.xml");
            is = ResourceUtils.getResource(placeholderResourceFallback);
        }
        Document tmpDoc = XmlUtils.getNewDocumentBuilder().parse(is);
        placeholderFragment = tmpDoc.createDocumentFragment();
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)placeholderFragment);
    }

    private static void createPlaceholderBytes() throws Exception {
        InputStream is;
        try {
            is = ResourceUtils.getResourceViaProperty("docx4j.model.datastorage.placeholder", placeholderResource);
        }
        catch (IOException e) {
            log.info("No resource on classpath at docx4j.model.datastorage.placeholder; falling back to using org/docx4j/model/datastorage/placeholder.xml");
            is = ResourceUtils.getResource(placeholderResourceFallback);
        }
        placeholderBytes = IOUtils.toByteArray((InputStream)is);
    }

    public static Boolean importXHTMLMissing() {
        if (importXHTMLMissing == null) {
            Class<?> xhtmlImporterClass = null;
            try {
                xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.XHTMLImporterImpl");
                importXHTMLMissing = Boolean.FALSE;
            }
            catch (Exception e) {
                importXHTMLMissing = Boolean.TRUE;
            }
        }
        return importXHTMLMissing;
    }

    private static Xpaths.Xpath getXpathFromTag(Tag tag, Map<String, Xpaths.Xpath> xpathsMap) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String xpathId = map.get("od:xpath");
        log.info("Looking for xpath by id: " + xpathId);
        Xpaths.Xpath xpath = xpathsMap.get(xpathId);
        if (xpath == null) {
            log.warn("Couldn't find xpath with id: " + xpathId);
        }
        return xpath;
    }

    private static String evaluate(Xpaths.Xpath xpath, BindingTraverserState bindingTraverserState, WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts) {
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        String r = null;
        if (bindingTraverserState.getPathMap() != null) {
            r = bindingTraverserState.getPathMap().get(BindingTraverserXSLT.normalisePath(xpathExp));
        }
        if (r == null) {
            log.debug("cache miss for " + xpathExp);
            r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings);
        } else if (log.isDebugEnabled() && r.trim().length() == 0 && (r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings)).trim().length() > 0) {
            log.warn("cache query " + xpathExp);
        }
        return r;
    }

    public static DocumentFragment convertXHTMLtoAltChunk(BindingTraverserState bindingTraverserState, WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Xpaths.Xpath> xpathsMap, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, Map<String, Integer> sequenceCounters, BookmarkCounter bookmarkCounter) {
        log.debug("convertXHTMLtoAltChunk extension function for: " + sdtParent + "/w:sdt/w:sdtContent/" + contentChild);
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Xpaths.Xpath xpath = BindingTraverserXSLT.getXpathFromTag(sdtPr.getTag(), xpathsMap);
        if (xpath == null) {
            return null;
        }
        String r = BindingTraverserXSLT.evaluate(xpath, bindingTraverserState, pkg, customXmlDataStorageParts);
        try {
            RPr rPrSDT = (RPr)sdtPr.getByClass(RPr.class);
            if (r == null || r.trim().equals("")) {
                return BindingTraverserXSLT.createPlaceholder(rPrSDT, sdtParent);
            }
            r = r.trim();
            AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(AltChunkType.Html);
            Relationship altChunkRel = pkg.getMainDocumentPart().addTargetPart((Part)afiPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            afiPart.registerInContentTypeManager();
            afiPart.setBinaryData(r.getBytes());
            CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
            ac.setId(altChunkRel.getId());
            log.debug("context: " + sdtParent);
            Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(ac);
            if (log.isDebugEnabled()) {
                log.debug(XmlUtils.w3CDomNodeToString(tmpDoc));
            }
            DocumentFragment docfrag = XmlUtils.neww3cDomDocument().createDocumentFragment();
            XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DocumentFragment convertXHTML(BindingTraverserState bindingTraverserState, WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Xpaths.Xpath> xpathsMap, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, Map<String, Integer> sequenceCounters, BookmarkCounter bookmarkCounter) {
        Xpaths.Xpath xpath;
        log.debug("convertXHTML extension function for: " + sdtParent + "/w:sdt/w:sdtContent/" + contentChild);
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Document docContainer = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = docContainer.createDocumentFragment();
        XHTMLImporter xHTMLImporter = null;
        Class<?> xhtmlImporterClass = null;
        try {
            xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.XHTMLImporterImpl");
            Constructor<?> ctor = xhtmlImporterClass.getConstructor(WordprocessingMLPackage.class);
            xHTMLImporter = (XHTMLImporter)ctor.newInstance(pkg);
        }
        catch (Exception e) {
            log.error("docx4j-XHTMLImport jar not found. Please add this to your classpath.");
            log.error(e.getMessage(), (Throwable)e);
            return BindingTraverserXSLT.xhtmlError(sdtParent, docContainer, docfrag, "Missing XHTML Handler!");
        }
        xHTMLImporter.setSequenceCounters(sequenceCounters);
        Method[] methods = xhtmlImporterClass.getMethods();
        Method method = null;
        for (int j = 0; j < methods.length; ++j) {
            if (!methods[j].getName().equals("setBookmarkIdNext") || methods[j].getParameterTypes().length != 1) continue;
            method = methods[j];
            break;
        }
        if (method == null) {
            log.info("setBookmarkIdNext method not found.  If you are using docx4j-ImportXHTML v3.2.1 or later, it should be present.");
        } else {
            try {
                method.invoke((Object)xHTMLImporter, bookmarkCounter.bookmarkId);
            }
            catch (Exception e1) {
                log.error(e1.getMessage(), (Throwable)e1);
            }
        }
        xHTMLImporter.setMaxWidth(-1, null);
        if (bindingTraverserState.tcStack.peek() != null) {
            log.debug("inserting in a tc");
            BindingTraverserTableHelper.setupMaxWidthAndStyleForTc(bindingTraverserState.tblStack.peek(), bindingTraverserState.tcStack.peek(), xHTMLImporter);
        }
        if ((xpath = BindingTraverserXSLT.getXpathFromTag(sdtPr.getTag(), xpathsMap)) == null) {
            return null;
        }
        Object r = BindingTraverserXSLT.evaluate(xpath, bindingTraverserState, pkg, customXmlDataStorageParts);
        try {
            Document tmpDoc;
            StringBuilder result;
            String css;
            Node<StyleTree.AugmentedStyle> asn;
            StyleTree styleTree;
            RPr rPrSDT = (RPr)sdtPr.getByClass(RPr.class);
            if (r == null || ((String)r).trim().equals("")) {
                return BindingTraverserXSLT.createPlaceholder(rPrSDT, sdtParent);
            }
            if (((String)(r = ((String)r).trim())).startsWith("<span")) {
                Tree<StyleTree.AugmentedStyle> cTree;
                Style defaultRunStyle = pkg.getMainDocumentPart().getStyleDefinitionsPart(false) != null ? pkg.getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultCharacterStyle() : null;
                String defaultCharacterStyleId = defaultRunStyle.getStyleId() == null ? "DefaultParagraphFont" : defaultRunStyle.getStyleId();
                styleTree = pkg.getMainDocumentPart().getStyleTree();
                String classVal = null;
                String rStyleVal = defaultCharacterStyleId;
                if (rPrSDT != null && rPrSDT.getRStyle() != null) {
                    rStyleVal = rPrSDT.getRStyle().getVal();
                }
                if ((asn = (cTree = styleTree.getCharacterStylesTree()).get(rStyleVal)) == null) {
                    log.warn("No style node for: " + rStyleVal);
                } else {
                    classVal = StyleTree.getHtmlClassAttributeValue(cTree, asn);
                }
                css = null;
                if (rPrSDT != null) {
                    result = new StringBuilder();
                    HtmlCssHelper.createCss(pkg, rPrSDT, result);
                    css = result.toString();
                    if (css.equals("")) {
                        css = null;
                    }
                }
                if (css != null || classVal != null) {
                    r = classVal == null ? "<span style=\"" + css + "\">" + (String)r + "</span>" : (css == null ? "<span class=\"" + classVal + "\">" + (String)r + "</span>" : "<span style=\"" + css + "\" class=\"" + classVal + "\">" + (String)r + "</span>");
                }
                log.debug("\nenhanced with css: \n" + (String)r);
            } else if (Docx4jProperties.getProperty("docx4j.model.datastorage.BindingTraverser.XHTML.Block.rStyle.Adopt", false)) {
                log.debug("Block.rStyle.Adopt..");
                String rStyleVal = null;
                if (rPrSDT != null && rPrSDT.getRStyle() != null) {
                    rStyleVal = rPrSDT.getRStyle().getVal();
                    log.debug(".." + rStyleVal);
                }
                if (rStyleVal == null) {
                    log.debug("No rStyle specified ");
                } else {
                    Style pStyle = pkg.getMainDocumentPart().getStyleDefinitionsPart(false).getLinkedStyle(rStyleVal);
                    if (pStyle == null) {
                        log.warn("No linked style for " + rStyleVal);
                    } else {
                        styleTree = pkg.getMainDocumentPart().getStyleTree();
                        String pStyleVal = pStyle.getStyleId();
                        log.debug(".." + pStyleVal);
                        String classVal = null;
                        Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
                        asn = pTree.get(pStyleVal);
                        if (asn == null) {
                            log.warn("No style node for: " + pStyleVal);
                        } else {
                            classVal = StyleTree.getHtmlClassAttributeValue(pTree, asn);
                        }
                        css = null;
                        if (rPrSDT != null) {
                            result = new StringBuilder();
                            HtmlCssHelper.createCss(pkg, rPrSDT, result);
                            css = result.toString();
                            if (css.equals("")) {
                                css = null;
                            }
                        }
                        r = XHTMLAttrInjector.injectAttrs((String)r, classVal, css);
                        log.debug(".." + (String)r);
                    }
                }
            }
            xHTMLImporter.setHyperlinkStyle(BindingHandler.getHyperlinkResolver().getHyperlinkStyleId());
            String baseUrl = null;
            List<Object> results = null;
            try {
                results = xHTMLImporter.convert((String)r, baseUrl);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    ((NullPointerException)e).printStackTrace();
                }
                log.error("with XHTML: " + (String)r, (Throwable)e);
                String errMsg = e.getMessage() + " with XHTML from " + sdtPr.getTag().getVal() + " : " + (String)r;
                return BindingTraverserXSLT.xhtmlError(sdtParent, docContainer, docfrag, errMsg);
            }
            if (results == null) {
                log.error("Couldn't convert " + (String)r);
                return docfrag;
            }
            log.info("Got results: " + results.size());
            log.debug("context: " + sdtParent);
            if (results.size() > 0 && results.get(0) instanceof P && sdtParent.equals("p")) {
                if (results.size() > 1) {
                    log.warn("In paragraph context, so extra block-level content is being discarded!");
                }
                for (Object o : ((P)results.get(0)).getContent()) {
                    tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.w3CDomNodeToString(tmpDoc));
                    }
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
                }
            } else {
                for (Object o : results) {
                    if (sdtParent.equals("p") && o instanceof P) {
                        if (log.isWarnEnabled()) {
                            log.warn("DISCARDING conversion result (can't add in context p): " + XmlUtils.marshaltoString(o, true));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Conversion result: " + XmlUtils.marshaltoString(o, true));
                    }
                    tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.w3CDomNodeToString(tmpDoc));
                    }
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
                }
            }
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static DocumentFragment xhtmlError(String sdtParent, Document docContainer, DocumentFragment docfrag, String errMsg) {
        Element wr = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "r");
        Element wt = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");
        wt.setTextContent(errMsg);
        wr.appendChild(wt);
        if (sdtParent.equals("p")) {
            docfrag.appendChild(wr);
            return docfrag;
        }
        if (sdtParent.equals("tbl")) {
            Element wtr = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr");
            docfrag.appendChild(wtr);
            Element wtc = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            wtr.appendChild(wtc);
            Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(wr);
            return docfrag;
        }
        if (sdtParent.equals("tr")) {
            Element wtc = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            docfrag.appendChild(wtc);
            Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(wr);
            return docfrag;
        }
        if (sdtParent.equals("tc")) {
            Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            docfrag.appendChild(wp);
            wp.appendChild(wr);
            return docfrag;
        }
        Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
        docfrag.appendChild(wp);
        wp.appendChild(wr);
        return docfrag;
    }

    public static DocumentFragment xpathGenerateRuns(BindingTraverserState bindingTraverserState, WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Xpaths.Xpath> xpathsMap, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, boolean multiLine, BookmarkCounter bookmarkCounter) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String odTag = sdtPr.getTag().getVal();
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:xpath");
        log.debug("Looking for xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag);
        Xpaths.Xpath xpath = null;
        try {
            xpath = xpathsMap.get(xpathId);
        }
        catch (InputIntegrityException iie) {
            throw new InputIntegrityException("Couldn't find xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag, iie);
        }
        if (xpath == null) {
            log.error("Couldn't find xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag);
            throw new InputIntegrityException("Couldn't find xpath with id: " + xpathId);
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        return BindingTraverserXSLT.xpathGenerateRuns(bindingTraverserState.getPathMap(), pkg, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings, sdtPr, sdtParent, contentChild, multiLine, bookmarkCounter);
    }

    public static DocumentFragment xpathGenerateRuns(BindingTraverserState bindingTraverserState, WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, boolean multiLine, BookmarkCounter bookmarkCounter) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return BindingTraverserXSLT.xpathGenerateRuns(bindingTraverserState.getPathMap(), pkg, sourcePart, customXmlDataStorageParts, storeItemId, xpath, prefixMappings, sdtPr, sdtParent, contentChild, multiLine, bookmarkCounter);
    }

    private static String normalisePath(String xpIn) {
        return xpIn.replace("][1]", "]");
    }

    public static DocumentFragment xpathGenerateRuns(Map<String, String> pathMap, WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, SdtPr sdtPr, String sdtParent, String contentChild, boolean multiLine, BookmarkCounter bookmarkCounter) {
        String r = null;
        if (pathMap != null) {
            r = pathMap.get(BindingTraverserXSLT.normalisePath(xpath));
        }
        if (r == null) {
            log.debug("cache miss for " + xpath);
            r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings);
        } else if (log.isDebugEnabled() && r.trim().length() == 0 && (r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings)).trim().length() > 0) {
            log.warn("cache query " + xpath);
        }
        r = r.trim();
        if (xpath.startsWith("local-name")) {
            r = XmlNameUtil.descapeXmlTypeName(r);
        }
        try {
            log.info(xpath + "\n yielded result '" + r + "'");
            RPr rPr = null;
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                if (!((o = XmlUtils.unwrap(o)) instanceof RPr)) continue;
                rPr = (RPr)o;
                break;
            }
            Xpaths.Xpath.DataBinding dataBinding = new Xpaths.Xpath.DataBinding();
            dataBinding.setXpath(xpath);
            dataBinding.setPrefixMappings(prefixMappings);
            dataBinding.setStoreItemID(storeItemId);
            return BindingHandler.getValueInserterPlainText().toOpenXml(dataBinding, rPr, multiLine, bookmarkCounter, r, sourcePart);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DocumentFragment xpathInjectImage(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, Map<String, Xpaths.Xpath> xpathsMap, String odTag, String sdtParent, String contentChild) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:xpath");
        log.debug("Looking for xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag);
        Xpaths.Xpath xpath = null;
        try {
            xpath = xpathsMap.get(xpathId);
        }
        catch (InputIntegrityException iie) {
            throw new InputIntegrityException("Couldn't find xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag, iie);
        }
        if (xpath == null) {
            log.error("Couldn't find xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag);
            throw new InputIntegrityException("Couldn't find xpath with id: " + xpathId);
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        String width = map.get("width");
        log.info("Image width: " + width);
        if (width.equals("auto")) {
            return BindingTraverserXSLT.xpathInjectImage(wmlPackage, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings, sdtParent, contentChild, "0", "0");
        }
        return BindingTraverserXSLT.xpathInjectImage(wmlPackage, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings, sdtParent, contentChild, width, "0");
    }

    public static DocumentFragment xpathInjectImage(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, String cx, String cy) {
        log.info("Falling back to pre-v3 picture processing for " + xpath);
        log.debug("parent: " + sdtParent);
        log.debug("child: " + contentChild);
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            String xpResult = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug(xpath + " yielded result length" + xpResult.length());
            byte[] bytes = Base64.decodeBase64((byte[])xpResult.getBytes("UTF8"));
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
            String filenameHint = null;
            String altText = null;
            int id1 = 0;
            int id2 = 1;
            Inline inline = null;
            long cxl = 0L;
            long cyl = 0L;
            try {
                cxl = Long.parseLong(cx);
                cyl = Long.parseLong(cy);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cxl > 0L && cyl == 0L) {
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false, (int)cxl);
            } else if (cxl == 0L || cyl == 0L) {
                log.debug("image size - from image");
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
            } else {
                log.debug("image size - from content control size");
                ImageSize size = imagePart.getImageInfo().getSize();
                double ratio = (double)size.getHeightPx() / (double)size.getWidthPx();
                log.debug("fit ratio: " + ratio);
                if (ratio > 1.0) {
                    cxl = (long)((double)cyl / ratio);
                } else {
                    cyl = (long)((double)cxl * ratio);
                }
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cxl, cyl, false);
            }
            if (wmlPackage.getTargetPartStore() != null && wmlPackage.getTargetPartStore() instanceof UnzippedPartStore) {
                log.debug("incrementally saving " + imagePart.getPartName().getName());
                ((UnzippedPartStore)wmlPackage.getTargetPartStore()).saveBinaryPart(imagePart);
                ByteBuffer bb = null;
                imagePart.setBinaryData(bb);
                imagePart.setImageInfo(null);
            }
            ObjectFactory factory = Context.getWmlObjectFactory();
            Tc tc = factory.createTc();
            P p = factory.createP();
            if (sdtParent.equals("tr")) {
                tc.getContent().add(p);
            }
            R run = factory.createR();
            Drawing drawing = factory.createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline);
            if (sdtParent.equals("body") || sdtParent.equals("tr") || sdtParent.equals("tc")) {
                p.getContent().add(run);
            }
            Document document = null;
            if (sdtParent.equals("body") || sdtParent.equals("tc")) {
                document = XmlUtils.marshaltoW3CDomDocument(p);
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString((Object)p, true, true));
                }
            } else if (sdtParent.equals("tr")) {
                document = XmlUtils.marshaltoW3CDomDocument(tc);
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString((Object)tc, true, true));
                }
            } else if (sdtParent.equals("p")) {
                document = XmlUtils.marshaltoW3CDomDocument(run);
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString((Object)run, true, true));
                }
            } else if (sdtParent.equals("sdtContent")) {
                log.info("contentChild: " + contentChild);
                if (contentChild.equals("p")) {
                    p.getContent().add(run);
                    document = XmlUtils.marshaltoW3CDomDocument(p);
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.marshaltoString((Object)p, true, true));
                    }
                } else if (contentChild.equals("r")) {
                    document = XmlUtils.marshaltoW3CDomDocument(run);
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.marshaltoString((Object)run, true, true));
                    }
                } else {
                    log.error("how to inject image for unexpected sdt's content: " + contentChild);
                }
            } else {
                log.error("how to inject image for unexpected sdt's parent: " + sdtParent);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String xpathInjectImageRelId(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, Map<String, Xpaths.Xpath> xpathsMap, String tag) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(tag, true);
        String xpathId = map.get("od:xpath");
        log.info("Looking for xpath by id: " + xpathId);
        Xpaths.Xpath xpath = xpathsMap.get(xpathId);
        if (xpath == null) {
            log.warn("Couldn't find xpath with id: " + xpathId);
            return null;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        return BindingTraverserXSLT.xpathInjectImageRelId(wmlPackage, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings);
    }

    public static String xpathInjectImageRelId(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            String xpResult = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug(xpath + " yielded result length" + xpResult.length());
            byte[] bytes = Base64.decodeBase64((byte[])xpResult.getBytes("UTF8"));
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
            if (wmlPackage.getTargetPartStore() != null && wmlPackage.getTargetPartStore() instanceof UnzippedPartStore) {
                log.debug("incrementally saving " + imagePart.getPartName().getName());
                ((UnzippedPartStore)wmlPackage.getTargetPartStore()).saveBinaryPart(imagePart);
                ByteBuffer bb = null;
                imagePart.setBinaryData(bb);
                imagePart.setImageInfo(null);
            }
            return imagePart.getRelLast().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRepeatPositionCondition(Map<String, Xpaths.Xpath> xpathsMap, String odTag) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:RptPosCon");
        log.info("Looking for xpath by id: " + xpathId);
        Xpaths.Xpath xpath = xpathsMap.get(xpathId);
        String expression = xpath.getDataBinding().getXpath();
        log.info(expression);
        return expression;
    }

    public static DocumentFragment nullResultParagraph(String sdtParent, String message) {
        try {
            ObjectFactory factory = Context.getWmlObjectFactory();
            R run = factory.createR();
            Text text = factory.createText();
            text.setValue(message);
            run.getContent().add(text);
            Document docContainer = XmlUtils.neww3cDomDocument();
            if (sdtParent.equals("p")) {
                docContainer = XmlUtils.marshaltoW3CDomDocument(run);
            } else {
                P p = factory.createP();
                p.getContent().add(run);
                docContainer = XmlUtils.marshaltoW3CDomDocument(p);
            }
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DocumentFragment xpathDate(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, NodeIterator dateNodeIt) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        RPr rPr = null;
        for (Object o : sdtPr.getRPrOrAliasOrLock()) {
            if (!((o = XmlUtils.unwrap(o)) instanceof RPr)) continue;
            rPr = (RPr)o;
            break;
        }
        String storeItemId = sdtPr.getDataBinding().getStoreItemID();
        String xpath = sdtPr.getDataBinding().getXpath();
        String prefixMappings = sdtPr.getDataBinding().getPrefixMappings();
        CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            Date date;
            boolean parseException;
            ObjectFactory factory;
            SimpleDateFormat formatter;
            block18: {
                String r = part.xpathGetString(xpath, prefixMappings);
                log.debug(xpath + " yielded result " + r);
                if (r == null) {
                    return BindingTraverserXSLT.nullResultParagraph(sdtParent, "[missing!]");
                }
                CTSdtDate sdtDate = null;
                org.w3c.dom.Node dateNode = dateNodeIt.nextNode();
                if (dateNode != null) {
                    sdtDate = (CTSdtDate)XmlUtils.unmarshal(dateNode, Context.jc, CTSdtDate.class);
                }
                if (r.indexOf("Z") > 0) {
                    r = r.substring(0, r.indexOf("Z") - 1);
                    log.warn("date now " + r);
                }
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                String format = sdtDate.getDateFormat().getVal();
                log.debug("Using format: " + format);
                if (format.contains("dddd")) {
                    format = format.replace("dddd", "EEEE");
                }
                formatter = new SimpleDateFormat(format);
                factory = Context.getWmlObjectFactory();
                parseException = false;
                try {
                    date = dateTimeFormat.parse(r);
                }
                catch (ParseException e) {
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        date = dateFormat.parse(r);
                    }
                    catch (ParseException e2) {
                        log.warn(e.getMessage());
                        date = new Date();
                        parseException = true;
                        if (rPr != null) break block18;
                        rPr = factory.createRPr();
                    }
                }
            }
            String result = formatter.format((Object)date);
            R run = factory.createR();
            if (rPr != null) {
                run.setRPr(rPr);
            }
            if (parseException) {
                Color colorRed = factory.createColor();
                colorRed.setVal("FF0000");
                rPr.setColor(colorRed);
            }
            Text text = factory.createText();
            text.setValue(result);
            run.getContent().add(text);
            Document docContainer = XmlUtils.neww3cDomDocument();
            if (sdtParent.equals("p")) {
                docContainer = XmlUtils.marshaltoW3CDomDocument(run);
            } else {
                P p = factory.createP();
                p.getContent().add(run);
                docContainer = XmlUtils.marshaltoW3CDomDocument(p);
            }
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DocumentFragment convertFlatOPC(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Xpaths.Xpath> xpathsMap, String sdtParent, String contentChild, NodeIterator rPrNodeIt, String tag) {
        try {
            String prefixMappings;
            String xpathExp;
            log.debug("convertFlatOPC extension function for: " + sdtParent + "/w:sdt/w:sdtContent/" + contentChild);
            QueryString qs = new QueryString();
            HashMap<String, String> map = QueryString.parseQueryString(tag, true);
            String xpathId = map.get("od:xpath");
            log.info("Looking for xpath by id: " + xpathId);
            Xpaths.Xpath xpath = xpathsMap.get(xpathId);
            if (xpath == null) {
                log.warn("Couldn't find xpath with id: " + xpathId);
                return null;
            }
            String storeItemId = xpath.getDataBinding().getStoreItemID();
            Object r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpathExp = xpath.getDataBinding().getXpath(), prefixMappings = xpath.getDataBinding().getPrefixMappings());
            if (r == null) {
                return BindingTraverserXSLT.nullResultParagraph(sdtParent, "[missing!]");
            }
            if (!((String)r).startsWith("<?xml")) {
                r = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>\n" + (String)r;
            }
            AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(BindingTraverserXSLT.getNewPartName("/chunk", ".xml", sourcePart.getRelationshipsPart()));
            afiPart.setBinaryData(((String)r).getBytes("UTF-8"));
            afiPart.setAltChunkType(AltChunkType.Xml);
            Relationship altChunkRel = sourcePart.addTargetPart(afiPart);
            afiPart.registerInContentTypeManager();
            CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
            ac.setId(altChunkRel.getId());
            Document docContainer = XmlUtils.marshaltoW3CDomDocument(ac);
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DocumentFragment w14Checkbox(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        if (sdtPrNode == null) {
            log.error("Couldn't get sdtPr!");
            return null;
        }
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode, Context.jc, SdtPr.class);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        RPr sdtRPr = null;
        Object sdtRPrObj = sdtPr.getByClass(RPr.class);
        if (sdtRPrObj != null) {
            sdtRPr = (RPr)sdtRPrObj;
        }
        CTSdtCheckbox sdtCheckbox = (CTSdtCheckbox)sdtPr.getByClass(CTSdtCheckbox.class);
        CTDataBinding dataBinding = sdtPr.getDataBinding();
        CustomXmlPart part = customXmlDataStorageParts.get(dataBinding.getStoreItemID().toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + dataBinding.getStoreItemID());
            return null;
        }
        try {
            Boolean checkBoxResult = BindingTraverserXSLT.getCheckboxResult(dataBinding, part);
            if (checkBoxResult == null) {
                return BindingTraverserXSLT.nullResultParagraph(sdtParent, "[missing!]");
            }
            ObjectFactory factory = Context.getWmlObjectFactory();
            Text text = factory.createText();
            if (checkBoxResult.booleanValue()) {
                text.setValue("\u2612");
            } else {
                text.setValue("\u2610");
            }
            P p = factory.createP();
            R run = factory.createR();
            RPr rpr = factory.createRPr();
            run.setRPr(rpr);
            RFonts rfonts = factory.createRFonts();
            rpr.setRFonts(rfonts);
            rfonts.setEastAsia("MS Gothic");
            rfonts.setHint(STHint.EAST_ASIA);
            rfonts.setHAnsi("MS Gothic");
            rfonts.setAscii("MS Gothic");
            if (sdtRPr != null) {
                if (sdtRPr.getSz() != null) {
                    rpr.setSz(sdtRPr.getSz());
                }
                if (sdtRPr.getSzCs() != null) {
                    rpr.setSzCs(sdtRPr.getSzCs());
                }
            }
            run.getContent().add(text);
            Tc tc = factory.createTc();
            if (sdtParent.equals("tr")) {
                tc.getContent().add(p);
            }
            if (sdtParent.equals("body") || sdtParent.equals("tr") || sdtParent.equals("tc")) {
                p.getContent().add(run);
            }
            Document document = null;
            if (sdtParent.equals("body") || sdtParent.equals("tc")) {
                document = XmlUtils.marshaltoW3CDomDocument(p);
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString((Object)p, true, true));
                }
            } else if (sdtParent.equals("tr")) {
                document = XmlUtils.marshaltoW3CDomDocument(tc);
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString((Object)tc, true, true));
                }
            } else if (sdtParent.equals("p")) {
                document = XmlUtils.marshaltoW3CDomDocument(run);
                if (log.isDebugEnabled()) {
                    log.debug(XmlUtils.marshaltoString((Object)run, true, true));
                }
            } else if (sdtParent.equals("sdtContent")) {
                log.info("contentChild: " + contentChild);
                if (contentChild.equals("p")) {
                    p.getContent().add(run);
                    document = XmlUtils.marshaltoW3CDomDocument(p);
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.marshaltoString((Object)p, true, true));
                    }
                } else if (contentChild.equals("r")) {
                    document = XmlUtils.marshaltoW3CDomDocument(run);
                    if (log.isDebugEnabled()) {
                        log.debug(XmlUtils.marshaltoString((Object)run, true, true));
                    }
                } else {
                    log.error("how to inject checkbox for unexpected sdt's content: " + contentChild);
                }
            } else {
                log.error("how to inject checkbox for unexpected sdt's parent: " + sdtParent);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static Boolean getCheckboxResult(CTDataBinding dataBinding, CustomXmlPart part) throws Docx4JException {
        String r = part.xpathGetString(dataBinding.getXpath(), dataBinding.getPrefixMappings());
        log.debug(dataBinding.getXpath() + " yielded result " + r);
        if (r == null) {
            return null;
        }
        if (r.equals("true") || r.equals("1")) {
            return true;
        }
        return false;
    }

    public static String w14CheckboxAttr(Map<String, CustomXmlPart> customXmlDataStorageParts, NodeIterator sdtPrNodeIt) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        if (sdtPrNode == null) {
            log.error("Couldn't get sdtPr!");
            return "0";
        }
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode, Context.jc, SdtPr.class);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        CTDataBinding dataBinding = sdtPr.getDataBinding();
        CustomXmlPart part = customXmlDataStorageParts.get(dataBinding.getStoreItemID().toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + dataBinding.getStoreItemID());
            return "0";
        }
        try {
            Boolean checkBoxResult = BindingTraverserXSLT.getCheckboxResult(dataBinding, part);
            if (checkBoxResult == null) {
                return "0";
            }
            if (checkBoxResult.booleanValue()) {
                return "1";
            }
            return "0";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "0";
        }
    }

    private static PartName getNewPartName(String prefix, String suffix, RelationshipsPart rp) throws InvalidFormatException {
        PartName proposed = null;
        int i = 1;
        do {
            proposed = i > 1 ? new PartName(prefix + i + suffix) : new PartName(prefix + suffix);
            ++i;
        } while (rp.getRel(proposed) != null);
        return proposed;
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResourceViaProperty("docx4j.model.datastorage.BindingTraverserXSLT.xslt", "org/docx4j/model/datastorage/bind.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        placeholderFragment = null;
        placeholderBytes = null;
        importXHTMLMissing = null;
    }

    public static class BookmarkCounter {
        protected AtomicInteger bookmarkId;

        BookmarkCounter(AtomicInteger bookmarkId) {
            this.bookmarkId = bookmarkId;
        }
    }
}

